/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.ddlutils.model.TypeMap;

public class DefaultValueHelper {
    static /* synthetic */ Class class$0;

    public String convert(String defaultValue, int originalTypeCode, int targetTypeCode) {
        String result = defaultValue;
        if (defaultValue != null) {
            switch (originalTypeCode) {
                case -7: 
                case 16: {
                    result = this.convertBoolean(defaultValue, targetTypeCode).toString();
                    break;
                }
                case 91: {
                    if (targetTypeCode != 93) break;
                    try {
                        Date date = Date.valueOf(result);
                        return new Timestamp(date.getTime()).toString();
                    }
                    catch (IllegalArgumentException date) {
                        break;
                    }
                }
                case 92: {
                    if (targetTypeCode != 93) break;
                    try {
                        Time time = Time.valueOf(result);
                        return new Timestamp(time.getTime()).toString();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    private Object convertBoolean(String defaultValue, int targetTypeCode) {
        Boolean value = null;
        Object result = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            value = (Boolean)ConvertUtils.convert((String)defaultValue, (Class)clazz);
        }
        catch (ConversionException ex) {
            return defaultValue;
        }
        result = targetTypeCode == -7 || targetTypeCode == 16 ? value : (TypeMap.isNumericType(targetTypeCode) ? (value != false ? new Integer(1) : new Integer(0)) : value.toString());
        return result;
    }
}

