/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.h2;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.h2.H2Builder;
import org.apache.ddlutils.platform.h2.H2ModelComparator;
import org.apache.ddlutils.platform.h2.H2ModelReader;

public class H2Platform
extends PlatformImplBase {
    public static final String DATABASENAME = "H2";
    public static final String JDBC_DRIVER = "org.h2.Driver";
    public static final String JDBC_SUBPROTOCOL = "h2";

    public H2Platform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setNonPrimaryKeyIdentityColumnsSupported(false);
        info.setIdentityOverrideAllowed(false);
        info.setMixingIdentityAndNormalPrimaryKeyColumnsSupported(false);
        info.setAlterTableForDropUsed(false);
        info.addEquivalentOnDeleteActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.addEquivalentOnUpdateActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.addNativeTypeMapping(2003, "ARRAY", 2003);
        info.addNativeTypeMapping(2001, "BINARY", -2);
        info.addNativeTypeMapping(0, "BINARY", -2);
        info.addNativeTypeMapping(2006, "BINARY", -2);
        info.addNativeTypeMapping(2002, "BINARY", -2);
        info.addNativeTypeMapping(70, "BINARY", -2);
        info.addNativeTypeMapping(2, "DECIMAL", 3);
        info.addNativeTypeMapping(-1, "VARCHAR", 12);
        info.addNativeTypeMapping(-7, "BOOLEAN", 16);
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.addNativeTypeMapping(5, "SMALLINT", 5);
        info.addNativeTypeMapping(-2, "VARBINARY", -3);
        info.addNativeTypeMapping(-4, "VARBINARY", -3);
        info.addNativeTypeMapping(2004, "BLOB", 2004);
        info.addNativeTypeMapping(2005, "CLOB", 2005);
        info.addNativeTypeMapping(6, "DOUBLE", 8);
        info.addNativeTypeMapping(2000, "OTHER");
        info.setDefaultSize(1, Integer.MAX_VALUE);
        info.setDefaultSize(12, Integer.MAX_VALUE);
        info.setDefaultSize(-2, Integer.MAX_VALUE);
        info.setDefaultSize(-3, Integer.MAX_VALUE);
        this.setSqlBuilder(new H2Builder(this));
        this.setModelReader(new H2ModelReader(this));
    }

    public String getName() {
        return DATABASENAME;
    }

    protected ModelComparator getModelComparator() {
        return new H2ModelComparator(this.getPlatformInfo(), this.getTableDefinitionChangesPredicate(), this.isDelimitedIdentifierModeOn());
    }

    public void shutdownDatabase(Connection connection) {
        Statement stmt = null;
        try {
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate("SHUTDOWN");
            }
            catch (SQLException ex) {
                throw new DdlUtilsException(ex);
            }
        }
        finally {
            this.closeStatement(stmt);
        }
    }

    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof RemoveColumnChange) {
                    Column column = intermediateTable.findColumn(((RemoveColumnChange)change).getChangedColumn(), H2Platform.this.isDelimitedIdentifierModeOn());
                    return !column.isPrimaryKey();
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.isAtEnd() && (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null);
                }
                return change instanceof AddPrimaryKeyChange;
            }
        };
    }

    public void processChange(Database currentModel, CreationParameters params, AddColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column nextColumn = null;
        if (change.getNextColumn() != null) {
            nextColumn = changedTable.findColumn(change.getNextColumn(), this.isDelimitedIdentifierModeOn());
        }
        ((H2Builder)this.getSqlBuilder()).insertColumn(changedTable, change.getNewColumn(), nextColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((H2Builder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

