/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.model.CascadeActionEnum;

public class PlatformInfo {
    private final Log _log;
    private boolean _nullAsDefaultValueRequired;
    private boolean _defaultValuesForLongTypesSupported;
    private boolean _primaryKeyEmbedded;
    private boolean _primaryKeyColumnsHaveToBeRequired;
    private boolean _mixingIdentityAndNormalPrimaryKeyColumnsSupported;
    private boolean _foreignKeysEmbedded;
    private boolean _embeddedForeignKeysNamed;
    private boolean _indicesSupported;
    private boolean _indicesEmbedded;
    private boolean _nonPrimaryKeyIdentityColumnsSupported;
    private boolean _multipleIdentityColumnsSupported;
    private boolean _defaultValueUsedForIdentitySpec;
    private boolean _primaryKeyColumnAutomaticallyRequired;
    private boolean _identityColumnAutomaticallyRequired;
    private boolean _systemIndicesReturned;
    private boolean _systemForeignKeyIndicesAlwaysNonUnique;
    private boolean _syntheticDefaultValueForRequiredReturned;
    private boolean _identityStatusReadingSupported;
    private boolean _sqlCommentsSupported;
    private boolean _delimitedIdentifiersSupported;
    private boolean _alterTableForDropUsed;
    private boolean _identityOverrideAllowed;
    private boolean _lastIdentityValueReadable;
    private boolean _autoCommitModeForLastIdentityValueReading;
    private int _maxTableNameLength;
    private int _maxColumnNameLength;
    private int _maxConstraintNameLength;
    private int _maxForeignKeyNameLength;
    private String _delimiterToken;
    private String _valueQuoteToken;
    private String _commentPrefix;
    private String _commentSuffix;
    private String _sqlCommandDelimiter;
    private HashMap _nativeTypes;
    private HashMap _targetJdbcTypes;
    private HashSet _typesWithNullDefault;
    private HashSet _typesWithSize;
    private HashMap _typesDefaultSizes;
    private HashSet _typesWithPrecisionAndScale;
    private CascadeActionEnum _defaultOnUpdateAction;
    private CascadeActionEnum _defaultOnDeleteAction;
    private HashSet _supportedOnUpdateActions;
    private HashSet _supportedOnDeleteActions;
    private HashMap _equivalentOnUpdateActions;
    private HashMap _equivalentOnDeleteActions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PlatformInfo() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.PlatformInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._nullAsDefaultValueRequired = false;
        this._defaultValuesForLongTypesSupported = true;
        this._primaryKeyEmbedded = true;
        this._primaryKeyColumnsHaveToBeRequired = false;
        this._mixingIdentityAndNormalPrimaryKeyColumnsSupported = true;
        this._foreignKeysEmbedded = false;
        this._embeddedForeignKeysNamed = false;
        this._indicesSupported = true;
        this._indicesEmbedded = false;
        this._nonPrimaryKeyIdentityColumnsSupported = true;
        this._multipleIdentityColumnsSupported = true;
        this._defaultValueUsedForIdentitySpec = false;
        this._primaryKeyColumnAutomaticallyRequired = false;
        this._identityColumnAutomaticallyRequired = false;
        this._systemIndicesReturned = true;
        this._systemForeignKeyIndicesAlwaysNonUnique = false;
        this._syntheticDefaultValueForRequiredReturned = false;
        this._identityStatusReadingSupported = true;
        this._sqlCommentsSupported = true;
        this._delimitedIdentifiersSupported = true;
        this._alterTableForDropUsed = false;
        this._identityOverrideAllowed = true;
        this._lastIdentityValueReadable = true;
        this._autoCommitModeForLastIdentityValueReading = true;
        this._maxTableNameLength = -1;
        this._maxColumnNameLength = -1;
        this._maxConstraintNameLength = -1;
        this._maxForeignKeyNameLength = -1;
        this._delimiterToken = "\"";
        this._valueQuoteToken = "'";
        this._commentPrefix = "--";
        this._commentSuffix = "";
        this._sqlCommandDelimiter = ";";
        this._nativeTypes = new HashMap();
        this._targetJdbcTypes = new HashMap();
        this._typesWithNullDefault = new HashSet();
        this._typesWithSize = new HashSet();
        this._typesDefaultSizes = new HashMap();
        this._typesWithPrecisionAndScale = new HashSet();
        this._defaultOnUpdateAction = CascadeActionEnum.NONE;
        this._defaultOnDeleteAction = CascadeActionEnum.NONE;
        this._supportedOnUpdateActions = new HashSet();
        this._supportedOnDeleteActions = new HashSet();
        this._equivalentOnUpdateActions = new HashMap();
        this._equivalentOnDeleteActions = new HashMap();
        this._typesWithNullDefault.add(new Integer(1));
        this._typesWithNullDefault.add(new Integer(12));
        this._typesWithNullDefault.add(new Integer(-1));
        this._typesWithNullDefault.add(new Integer(2005));
        this._typesWithNullDefault.add(new Integer(-2));
        this._typesWithNullDefault.add(new Integer(-3));
        this._typesWithNullDefault.add(new Integer(-4));
        this._typesWithNullDefault.add(new Integer(2004));
        this._typesWithSize.add(new Integer(1));
        this._typesWithSize.add(new Integer(12));
        this._typesWithSize.add(new Integer(-2));
        this._typesWithSize.add(new Integer(-3));
        this._typesWithPrecisionAndScale.add(new Integer(3));
        this._typesWithPrecisionAndScale.add(new Integer(2));
        this._supportedOnUpdateActions.addAll(CascadeActionEnum.getEnumList());
        this._supportedOnDeleteActions.addAll(CascadeActionEnum.getEnumList());
    }

    public boolean isNullAsDefaultValueRequired() {
        return this._nullAsDefaultValueRequired;
    }

    public void setNullAsDefaultValueRequired(boolean requiresNullAsDefaultValue) {
        this._nullAsDefaultValueRequired = requiresNullAsDefaultValue;
    }

    public boolean isDefaultValuesForLongTypesSupported() {
        return this._defaultValuesForLongTypesSupported;
    }

    public void setDefaultValuesForLongTypesSupported(boolean isSupported) {
        this._defaultValuesForLongTypesSupported = isSupported;
    }

    public boolean isPrimaryKeyEmbedded() {
        return this._primaryKeyEmbedded;
    }

    public void setPrimaryKeyEmbedded(boolean primaryKeyEmbedded) {
        this._primaryKeyEmbedded = primaryKeyEmbedded;
    }

    public boolean isPrimaryKeyColumnsHaveToBeRequired() {
        return this._primaryKeyColumnsHaveToBeRequired;
    }

    public void setPrimaryKeyColumnsHaveToBeRequired(boolean primaryKeyColumnsHaveToBeRequired) {
        this._primaryKeyColumnsHaveToBeRequired = primaryKeyColumnsHaveToBeRequired;
    }

    public boolean isMixingIdentityAndNormalPrimaryKeyColumnsSupported() {
        return this._mixingIdentityAndNormalPrimaryKeyColumnsSupported;
    }

    public void setMixingIdentityAndNormalPrimaryKeyColumnsSupported(boolean mixingIdentityAndNormalPrimaryKeyColumnsSupported) {
        this._mixingIdentityAndNormalPrimaryKeyColumnsSupported = mixingIdentityAndNormalPrimaryKeyColumnsSupported;
    }

    public boolean isForeignKeysEmbedded() {
        return this._foreignKeysEmbedded;
    }

    public void setForeignKeysEmbedded(boolean foreignKeysEmbedded) {
        this._foreignKeysEmbedded = foreignKeysEmbedded;
    }

    public boolean isEmbeddedForeignKeysNamed() {
        return this._embeddedForeignKeysNamed;
    }

    public void setEmbeddedForeignKeysNamed(boolean embeddedForeignKeysNamed) {
        this._embeddedForeignKeysNamed = embeddedForeignKeysNamed;
    }

    public boolean isIndicesSupported() {
        return this._indicesSupported;
    }

    public void setIndicesSupported(boolean supportingIndices) {
        this._indicesSupported = supportingIndices;
    }

    public boolean isIndicesEmbedded() {
        return this._indicesEmbedded;
    }

    public void setIndicesEmbedded(boolean indicesEmbedded) {
        this._indicesEmbedded = indicesEmbedded;
    }

    public boolean isNonPrimaryKeyIdentityColumnsSupported() {
        return this._nonPrimaryKeyIdentityColumnsSupported;
    }

    public void setNonPrimaryKeyIdentityColumnsSupported(boolean supportingNonPKIdentityColumns) {
        this._nonPrimaryKeyIdentityColumnsSupported = supportingNonPKIdentityColumns;
    }

    public boolean isMultipleIdentityColumnsSupported() {
        return this._multipleIdentityColumnsSupported;
    }

    public void setMultipleIdentityColumnsSupported(boolean supportingMultipleIdentityColumns) {
        this._multipleIdentityColumnsSupported = supportingMultipleIdentityColumns;
    }

    public boolean isDefaultValueUsedForIdentitySpec() {
        return this._defaultValueUsedForIdentitySpec;
    }

    public void setDefaultValueUsedForIdentitySpec(boolean identitySpecUsesDefaultValue) {
        this._defaultValueUsedForIdentitySpec = identitySpecUsesDefaultValue;
    }

    public boolean isPrimaryKeyColumnAutomaticallyRequired() {
        return this._primaryKeyColumnAutomaticallyRequired;
    }

    public void setPrimaryKeyColumnAutomaticallyRequired(boolean primaryKeyAutomaticallyRequired) {
        this._primaryKeyColumnAutomaticallyRequired = primaryKeyAutomaticallyRequired;
    }

    public boolean isIdentityColumnAutomaticallyRequired() {
        return this._identityColumnAutomaticallyRequired;
    }

    public void setIdentityColumnAutomaticallyRequired(boolean identityAutomaticallyRequired) {
        this._identityColumnAutomaticallyRequired = identityAutomaticallyRequired;
    }

    public boolean isSystemIndicesReturned() {
        return this._systemIndicesReturned;
    }

    public void setSystemIndicesReturned(boolean returningSystemIndices) {
        this._systemIndicesReturned = returningSystemIndices;
    }

    public boolean isSystemForeignKeyIndicesAlwaysNonUnique() {
        return this._systemForeignKeyIndicesAlwaysNonUnique;
    }

    public void setSystemForeignKeyIndicesAlwaysNonUnique(boolean alwaysNonUnique) {
        this._systemForeignKeyIndicesAlwaysNonUnique = alwaysNonUnique;
    }

    public boolean isSyntheticDefaultValueForRequiredReturned() {
        return this._syntheticDefaultValueForRequiredReturned;
    }

    public void setSyntheticDefaultValueForRequiredReturned(boolean returningDefaultValue) {
        this._syntheticDefaultValueForRequiredReturned = returningDefaultValue;
    }

    public boolean getIdentityStatusReadingSupported() {
        return this._identityStatusReadingSupported;
    }

    public void setIdentityStatusReadingSupported(boolean canReadAutoIncrementStatus) {
        this._identityStatusReadingSupported = canReadAutoIncrementStatus;
    }

    public boolean isSqlCommentsSupported() {
        return this._sqlCommentsSupported;
    }

    public void setSqlCommentsSupported(boolean commentsSupported) {
        this._sqlCommentsSupported = commentsSupported;
    }

    public boolean isDelimitedIdentifiersSupported() {
        return this._delimitedIdentifiersSupported;
    }

    public void setDelimitedIdentifiersSupported(boolean areSupported) {
        this._delimitedIdentifiersSupported = areSupported;
    }

    public boolean isAlterTableForDropUsed() {
        return this._alterTableForDropUsed;
    }

    public void setAlterTableForDropUsed(boolean useAlterTableForDrop) {
        this._alterTableForDropUsed = useAlterTableForDrop;
    }

    public boolean isIdentityOverrideAllowed() {
        return this._identityOverrideAllowed;
    }

    public void setIdentityOverrideAllowed(boolean identityOverrideAllowed) {
        this._identityOverrideAllowed = identityOverrideAllowed;
    }

    public boolean isLastIdentityValueReadable() {
        return this._lastIdentityValueReadable;
    }

    public void setLastIdentityValueReadable(boolean lastIdentityValueReadable) {
        this._lastIdentityValueReadable = lastIdentityValueReadable;
    }

    public boolean isAutoCommitModeForLastIdentityValueReading() {
        return this._autoCommitModeForLastIdentityValueReading;
    }

    public void setAutoCommitModeForLastIdentityValueReading(boolean autoCommitModeForLastIdentityValueReading) {
        this._autoCommitModeForLastIdentityValueReading = autoCommitModeForLastIdentityValueReading;
    }

    public int getMaxTableNameLength() {
        return this._maxTableNameLength;
    }

    public int getMaxColumnNameLength() {
        return this._maxColumnNameLength;
    }

    public int getMaxConstraintNameLength() {
        return this._maxConstraintNameLength;
    }

    public int getMaxForeignKeyNameLength() {
        return this._maxForeignKeyNameLength;
    }

    public void setMaxIdentifierLength(int maxIdentifierLength) {
        this._maxTableNameLength = maxIdentifierLength;
        this._maxColumnNameLength = maxIdentifierLength;
        this._maxConstraintNameLength = maxIdentifierLength;
        this._maxForeignKeyNameLength = maxIdentifierLength;
    }

    public void setMaxTableNameLength(int maxTableNameLength) {
        this._maxTableNameLength = maxTableNameLength;
    }

    public void setMaxColumnNameLength(int maxColumnNameLength) {
        this._maxColumnNameLength = maxColumnNameLength;
    }

    public void setMaxConstraintNameLength(int maxConstraintNameLength) {
        this._maxConstraintNameLength = maxConstraintNameLength;
    }

    public void setMaxForeignKeyNameLength(int maxForeignKeyNameLength) {
        this._maxForeignKeyNameLength = maxForeignKeyNameLength;
    }

    public String getDelimiterToken() {
        return this._delimiterToken;
    }

    public void setDelimiterToken(String delimiterToken) {
        this._delimiterToken = delimiterToken;
    }

    public String getValueQuoteToken() {
        return this._valueQuoteToken;
    }

    public void setValueQuoteToken(String valueQuoteChar) {
        this._valueQuoteToken = valueQuoteChar;
    }

    public String getCommentPrefix() {
        return this._commentPrefix;
    }

    public void setCommentPrefix(String commentPrefix) {
        this._commentPrefix = commentPrefix == null ? "" : commentPrefix;
    }

    public String getCommentSuffix() {
        return this._commentSuffix;
    }

    public void setCommentSuffix(String commentSuffix) {
        this._commentSuffix = commentSuffix == null ? "" : commentSuffix;
    }

    public String getSqlCommandDelimiter() {
        return this._sqlCommandDelimiter;
    }

    public void setSqlCommandDelimiter(String sqlCommandDelimiter) {
        this._sqlCommandDelimiter = sqlCommandDelimiter;
    }

    public String getNativeType(int typeCode) {
        return (String)this._nativeTypes.get(new Integer(typeCode));
    }

    public int getTargetJdbcType(int typeCode) {
        Integer targetJdbcType = (Integer)this._targetJdbcTypes.get(new Integer(typeCode));
        return targetJdbcType == null ? typeCode : targetJdbcType;
    }

    public void addNativeTypeMapping(int jdbcTypeCode, String nativeType) {
        this._nativeTypes.put(new Integer(jdbcTypeCode), nativeType);
    }

    public void addNativeTypeMapping(int jdbcTypeCode, String nativeType, int targetJdbcTypeCode) {
        this.addNativeTypeMapping(jdbcTypeCode, nativeType);
        this._targetJdbcTypes.put(new Integer(jdbcTypeCode), new Integer(targetJdbcTypeCode));
    }

    public void addNativeTypeMapping(String jdbcTypeName, String nativeType) {
        try {
            Field constant;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((constant = clazz.getField(jdbcTypeName)) != null) {
                this.addNativeTypeMapping(constant.getInt(null), nativeType);
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Cannot add native type mapping for undefined jdbc type " + jdbcTypeName), (Throwable)ex);
        }
    }

    public void addNativeTypeMapping(String jdbcTypeName, String nativeType, String targetJdbcTypeName) {
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field sourceType = clazz.getField(jdbcTypeName);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field targetType = clazz2.getField(targetJdbcTypeName);
            if (sourceType != null && targetType != null) {
                this.addNativeTypeMapping(sourceType.getInt(null), nativeType, targetType.getInt(null));
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Cannot add native type mapping for undefined jdbc type " + jdbcTypeName + ", target jdbc type " + targetJdbcTypeName), (Throwable)ex);
        }
    }

    public boolean hasNullDefault(int sqlTypeCode) {
        return this._typesWithNullDefault.contains(new Integer(sqlTypeCode));
    }

    public void setHasNullDefault(int sqlTypeCode, boolean hasNullDefault) {
        if (hasNullDefault) {
            this._typesWithNullDefault.add(new Integer(sqlTypeCode));
        } else {
            this._typesWithNullDefault.remove(new Integer(sqlTypeCode));
        }
    }

    public boolean hasSize(int sqlTypeCode) {
        return this._typesWithSize.contains(new Integer(sqlTypeCode));
    }

    public void setHasSize(int sqlTypeCode, boolean hasSize) {
        if (hasSize) {
            this._typesWithSize.add(new Integer(sqlTypeCode));
        } else {
            this._typesWithSize.remove(new Integer(sqlTypeCode));
        }
    }

    public Integer getDefaultSize(int jdbcTypeCode) {
        return (Integer)this._typesDefaultSizes.get(new Integer(jdbcTypeCode));
    }

    public void setDefaultSize(int jdbcTypeCode, int defaultSize) {
        this._typesDefaultSizes.put(new Integer(jdbcTypeCode), new Integer(defaultSize));
    }

    public void setDefaultSize(String jdbcTypeName, int defaultSize) {
        try {
            Field constant;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((constant = clazz.getField(jdbcTypeName)) != null) {
                this.setDefaultSize(constant.getInt(null), defaultSize);
            }
        }
        catch (Exception ex) {
            this._log.warn((Object)("Cannot add default size for undefined jdbc type " + jdbcTypeName), (Throwable)ex);
        }
    }

    public boolean hasPrecisionAndScale(int sqlTypeCode) {
        return this._typesWithPrecisionAndScale.contains(new Integer(sqlTypeCode));
    }

    public void setHasPrecisionAndScale(int sqlTypeCode, boolean hasPrecisionAndScale) {
        if (hasPrecisionAndScale) {
            this._typesWithPrecisionAndScale.add(new Integer(sqlTypeCode));
        } else {
            this._typesWithPrecisionAndScale.remove(new Integer(sqlTypeCode));
        }
    }

    public void setSupportedOnUpdateActions(CascadeActionEnum[] actions) {
        this._supportedOnUpdateActions.clear();
        this._supportedOnUpdateActions.addAll(Arrays.asList(actions));
    }

    public boolean isActionSupportedForOnUpdate(CascadeActionEnum action) {
        return this._supportedOnUpdateActions.contains((Object)action);
    }

    public void setSupportedOnDeleteActions(CascadeActionEnum[] actions) {
        this._supportedOnDeleteActions.clear();
        this._supportedOnDeleteActions.addAll(Arrays.asList(actions));
    }

    public boolean isActionSupportedForOnDelete(CascadeActionEnum action) {
        return this._supportedOnDeleteActions.contains((Object)action);
    }

    public CascadeActionEnum getDefaultOnUpdateAction() {
        return this._defaultOnUpdateAction;
    }

    public void setDefaultOnUpdateAction(CascadeActionEnum defaultOnUpdateAction) {
        this._defaultOnUpdateAction = defaultOnUpdateAction;
    }

    public CascadeActionEnum getDefaultOnDeleteAction() {
        return this._defaultOnDeleteAction;
    }

    public void setDefaultOnDeleteAction(CascadeActionEnum defaultOnDeleteAction) {
        this._defaultOnDeleteAction = defaultOnDeleteAction;
    }

    public void addEquivalentOnUpdateActions(CascadeActionEnum actionA, CascadeActionEnum actionB) {
        if (!actionA.equals((Object)actionB)) {
            HashSet<CascadeActionEnum> actionsEquivalentToActionA = (HashSet<CascadeActionEnum>)this._equivalentOnUpdateActions.get((Object)actionA);
            HashSet<CascadeActionEnum> actionsEquivalentToActionB = (HashSet<CascadeActionEnum>)this._equivalentOnUpdateActions.get((Object)actionB);
            if (actionsEquivalentToActionA == null) {
                actionsEquivalentToActionA = new HashSet<CascadeActionEnum>();
                this._equivalentOnUpdateActions.put(actionA, actionsEquivalentToActionA);
            }
            if (actionsEquivalentToActionB == null) {
                actionsEquivalentToActionB = new HashSet<CascadeActionEnum>();
                this._equivalentOnUpdateActions.put(actionB, actionsEquivalentToActionB);
            }
            actionsEquivalentToActionA.add(actionB);
            actionsEquivalentToActionB.add(actionA);
        }
    }

    public boolean areEquivalentOnUpdateActions(CascadeActionEnum actionA, CascadeActionEnum actionB) {
        Set actionsEquivalentToActionA = (Set)this._equivalentOnUpdateActions.get((Object)actionA);
        return actionsEquivalentToActionA == null ? false : actionsEquivalentToActionA.contains((Object)actionB);
    }

    public void addEquivalentOnDeleteActions(CascadeActionEnum actionA, CascadeActionEnum actionB) {
        if (!actionA.equals((Object)actionB)) {
            HashSet<CascadeActionEnum> actionsEquivalentToActionA = (HashSet<CascadeActionEnum>)this._equivalentOnDeleteActions.get((Object)actionA);
            HashSet<CascadeActionEnum> actionsEquivalentToActionB = (HashSet<CascadeActionEnum>)this._equivalentOnDeleteActions.get((Object)actionB);
            if (actionsEquivalentToActionA == null) {
                actionsEquivalentToActionA = new HashSet<CascadeActionEnum>();
                this._equivalentOnDeleteActions.put(actionA, actionsEquivalentToActionA);
            }
            if (actionsEquivalentToActionB == null) {
                actionsEquivalentToActionB = new HashSet<CascadeActionEnum>();
                this._equivalentOnDeleteActions.put(actionB, actionsEquivalentToActionB);
            }
            actionsEquivalentToActionA.add(actionB);
            actionsEquivalentToActionB.add(actionA);
        }
    }

    public boolean areEquivalentOnDeleteActions(CascadeActionEnum actionA, CascadeActionEnum actionB) {
        Set actionsEquivalentToActionA = (Set)this._equivalentOnDeleteActions.get((Object)actionA);
        return actionsEquivalentToActionA == null ? false : actionsEquivalentToActionA.contains((Object)actionB);
    }
}

