/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class AddPrimaryKeyChange
extends TableChangeImplBase {
    private String[] _primaryKeyColumns;

    public AddPrimaryKeyChange(String tableName, String[] primaryKeyColumns) {
        super(tableName);
        if (primaryKeyColumns == null) {
            this._primaryKeyColumns = new String[0];
        } else {
            this._primaryKeyColumns = new String[primaryKeyColumns.length];
            System.arraycopy(primaryKeyColumns, 0, this._primaryKeyColumns, 0, primaryKeyColumns.length);
        }
    }

    public String[] getPrimaryKeyColumns() {
        String[] result = new String[this._primaryKeyColumns.length];
        System.arraycopy(this._primaryKeyColumns, 0, result, 0, this._primaryKeyColumns.length);
        return result;
    }

    public void apply(Database model, boolean caseSensitive) {
        Table table = this.findChangedTable(model, caseSensitive);
        int idx = 0;
        while (idx < this._primaryKeyColumns.length) {
            Column column = table.findColumn(this._primaryKeyColumns[idx], caseSensitive);
            column.setPrimaryKey(true);
            ++idx;
        }
    }
}

