/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.io.ModelXmlWriter;
import org.apache.ddlutils.io.XMLUtils;
import org.apache.ddlutils.model.Column;

public class ColumnXmlWriter
extends ModelXmlWriter {
    private final int AS_TABLE_ATTRIBUTE = 0;
    private final int AS_SUBTAG = 1;
    private final int AS_COLUMN_ATTRIBUTE = 2;
    private final int AS_VALUE = 3;
    private final String columnName;
    private final String columnValue;
    private final boolean nameBase64Encoded;
    private final boolean valueBase64Encoded;
    private final int columnFormattingMethod;

    public ColumnXmlWriter(Column column, String value) {
        if (XMLUtils.hasIllegalXMLCharacters(value)) {
            this.columnValue = XMLUtils.base64Encode(value);
            this.valueBase64Encoded = true;
        } else {
            this.columnValue = value;
            this.valueBase64Encoded = false;
        }
        if (XMLUtils.hasIllegalXMLCharacters(column.getName())) {
            this.columnName = XMLUtils.base64Encode(column.getName());
            this.nameBase64Encoded = true;
            this.columnFormattingMethod = 3;
        } else {
            this.columnName = column.getName();
            this.nameBase64Encoded = false;
            this.columnFormattingMethod = this.columnName.length() > 255 ? 3 : ("table-name".equals(this.columnName) || "base64".equals(this.columnName) || !XMLUtils.isWellFormedXMLName(this.columnName) ? 2 : (this.valueBase64Encoded || value.length() > 255 ? 1 : 0));
        }
    }

    public boolean writeAttribute(DataWriter writer) {
        if (this.columnFormattingMethod == 0) {
            writer.writeAttribute(null, this.columnName, this.columnValue);
            return true;
        }
        return false;
    }

    public boolean writeSubElement(DataWriter writer) {
        if (this.columnFormattingMethod != 0) {
            writer.printlnIfPrettyPrinting();
            writer.indentIfPrettyPrinting(2);
            if (this.columnFormattingMethod == 1) {
                writer.writeElementStart(null, this.columnName);
                this.writeText(writer, this.columnValue, this.valueBase64Encoded);
            } else {
                writer.writeElementStart(null, "column");
                if (this.columnFormattingMethod == 2) {
                    writer.writeAttribute(null, "column-name", this.columnName);
                    this.writeText(writer, this.columnValue, this.valueBase64Encoded);
                } else if (this.columnFormattingMethod == 3) {
                    writer.printlnIfPrettyPrinting();
                    writer.indentIfPrettyPrinting(3);
                    writer.writeElementStart(null, "column-name");
                    this.writeText(writer, this.columnName, this.nameBase64Encoded);
                    writer.writeElementEnd();
                    writer.printlnIfPrettyPrinting();
                    writer.indentIfPrettyPrinting(3);
                    writer.writeElementStart(null, "column-value");
                    this.writeText(writer, this.columnValue, this.valueBase64Encoded);
                    writer.writeElementEnd();
                    writer.printlnIfPrettyPrinting();
                    writer.indentIfPrettyPrinting(2);
                }
            }
            writer.writeElementEnd();
            return true;
        }
        return false;
    }
}

