/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.io.XMLUtils;

public abstract class ModelXmlWriter {
    protected void writeText(DataWriter writer, String value, boolean isBase64Encoded) {
        if (isBase64Encoded) {
            writer.writeAttribute(null, "base64", "true");
            writer.writeCharacters(value);
        } else {
            List cutPoints = XMLUtils.findCDataCutPoints(value);
            if (cutPoints.isEmpty()) {
                writer.writeCharacters(value);
            } else {
                int lastPos = 0;
                Iterator cutPointIt = cutPoints.iterator();
                while (cutPointIt.hasNext()) {
                    int curPos = (Integer)cutPointIt.next();
                    writer.writeCData(value.substring(lastPos, curPos));
                    lastPos = curPos;
                }
                if (lastPos < value.length()) {
                    writer.writeCData(value.substring(lastPos));
                }
            }
        }
    }
}

