/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.IOException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

final class PEMUtilities {
    PEMUtilities() {
    }

    static byte[] crypt(boolean bl, String string, byte[] byArray, char[] cArray, String string2, byte[] byArray2) throws IOException {
        SecretKey secretKey;
        String string3;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string4 = "CBC";
        String string5 = "PKCS5Padding";
        if (string2.endsWith("-CFB")) {
            string4 = "CFB";
            string5 = "NoPadding";
        }
        if (string2.endsWith("-ECB") || "DES-EDE".equals(string2) || "DES-EDE3".equals(string2)) {
            string4 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string2.endsWith("-OFB")) {
            string4 = "OFB";
            string5 = "NoPadding";
        }
        if (string2.startsWith("DES-EDE")) {
            string3 = "DESede";
            boolean bl2 = !string2.startsWith("DES-EDE3");
            secretKey = PEMUtilities.getKey(cArray, string3, 24, byArray2, bl2);
        } else if (string2.startsWith("DES-")) {
            string3 = "DES";
            secretKey = PEMUtilities.getKey(cArray, string3, 8, byArray2);
        } else if (string2.startsWith("BF-")) {
            string3 = "Blowfish";
            secretKey = PEMUtilities.getKey(cArray, string3, 16, byArray2);
        } else if (string2.startsWith("RC2-")) {
            string3 = "RC2";
            int n = 128;
            if (string2.startsWith("RC2-40-")) {
                n = 40;
            } else if (string2.startsWith("RC2-64-")) {
                n = 64;
            }
            secretKey = PEMUtilities.getKey(cArray, string3, n / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n) : new RC2ParameterSpec(n, byArray2);
        } else if (string2.startsWith("AES-")) {
            int n;
            string3 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string2.startsWith("AES-128-")) {
                n = 128;
            } else if (string2.startsWith("AES-192-")) {
                n = 192;
            } else if (string2.startsWith("AES-256-")) {
                n = 256;
            } else {
                throw new IOException("unknown AES encryption with private key");
            }
            secretKey = PEMUtilities.getKey(cArray, "AES", n / 8, byArray3);
        } else {
            throw new IOException("unknown encryption with private key");
        }
        String string6 = string3 + "/" + string4 + "/" + string5;
        try {
            int n;
            Cipher cipher = Cipher.getInstance(string6, string);
            int n2 = n = bl ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n, secretKey);
            } else {
                cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException("exception using cipher - please check password and data: " + exception.toString());
        }
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray) throws IOException {
        return PEMUtilities.getKey(cArray, string, n, byArray, false);
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray, boolean bl) throws IOException {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        KeyParameter keyParameter = (KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8);
        byte[] byArray2 = keyParameter.getKey();
        if (bl && byArray2.length >= 24) {
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
        }
        return new SecretKeySpec(byArray2, string);
    }
}

