package com.idrsolutions.pdf.acroforms.xfa;

import org.jpedal.objects.raw.FormObject;

/** to be used with new xfa code ONLY*/
public class XFAFormObjectv2 extends FormObject{
	
	//########### static keys
	//layout of objects
	/** flowed left to right, top to bottom */
    final static protected int LAYOUT_LRTB = 1107117166;
    /** flowed right to left top to bottom */
    final static protected int LAYOUT_RLTB = 1006453876;
    /** inner element of table,<br />
     * The objects contained in this element are cells of the table and 
     * their height and width attributes, if any, are ignored. The cells are 
     * laid out from right to left and each one is adjusted to the height of 
     * the row and the width of one or more contiguous columns.
     */
    final static protected int LAYOUT_ROW = 4341575;
    /** outer element of table, each child must have its layout as row, 
     * rows laid out top to bottom
     */
    final static protected int LAYOUT_TABLE = 825375865;
    /** flowed top to bottom */
    final static protected int LAYOUT_TB = 17458;
    /** positioned according to the location on the content elements*/
    final static protected int LAYOUT_POSITION = -2072477065;
    
    //horizontal alignement
    /** center horizontally */
    final static protected int ALIGN_CENTER = 1044670583;
    /**spread justify all lines, except last line which is left aligned.*/
    final static protected int ALIGN_JUSTIFY = 1148418956;
    /**spread justify all lines to fill region*/
    final static protected int ALIGN_JUSTIFYALL = -1940541513;
    /** align left*/
    final static protected int ALIGN_LEFT = 1010120260;
    /** align right*/
    final static protected int ALIGN_RIGHT = 959920262;
    /** Align the radix indicator (decimal point or comma, depending upon locale) at the location specified 
     * by the radixOffset property of the para element. If there is no radix indicator, the last character is 
     * assumed to represent the units column.
     */
    final static protected int ALIGN_RADIX = 825506186;
    
    //vertical alignment
    /**align top*/
    final static protected int ALIGN_TOP = 4472640;
    /** center vertically*/
    final static protected int ALIGN_MIDDLE = 875854190;
    /**align bottom */
    final static protected int ALIGN_BOTTOM = 1145336188;
    final static protected int ALIGN_TABDEFAULT = 1666823595;//reserved??
    final static protected int ALIGN_TABSTOPS = -2005896602;//reserved??
    
    //handedness
    /** center displayed line on the underlying vector or arc */
    final static protected int HAND_EVEN = 893793598;
    /** when following line from start to end, position line to left of underlying vector or arc*/
    final static protected int HAND_LEFT = 1010120260;
    /** when following line from start to end, position line to right of underlying vector or arc*/
    final static protected int HAND_RIGHT = 959920262;
    
    /** the definitions of the stroke of a line*/
    final static protected int STROKE_SOLID = 1060911479;
    final static protected int STROKE_DASHED = 1127770469;
    final static protected int STROKE_DOTTED = 1145334131;
    final static protected int STROKE_DASHDOT = 944271495;
    final static protected int STROKE_DASHDOTDOT = -2025027660;
    final static protected int STROKE_LOWERED = 897479803;
    final static protected int STROKE_RAISED = 960722789;
    final static protected int STROKE_ETCHED = 859335288;
    final static protected int STROKE_EMBOSSED = 2021681011;
	
	private float width,height;
	private String fontStyle;
	private int horizontalAlign = ALIGN_LEFT,verticalAlign = ALIGN_TOP,
		hand = HAND_EVEN,stroke = STROKE_SOLID
		;

	public void setHeight(float propH) {
		height = propH;
	}

	public void setWidth(float propW){
		width = propW;
	}

	public void setFontStyle(String propTypeface) {
		fontStyle = propTypeface;
	}

	public void setHorizontalAlignment(int prophAlign) {
		horizontalAlign = prophAlign;
	}

	public void setVerticalAlignment(int propvAlign) {
		verticalAlign = propvAlign;
	}

	public void setHandedness(int propHand) {
		hand = propHand;
	}

	public void setStroke(int propStroke) {
		stroke = propStroke;
	}
}
