package org.jpedal.decompression;

public class CCITTDecoder {
	
	/**enum Mode{CCITT_1D,CCITT_MIX,CCITT_2D}							// Modes of operation
	enum Color {WHITE, BLACK}										// Colours of runs
	
	private int EOL = -1;
	private int bsLength = 0;
	private BitSet outSet;
	private CusotomBitSet set;
	private Mode mode = Mode.CCITT_1D;				    			// current CCITT coding scheme. def. set
	private Color color = Color.WHITE;								// current colour
	
	
	// ========== output ====================
	private int[] lastLine = null;									// reference line
	private int[] currentLine = null;								// currently used line
	private int clPtr = 1;											// current line pointer
	// ======================================
	


	private long [][] white = {
			{1222, 2, 0},
			{2111, 3, 0},
			{2122, 4, 0},
			{2211, 5, 0},
			{2221, 6, 0},
			{2222, 7, 0},
			{21122, 8, 0},
			{21211, 9, 0},
			{11222, 10, 0},
			{12111, 11, 0},
			{22122, 64, 1},
			{21121, 128, 1},
			{111222, 1, 0},
			{112111, 12, 0},
			{111122, 13, 0},
			{221211, 14, 0},
			{221212, 15, 0},
			{212121, 16, 0},
			{212122, 17, 0},
			{121222, 192, 1},
			{122111, 1664, 1},
			{1211222, 18, 0},
			{1112211, 19, 0},
			{1112111, 20, 0},
			{1121222, 21, 0},
			{1111122, 22, 0},
			{1111211, 23, 0},
			{1212111, 24, 0},
			{1212122, 25, 0},
			{1121122, 26, 0},
			{1211211, 27, 0},
			{1122111, 28, 0},
			{1221222, 256, 1},
			{11221212, 0, 0},
			{11111121, 29, 0},
			{11111122, 30, 0},
			{11122121, 31, 0},
			{11122122, 32, 0},
			{11121121, 33, 0},
			{11121122, 34, 0},
			{11121211, 35, 0},
			{11121212, 36, 0},
			{11121221, 37, 0},
			{11121222, 38, 0},
			{11212111, 39, 0},
			{11212112, 40, 0},
			{11212121, 41, 0},
			{11212122, 42, 0},
			{11212211, 43, 0},
			{11212212, 44, 0},
			{11111211, 45, 0},
			{11111212, 46, 0},
			{11112121, 47, 0},
			{11112122, 48, 0},
			{12121121, 49, 0},
			{12121122, 50, 0},
			{12121211, 51, 0},
			{12121212, 52, 0},
			{11211211, 53, 0},
			{11211212, 54, 0},
			{12122111, 55, 0},
			{12122112, 56, 0},
			{12122121, 57, 0},
			{12122122, 58, 0},
			{12112121, 59, 0},
			{12112122, 60, 0},
			{11221121, 61, 0},
			{11221122, 62, 0},
			{11221211, 63, 0},
			{11221221, 320, 1},
			{11221222, 384, 1},
			{12211211, 448, 1},
			{12211212, 512, 1},
			{12212111, 576, 1},
			{12211222, 640, 1},
			{122112211, 704, 1},
			{122112212, 768, 1},
			{122121121, 832, 1},
			{122121122, 896, 1},
			{122121211, 960, 1},
			{122121212, 1024, 1},
			{122121221, 1088, 1},
			{122121222, 1152, 1},
			{122122111, 1216, 1},
			{122122112, 1280, 1},
			{122122121, 1344, 1},
			{122122122, 1408, 1},
			{121122111, 1472, 1},
			{121122112, 1536, 1},
			{121122121, 1600, 1},
			{121122122, 1728, 1},
			{11111112111L, 1792, 1},
			{11111112211L, 1856, 1},
			{11111112212L, 1920, 1},
			{111111111112L, EOL, 1},
			{111111121121L, 1984, 1},
			{111111121122L, 2048, 1},
			{111111121211L, 2112, 1},
			{111111121212L, 2176, 1},
			{111111121221L, 2240, 1},
			{111111121222L, 2304, 1},
			{111111122211L, 2368, 1},
			{111111122212L, 2432, 1},
			{111111122221L, 2496, 1},
			{111111122222L, 2560, 1}
	};
	
	private long [][] black = {
			{22, 2, 0},
			{21, 3, 0},		
			{121, 1, 0},
			{122, 4, 0},
			{1122, 5, 0},
			{1121, 6, 0},
			{11122, 7, 0},
			{111212, 8,0},
			{111211, 9,0},
			{1111211, 10, 0},
			{1111212, 11, 0},
			{1111222, 12, 0},
			{11111211, 13, 0},
			{11111222, 14, 0},
			{111122111, 15, 0},
			{1111221222, 0, 0},
			{1111121222, 16, 0},
			{1111122111, 17, 0},
			{1111112111, 18, 0},
			{1111112222, 64, 1},
			{11112211222L, 19, 0},
			{11112212111L, 20, 0},
			{11112212211L, 21, 0},
			{11111221222L, 22, 0},
			{11111212111L, 23, 0},
			{11111121222L, 24, 0},
			{11111122111L, 25, 0},
			{11111112111L, 1792, 1},
			{11111112211L, 1856, 1},
			{11111112212L, 1920, 1},	
			{111122112121L, 26, 0},
			{111122112122L, 27, 0},
			{111122112211L, 28, 0},
			{111122112212L, 29, 0},
			{111112212111L, 30, 0},
			{111112212112L, 31, 0},
			{111112212121L, 32, 0},
			{111112212122L, 33, 0},
			{111122121121L, 34, 0},
			{111122121122L, 35, 0},
			{111122121211L, 36, 0},
			{111122121212L, 37, 0},
			{111122121221L, 38, 0},
			{111122121222L, 39, 0},
			{111112212211L, 40, 0},
			{111112212212L, 41, 0},
			{111122122121L, 42, 0},
			{111122122122L, 43, 0},
			{111112121211L, 44, 0},
			{111112121212L, 45, 0},
			{111112121221L, 46, 0},
			{111112121222L, 47, 0},
			{111112211211L, 48, 0},
			{111112211212L, 49, 0},
			{111112121121L, 50, 0},
			{111112121122L, 51, 0},
			{111111211211L, 52, 0},
			{111111221222L, 53, 0},
			{111111222111L, 54, 0},
			{111111211222L, 55, 0},
			{111111212111L, 56, 0},
			{111112122111L, 57, 0},
			{111112122112L, 58, 0},
			{111111212122L, 59, 0},
			{111111212211L, 60, 0},
			{111112122121L, 61, 0},
			{111112211221L, 62, 0},
			{111112211222L, 63, 0},
			{111122112111L, 128, 1},
			{111122112112L, 192, 1},
			{111112122122L, 256, 1},
			{111111221122L, 320, 1},
			{111111221211L, 384, 1},
			{111111221212L, 448, 1},
			{111111111112L, EOL, 1},
			{111111121121L, 1984, 1},
			{111111121122L, 2048, 1},
			{111111121211L, 2112, 1},
			{111111121212L, 2176, 1},
			{111111121221L, 2240, 1},
			{111111121222L, 2304, 1},
			{111111122211L, 2368, 1},
			{111111122212L, 2432, 1},
			{111111122221L, 2496, 1},
			{111111122222L, 2560, 1},
			{1111112212211L, 512, 1},
			{1111112212212L, 576, 1},
			{1111112112121L, 640, 1},
			{1111112112122L, 704, 1},
			{1111112112211L, 768, 1},
			{1111112112212L, 832, 1},
			{1111112221121L, 896, 1},
			{1111112221122L, 960, 1},
			{1111112221211L, 1024, 1},
			{1111112221212L, 1088, 1},
			{1111112221221L, 1152, 1},
			{1111112221222L, 1216, 1},
			{1111112121121L, 1280, 1},
			{1111112121122L, 1344, 1},
			{1111112121211L, 1408, 1},
			{1111112121212L, 1472, 1},
			{1111112122121L, 1536, 1},
			{1111112122122L, 1600, 1},
			{1111112211211L, 1664, 1},
			{1111112211212L, 1728, 1}
	};
	
	private int [][] modes = {
			{2,1},										// V(0)
			{122,2},									// VR(1)
			{121,3},									// VL(1)
			{112,4},									// H [Horizontal (followed by W&B)]
			{1112,5},									// P [Pass]
			{111122,6},									// VR(2)
			{111121,7},									// VL(2)
			{1111122,8},								// VR(3)
			{1111121,9}									// VL(3)
	};
	
	// CCITT stream parameters
	private int width=1728;								// aka. Columns (def. 1728, set)
	private int height=0; 								// aka. Rows
	private int k = 0;									// indicates which scheme is in use						
	private boolean endOfLine = false;					// are EOL bit patterns req? def. set
	private boolean encodedByteAlign = false;			// is data byte-aligned? def. set
	private boolean endOfBlock = true;					// are rows term. by EOFB (over-rideing rows parameter)
	private boolean blackIs1 = false;					// are 1 to be treated as black pixels
	private int damagedRowsBeforeError = 0;				// how many damaged rows should be tolerated before flaging up an error
	
	public CCITTDecoder(byte[] data, PdfObject pdfObj){

		// work out coding scheme
		k = pdfObj.getInt(PdfDictionary.K);
		
		if(k==0){
			mode = Mode.CCITT_1D;
		}else if(k<0){
			mode = Mode.CCITT_2D;
		}else{
			mode = Mode.CCITT_MIX;
		}
		
		// what is the width of the image (if not defined set to default)
		width = pdfObj.getInt(PdfDictionary.Columns);
		
		if(width == 0){
			width = 1728;
		}else{
			if((width%8)!=0){
				int topUp = 8 - (width%8);
				
				// width adjusted so that each line starts on a byte boundary.
				System.out.println("# width adjusted");
				width += topUp;
			}
		}
		
		height = pdfObj.getInt(PdfDictionary.Rows);
		
		endOfLine = pdfObj.getBoolean(PdfDictionary.EndOfLine);
		encodedByteAlign = pdfObj.getBoolean(PdfDictionary.EncodedByteAlign);
		endOfBlock = pdfObj.getBoolean(PdfDictionary.EndOfBlock);
		blackIs1 = pdfObj.getBoolean(PdfDictionary.BlackIs1);
		damagedRowsBeforeError = pdfObj.getInt(PdfDictionary.DamagedRowsBeforeError);
		
		System.out.println("<<CCITTFaxDecode Params> /k=" + k + " /width=" + width + " /height=" + height + " /endOfLine=" +endOfLine+ " /encodedByteAlign=" + encodedByteAlign+ " /endOfBlock=" + endOfBlock+ " /blackIs1=" + blackIs1 + " /damagedRowsBeforeError=" + damagedRowsBeforeError + " >");

		outSet = fromByteArray(data);
		set = new CusotomBitSet(outSet, bsLength);
		
		currentLine = new int[width+1];
		lastLine = new int[width+1];
		

		System.out.println("");
		for(int i=0;i<1000;i++){
			if(outSet.get(i))
				System.out.print("1");
			else
				System.out.print("0");
		}
		System.out.println("");
	}
	
	public byte[] decode(){

		boolean loop = true;
		int res = 0;
		
		if(mode != Mode.CCITT_1D && mode != Mode.CCITT_2D){
			res = getNextRunToken();
		}

		
		
		while(loop){
			if(mode == Mode.CCITT_MIX){
				int extraBit = set.getSingleDigit();
				if(extraBit==2){
					mode = Mode.CCITT_1D;
				}else if (extraBit==1){
					mode = Mode.CCITT_2D;
				}else{
					loop = false;
					System.out.println("# EOFS!");
					break;
				}
			}else if (mode == Mode.CCITT_1D){
				decodeNextLine_1D();
				
				if(k>0){
					mode = Mode.CCITT_MIX;
				}
			}else{
				decodeNextLine_2D();
			}
			
			
			if(res == -2){
				loop = false;
				System.out.println("# EOFS!");
			}else if (res == -1){
				// reached EOL so reset parameters
				color = Color.WHITE;
			}else{
				
			}
		}
		
		
		return null;
	}
	
	private int getNextRunToken(){
		
		int digit = set.getSingleDigit();
		long val = 0;

		// this loop is just to be used for finding single entries (EOL, runs etc.)
		while(digit!=0){
			// append new value to number
			val = (val*10) + digit;
			// security check (to be removed at once all is working fine)
			if(val > 2222222222222L){
				System.err.println("# Just passed the 13 digit mark and not found a match! Exit.");
			
			}
			
			// ================================================================================================
			
			if(color == Color.WHITE){
				for(int i=0;i<white.length;i++){
					if(white[i][0] == val){
						System.out.println("WHITE RUN: " + white[i][1]);
						return (int)white[i][1];
					}
				}
				
			}else{
				for(int i=0;i<black.length;i++){
					if(black[i][0] == val){
						System.out.println("BLACK RUN: " + black[i][1]);
						return (int)black[i][1];
					}
				}
			}

			// ================================================================================================
			digit = set.getSingleDigit();
			
		}
		
		// this will indicate that there are no more tokens left
		return -2;
	}
	
	private int get_2D_Mode(){
		
		int digit = set.getSingleDigit();
		long val = 0;

		// this loop is just to be used for finding single entries (modes)
		while(digit!=0){
			// append new value to number
			val = (val*10) + digit;
			// security check (to be removed at once all is working fine)
			if(val > 2222222L){
				System.err.println("# Just passed the 3 digit mark and not found a valid mode! Exit.");
				
			}
			
			// ================================================================================================
			
			
			for(int i=0;i<modes.length;i++){
				if(modes[i][0] == val){
					System.out.println("MODE FOUND: " + modes[i][1]);
					return (int)modes[i][1];
				}
			}


			// ================================================================================================
			digit = set.getSingleDigit();
			
		}
		
		// this will indicate that there are no more tokens left
		return -2;
	}
	
	private void decodeNextLine_1D(){
		System.out.println("# RUNNING IN 1D MODE");
		boolean more = true;
		int res = 0;
		
		while(more){
			res = getNextRunToken();
			
			
			if(color == Color.WHITE){
				if(res<=63){
					color = Color.BLACK;
				}
				outputData(1,res);
				
			}else{
				if(res<=63){
					color = Color.WHITE;
				}
				outputData(0,res);
			}
			
			
			if(res == -1){
				more = false;
			}
		}
		
		alignReferenceLine();
		
	}
	
	private void alignReferenceLine() {
		System.arraycopy(currentLine, 0, lastLine, 0, currentLine.length);
		
		// remember to reset the pointer
		clPtr = 1;
		
	}

	private void outputData(int color, int res) {
		
		if(blackIs1){
			for(int i=clPtr;i<res;i++,clPtr++){
				currentLine[clPtr]=color;
			}
		}else{

			if(color==1){
				color = 0;
			}else{
				color = 1;
			}
			
			for(int i=clPtr;i<res;i++,clPtr++){
				currentLine[clPtr]=color;
			}
		}
		
	}

	private void decodeNextLine_2D(){
		System.out.println("# 2D MODE ACTIVE");
		
		boolean more = true;
		int mode = 0;
		
		
		while(more){
			mode = get_2D_Mode();
			
			switch(mode){
				case 1:
					// V(0)
					for(;clPtr<lastLine.length;clPtr++){
						if(lastLine[clPtr]!=lastLine[clPtr-1]){
							break;
						}
						
						currentLine[clPtr] = lastLine[clPtr];
					}
					
					
					break;
					
				default:
					System.out.println("# NOT YET IMPLEMENTED!. EXIT");
				
					break;
			}
			
			if((clPtr)==lastLine.length){
				more = false;
			}
		}
		
	}
	
	private BitSet fromByteArray(byte[] bytes) {
		
		int bitSetPtr = 0;
		byte tmp;
		int value = 0;
        BitSet bits = new BitSet();
        for (int i=0; i<bytes.length; i++) {
        	tmp=bytes[i];
        	for(int z=7;z>=0;z--){
        		
        		value = (tmp & (1 << z));
        		
        		if(value>=1)
        			bits.set(bitSetPtr,true);

        		bitSetPtr++;
        	}
        }
        
        // will give a true length of the BitSet as bits.lenght only counts till the last 1 in stream!
        bsLength = bitSetPtr;
        
        return bits;
        
	}
    /**/
}
