/**
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.jpedal.org
 *
 * (C) Copyright 2010, IDRsolutions and Contributors.
 *
 * 	This file is part of JPedal
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  *
  * ---------------

  * ObjectCloneFactory.java
  * ---------------
  * (C) Copyright 2010, by IDRsolutions and Contributors.
  *
  *
  * --------------------------
 */
package org.jpedal.utils;

/**
 * custom optimised cloning code for speed
 */
public class ObjectCloneFactory {

    public static int[] cloneArray(int[] array){

        if(array==null)
        return null;

        int count=array.length;

        int[] returnValue=new int[count];

        System.arraycopy(array,0,returnValue,0,count);

        return returnValue;

    }

    public static float[] cloneArray(float[] array){

        if(array==null)
        return null;

        int count=array.length;

        float[] returnValue=new float[count];

        System.arraycopy(array,0,returnValue,0,count);

        return returnValue;

    }

    public static byte[] cloneArray(byte[] array){

        if(array==null)
        return null;

        int count=array.length;

        byte[] returnValue=new byte[count];

        System.arraycopy(array,0,returnValue,0,count);

        return returnValue;

    }

}
