#import "CryptTest.h"
#import "CryptCore.h"

@implementation CryptTest

- (void)setUp {
    [super setUp];
    srand(time(NULL));
}

- (void)testSelftest {
    STAssertTrue([CryptCore selftest], @"selftest");
}

- (void)testMD5_1 {
    unsigned char buf[16];
    [CryptCore md5:@"Hello World" buffer:buf];
    
    NSString *md5 = [CryptCore bytes2hex:buf length:16];

    STAssertTrue([@"b10a8db164e0754105b7a99be72e3fe5" isEqualToString:md5], @"testMD5_1");
}

- (void)testEnc_1 {
    NSError *err = nil;
    NSString *plainText = @"Hello world";
    NSData *plainData = [[NSData alloc] initWithBytes:[plainText cStringUsingEncoding:NSUTF8StringEncoding] length:[plainText length]];
    NSData *data = [CryptCore encrypt:@"KEY" data:plainData error:&err];
    unsigned char *buf = (unsigned char *)[data bytes];
    
    NSLog(@"len = %d", [data length]);
    STAssertTrue([data length] == 48, @"Length");
    STAssertTrue(memcmp(buf, "BF01", 4) == 0, @"Magic number");
    STAssertEquals(*(int*)(buf+4), 11, @"Data length");
    STAssertEqualObjects(err, nil, @"Error");
    
    NSData *plain = [CryptCore decrypt:@"KEY" data:data error:&err];
    NSString *plainStr = [[NSString alloc] initWithData:plain encoding:NSUTF8StringEncoding];
    STAssertEqualObjects(err, nil, @"Error");
    STAssertTrue([@"Hello world" isEqualToString:plainStr], @"Plain");
}

// Decrypt compatibility test.
// Input data is generated by win32 version.
- (void)testEnc_2 {
    unsigned char bytes[] = {
        0x42, 0x46, 0x30, 0x31, 0x0b, 0x00, 0x00, 0x00, 0x86, 0x0d, 0xc0, 0x6a, 0x3a, 0xdd, 0x47, 0x63,
        0x73, 0x1e, 0x11, 0x4e, 0x0d, 0x02, 0x59, 0x06, 0x46, 0x69, 0xae, 0xde, 0x68, 0xb1, 0xbb, 0x6b,
        0xc6, 0xce, 0x9f, 0x23, 0x1d, 0xc5, 0xfa, 0x52, 0x2b, 0x0b, 0x49, 0x59, 0x08, 0x8b, 0xbf, 0xe1
    };
    NSData *crypt = [[NSData alloc]initWithBytes:bytes length:48];
    NSError *err = nil;
    NSData *plain = [CryptCore decrypt:@"KEY" data:crypt error:&err];
    NSString *plainStr = [[NSString alloc] initWithData:plain encoding:NSUTF8StringEncoding];
    STAssertTrue([@"Hello world" isEqualToString:plainStr], @"Plain :%@", plainStr);
    STAssertEqualObjects(err, nil, @"Error");
}

// Invalid password.
- (void)testEnc_3 {
    unsigned char bytes[] = {
        0x42, 0x46, 0x30, 0x31, 0x0b, 0x00, 0x00, 0x00, 0x86, 0x0d, 0xc0, 0x6a, 0x3a, 0xdd, 0x47, 0x63,
        0x73, 0x1e, 0x11, 0x4e, 0x0d, 0x02, 0x59, 0x06, 0x46, 0x69, 0xae, 0xde, 0x68, 0xb1, 0xbb, 0x6b,
        0xc6, 0xce, 0x9f, 0x23, 0x1d, 0xc5, 0xfa, 0x52, 0x2b, 0x0b, 0x49, 0x59, 0x08, 0x8b, 0xbf, 0xe1
    };
    NSData *crypt = [[NSData alloc]initWithBytes:bytes length:48];
    NSError *err = nil;
    NSData *plain = [CryptCore decrypt:@"FOO" data:crypt error:&err];
    STAssertEqualObjects(plain, nil, @"Result");
    STAssertNotNil(err, @"Error");
    STAssertEquals([err code], tcfMD5Mismatch, @"MD5");
}

@end
