#pragma once
#include "Robot.h"
#include "PID.h"

class LinePos;
class Runner;

class ETLineTracer : public Robot
{
	LinePos& m_linepos;
	Runner& m_runner;
	PID<float> m_pid;
	PID<float>m_speedpid;
public:
	ETLineTracer(LinePos& linepos, Runner& runner);
	virtual ~ETLineTracer(void);
	virtual void Run(int speed);
	virtual bool IsException() const;
	virtual void Stop();
	virtual void Reset();
	//
private:
	void CalcOutput(int speed, int linepos, int& forward, int& turn);
};
