#ifndef CONTEXT_H
#define CONTEXT_H

#include "systemstate.h"
#include "exceptionstate.h"
#include "runstate.h"

class ETLineTracer;
namespace ContextStuff{
	class Context
	{
		int current_state;
		SystemStateStuff::ExceptionState exception_state;
		SystemStateStuff::RunState run_state;
		SystemStateStuff::SystemState* state_array[2];
	public:
		enum{EXCEPTION_STATE,RUN_STATE};
		Context():current_state(RUN_STATE),exception_state(),run_state()
			{state_array[EXCEPTION_STATE] = &exception_state;state_array[RUN_STATE] = &run_state;}
		~Context(){;}
		void ChangeState(const int value){current_state = value;}
		void CyclicExcute();
		void Display(ecrobot::Lcd& lcd);
        void SetETLineTracer(ETLineTracer* value);
	};
}

#endif	/* CONTEXT_H */
