/* kernel_cfg.c */
#include "kernel/kernel_int.h"
#include "kernel_cfg.h"

#ifndef TOPPERS_EMPTY_LABEL
#define TOPPERS_EMPTY_LABEL(x,y) x y[0]
#endif

/*
 *  Include Directives (#include)
 */

#include "sample1.h"

/*
 *  Task Management Functions
 */

const ID _kernel_tmax_tskid = (TMIN_TSKID + TNUM_TSKID - 1);

const ATR     	_kernel_tinib_tskatr[TNUM_TSKID]    = {(TA_NULL),(TA_NULL),(TA_NULL),(TA_ACT)};
const intptr_t	_kernel_tinib_exinf[TNUM_TSKID]     = {(intptr_t)(1),(intptr_t)(2),(intptr_t)(3),(intptr_t)(4)};
const TASK    	_kernel_tinib_task[TNUM_TSKID]      = {(task1),(task2),(task3),(task4)};
const uint_t  	_kernel_tinib_ipriority[TNUM_TSKID] = {INT_PRIORITY(1),INT_PRIORITY(2),INT_PRIORITY(2),INT_PRIORITY(4)};

/* Task Stack Sizse Estimate: 

Call calc_stksz (argv = TASK4, StackSize[TASK4]=100)
	higher_pri_tsklist[TASK4] = TASK1,TASK2,TASK3
	Call calc_stksz (argv = TASK1, StackSize[TASK1]=100)
		higher_pri_tsklist[TASK1] = 
		higher_pri_stkszlist[TASK1] = 0
		DONE(stksz_list[TASK1] = 100)
	Call calc_stksz (argv = TASK2, StackSize[TASK2]=100)
		higher_pri_tsklist[TASK2] = TASK1
		Call calc_stksz (argv = TASK1, StackSize[TASK1]=100)
			SKIP(stksz_list[TASK1] = 100)
		higher_pri_stkszlist[TASK2] = 100
		DONE(stksz_list[TASK2] = 200)
	Call calc_stksz (argv = TASK3, StackSize[TASK3]=100)
		higher_pri_tsklist[TASK3] = TASK1
		Call calc_stksz (argv = TASK1, StackSize[TASK1]=100)
			SKIP(stksz_list[TASK1] = 100)
		higher_pri_stkszlist[TASK3] = 100
		DONE(stksz_list[TASK3] = 200)
	higher_pri_stkszlist[TASK4] = 100,200,200
	DONE(stksz_list[TASK4] = 200,300,300)
Estimated Task Stack Size List = 200,300,300
Maximum Task Stack Size = 300
*/ 

#define TOPPERS_TSTKSZ	300

/*
 *  Interrupt Management Functions
 */


#define TNUM_INHNO	0
const uint_t _kernel_tnum_inhno = TNUM_INHNO;

TOPPERS_EMPTY_LABEL(const INHNO, _kernel_inhinib_inhno);
TOPPERS_EMPTY_LABEL(const ATR, _kernel_inhinib_inhatr);
TOPPERS_EMPTY_LABEL(const FP, _kernel_inhinib_entry);

#define TNUM_INTNO	0
const uint_t _kernel_tnum_intno = TNUM_INTNO;

TOPPERS_EMPTY_LABEL(const INTNO, _kernel_intinib_intno);
TOPPERS_EMPTY_LABEL(const ATR, _kernel_intinib_intatr);
TOPPERS_EMPTY_LABEL(const PRI, _kernel_intinib_intpri);

/*
 *  CPU Exception Handler
 */

#define TNUM_EXCNO	0
const uint_t _kernel_tnum_excno = TNUM_EXCNO;

TOPPERS_EMPTY_LABEL(const EXCNO, _kernel_excinib_excno);
TOPPERS_EMPTY_LABEL(const ATR, _kernel_excinib_excatr);
TOPPERS_EMPTY_LABEL(const FP, _kernel_excinib_entry);

/*
 *  Stack Area for System
 */

static STK_T				_kernel_istack[COUNT_STK_T(100+TOPPERS_TSTKSZ)];
#define TOPPERS_ISTKSZ		ROUND_STK_T(100+TOPPERS_TSTKSZ)
#define TOPPERS_ISTK		_kernel_istack

const SIZE		_kernel_istksz = TOPPERS_ISTKSZ+TOPPERS_TSTKSZ;
STK_T *const	_kernel_istk = TOPPERS_ISTK;

#ifdef TOPPERS_ISTKPT
STK_T *const	_kernel_istkpt = TOPPERS_ISTKPT(TOPPERS_ISTK, (TOPPERS_ISTKSZ+TOPPERS_TSTKSZ));
#endif /* TOPPERS_ISTKPT */

/*
 *  Module Initialization Function
 */

void
_kernel_initialize_object(void)
{
	_kernel_initialize_task();
	_kernel_initialize_interrupt();
	_kernel_initialize_exception();
}

/*
 *  Initialization Routine
 */

void
_kernel_call_inirtn(void)
{
	((INIRTN)(initial_printf))((intptr_t)(0));
}

/*
 *  Termination Routine
 */

void
_kernel_call_terrtn(void)
{
}

const PRI intpri_table[64] = 
{	INT8_C( 0), /* 00 */
	INT8_C( 0), /* 01 */
	INT8_C( 0), /* 02 */
	INT8_C( 0), /* 03 */
	INT8_C( 0), /* 04 */
	INT8_C( 0), /* 05 */
	INT8_C( 0), /* 06 */
	INT8_C( 0), /* 07 */
	INT8_C( 0), /* 08 */
	INT8_C( 0), /* 09 */
	INT8_C( 0), /* 10 */
	INT8_C( 0), /* 11 */
	INT8_C( 0), /* 12 */
	INT8_C( 0), /* 13 */
	INT8_C( 0), /* 14 */
	INT8_C( 0), /* 15 */
	INT8_C( 0), /* 16 */
	INT8_C( 0), /* 17 */
	INT8_C( 0), /* 18 */
	INT8_C( 0), /* 19 */
	INT8_C( 0), /* 20 */
	INT8_C( 0), /* 21 */
	INT8_C( 0), /* 22 */
	INT8_C( 0), /* 23 */
	INT8_C( 0), /* 24 */
	INT8_C( 0), /* 25 */
	INT8_C( 0), /* 26 */
	INT8_C( 0), /* 27 */
	INT8_C( 0), /* 28 */
	INT8_C( 0), /* 29 */
	INT8_C( 0), /* 30 */
	INT8_C( 0), /* 31 */
	INT8_C( 0), /* 32 */
	INT8_C( 0), /* 33 */
	INT8_C( 0), /* 34 */
	INT8_C( 0), /* 35 */
	INT8_C( 0), /* 36 */
	INT8_C( 0), /* 37 */
	INT8_C( 0), /* 38 */
	INT8_C( 0), /* 39 */
	INT8_C( 0), /* 40 */
	INT8_C( 0), /* 41 */
	INT8_C( 0), /* 42 */
	INT8_C( 0), /* 43 */
	INT8_C( 0), /* 44 */
	INT8_C( 0), /* 45 */
	INT8_C( 0), /* 46 */
	INT8_C( 0), /* 47 */
	INT8_C( 0), /* 48 */
	INT8_C( 0), /* 49 */
	INT8_C( 0), /* 50 */
	INT8_C( 0), /* 51 */
	INT8_C( 0), /* 52 */
	INT8_C( 0), /* 53 */
	INT8_C( 0), /* 54 */
	INT8_C( 0), /* 55 */
	INT8_C( 0), /* 56 */
	INT8_C( 0), /* 57 */
	INT8_C( 0), /* 58 */
	INT8_C( 0), /* 59 */
	INT8_C( 0), /* 60 */
	INT8_C( 0), /* 61 */
	INT8_C( 0), /* 62 */
	INT8_C( 0), /* 63 */
};


