/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: prc_config.h 1304 2008-08-27 07:28:36Z ertl-honda $
 */

/*
 *		ץå¸⥸塼ARM-Mѡ
 *
 *  Υ󥯥롼ɥեϡtarget_config.hʤޤϡ饤
 *  롼ɤեˤΤߤ饤󥯥롼ɤ롥¾Υե뤫
 *  ľܥ󥯥롼ɤƤϤʤʤ
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ץåü̿Υ饤ؿ
 */
#include "prc_insn.h"

/*
 *  󥿥ƥѤΥå
 */
#define TOPPERS_ISTKPT(istk, istksz) ((STK_T *)((istk) + (istksz)))

#endif /* TOPPERS_MACRO_ONLY */

#ifndef TOPPERS_MACRO_ONLY
/*
 *  ƥȤλ
 *
 */
Inline bool_t
sense_context(void)
{
	/*
	 *  PSPͭʤ饿ƥȡMSPͭʤ󥿥ƥ
	 *  Ȥ롥 
	 */
	if ((get_control() & CONTROL_PSP) == CONTROL_PSP){
		return false;
	}
	else {
		return true;
	}
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  TOPPERSɸ߽ǥμ¸
 *
 *  ͥ٥ޥȤƤϡBASEPRIѤ롥ߤػߤ
 *  ǽȤơFAULTMASKPRIMASK뤬ͥγߤ
 *  ݡȤ뤿ᡤCPUåΤѤʤ
 *  ΤᡤBASEPRIѤƵŪCPUåե饰¸롥
 *
 *  ޤCPUå֤ѿ(lock_flag)Ѱդ롥
 *
 *  CPUåե饰ꥢƤ֤ϡBASEPRIǥγ
 *  ͥ٥ޥͤꤹ롥δ֤ϡǥγͥ٥ޥ
 *  ϡBASEPRIѤ롥
 * 
 *  ФCPUåե饰åȤ줤֤ϡBASEPRI򡤥
 *  ΤΤ٤Ƥγ׵ޥ(TIPM_LOCK)ȡ
 *  ǥγͥ٥ޥȤι⤤ꤹ롥δ֤Υǥ
 *  γͥ٥ޥϡΤѿ(saved_iipm, ɽݻ)
 *  Ѱդݻ롥
 */

/*
 *  ͥ٥ޥγɽɽѴ
 *
 *  ֥Υե뤫饤󥯥롼ɤΤˡ
 *  CAST
 *  ͥ٤Υӥå(TBITW_IPRI) 8 ξϡͥ 255
 *  ϡͥ -1 б롥
 */
#define EXT_IPM(iipm)   (CAST(PRI,((iipm >> (8 - TBITW_IPRI)) - (1 << TBITW_IPRI))))       /* ɽɽ */
#define INT_IPM(ipm)    (((1 << TBITW_IPRI) - CAST(uint8_t, -(ipm)))  << (8 - TBITW_IPRI)) /* ɽɽ */

/*
 *  CPUå֤Ǥγͥ٥ޥ
 */
#define TIPM_LOCK    TMIN_INTPRI

/*
 *  CPUå֤Ǥγͥ٥ޥɽ
 *
 *  TIPM_LOCKϡCPUå֤ǤBASEPRIͥ͡ΤΤ
 *  ٤Ƥγߤޥͤ롥  
 */
#define IIPM_LOCK    INT_IPM(TIPM_LOCK)

/*
 *  TIPM_ENAALLʳͥ٥ޥˤɽ
 *
 *  BASEPRI '0' ꤹ뤳ȤǡߤĤ롥
 */
#define IIPM_ENAALL  (0)


#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUåե饰¸Τѿ
 * 
 *  ѿϡCPUå֤λΤ߽񤭴Ƥ褤Ȥ롥
 *  饤ؿǡνѲʤ褦volatile ꡥ 
 */
extern volatile bool_t  lock_flag;    /* CPUåե饰ͤݻѿ */
extern volatile uint32_t saved_iipm;  /* ͥ٤ޥѿ */

/*
 *  CPUå֤ؤΰܹ
 *
 *  BASEPRIʥϡɥγͥ٥ޥˤsaved_iipm¸
 *  ͥΤΤ٤Ƥγߤޥ͡TIPM_LOCK
 *  ꤹ롥ޤlock_flagtrueˤ롥
 *
 *  BASEPRIǽ餫TIPM_LOCKƱ⤤ˤϡ
 *  saved_iipm¸ΤߤǡTIPM_LOCKˤꤷʤϡǥ
 *  γͥ٥ޥTIPM_LOCKƱ⤤٥
 *  Ƥ֤ˤ롥
 *
 *  δؿϡCPUå֡lock_flagtrueξ֡ˤǸƤФ뤳Ȥ
 *  ʤΤꤷƤ롥
 */
Inline void
x_lock_cpu(void)
{
	uint32_t iipm;

	/*
	 *  current_iipm()֤ͤľsaved_iipm¸ѿiipm
	 *  ѤƤΤϡcurrent_iipm()Ƥľ˳ߤȯ
	 *  ư줿߽saved_iipmѹǽ뤿
	 *  롥
	 */
	iipm = get_basepri();
	set_basepri(IIPM_LOCK);
	saved_iipm = iipm;
	lock_flag = true;
	/* ƥ륻ǥ꤬񤭴ǽ */
	Asm("":::"memory");
}

#define t_lock_cpu()    x_lock_cpu()
#define i_lock_cpu()    x_lock_cpu()

/*
 *  CPUå֤β
 *
 *  lock_flagfalseˤIPMʥϡɥγͥ٥ޥˤ
 *  saved_iipm¸᤹ͤ
 *
 *  δؿϡCPUå֡lock_flagtrueξ֡ˤǤΤ߸ƤФ
 *  ΤꤷƤ롥
 */
Inline void
x_unlock_cpu(void)
{
	/* ƥ륻ǥ꤬񤭴ǽ */
	Asm("":::"memory");
	lock_flag = false;
	set_basepri(saved_iipm);
}

#define t_unlock_cpu()    x_unlock_cpu()
#define i_unlock_cpu()    x_unlock_cpu()

/*
 *  CPUå֤λ
 */
Inline bool_t
x_sense_lock(void)
{
	return(lock_flag);
}

#define t_sense_lock()    x_sense_lock()
#define i_sense_lock()    x_sense_lock()

/*
 *  SVCϥɥprc_support.S
 */
extern void svc_handler(void);

/*
 *  ȥåץ롼start.S
 */
extern void _start(void);

/*
 *  ǹ̥ͥؤΥǥѥåprc_support.S
 *
 *  dispatchϡƥȤƤӽФ줿ӥ
 *  ƤӽФ٤ΤǡƥȡCPUå֡ǥѥ
 *  ľ֡ʥǥΡ˳ͥ٥ޥ֤ǸƤӽФ
 *  Фʤʤ
 */
extern void dispatch(void);

/*
 *  ǥѥåưϡprc_support.S
 *
 *  start_dispatchϡͥ뵯ư˸ƤӽФ٤Τǡ٤Ƥγ
 *  ߤػߤ֡ʳߥå֤Ʊξ֡ˤǸƤӽФʤ
 *  ʤʤ
 */
extern void start_dispatch(void) NoReturn;

/*
 *  ߤΥƥȤΤƤƥǥѥåprc_support.S
 *
 *  exit_and_dispatchϡext_tskƤӽФ٤Τǡƥ
 *  ȡCPUå֡ǥѥåľ֡ʥǥΡ˳ͥ
 *  ٥ޥ֤ǸƤӽФʤФʤʤ
 */
extern void exit_and_dispatch(void) NoReturn;

/*
 *  ͥνλθƽФprc_support.S
 *
 *  call_exit_kernelϡͥνλ˸ƤӽФ٤Τǡ󥿥
 *  ƥȤڤ괹ơͥνλexit_kernelˤƤӽ
 *  
 */
extern void call_exit_kernel(void) NoReturn;


/*
 *  ֹ桦ߥϥɥֹ
 *
 *  ߥϥɥֹ(inhno)ȳֹ(intno)ϡȯ
 *  EPSRꤵ㳰ֹȤ롥 
 */

/*
 *  ֹϰϤȽ
 */
#define VALID_INTNO(intno)           ((TMIN_INTNO <= (intno)) && ((intno) <= TMAX_INTNO))
#define VALID_INTNO_DISINT(intno)    VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)    VALID_INTNO(intno)

/*
 *  ߥϥɥ
 *
 *  ٥ȥֹinhnoγߥϥɥεưint_entryꤹ롥
 *  ϥɥơ֥
 */
Inline void
x_define_inh(INHNO inhno, FP int_entry)
{

}

/*
 *  ߥϥɥνޥ
 *
 */
#define INT_ENTRY(inhno, inthdr)    inthdr
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) extern void inthdr(void);

/*
 *  ׵ػߥե饰
 */

/*
 *  °ꤵƤ뤫Ƚ̤뤿ѿkernel_cfg.c
 */
extern const uint32_t	bitpat_cfgint[];

/*
 *  ׵ػߥե饰Υå
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥯥ꥢ褦Ȥˤϡfalse֤  
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	uint32_t tmp;

	/*
	 *  °ꤵƤʤ
	 */
	if ((bitpat_cfgint[intno >> 5] & (1 << (intno & 0x1f))) == 0x00) {
		return(false);
	}

	if (intno == IRQNO_SYSTICK) {
		tmp = sil_rew_mem((void *)SYSTIC_CONTROL_STATUS);
		tmp &= ~SYSTIC_TICINT;
		sil_wrw_mem((void *)SYSTIC_CONTROL_STATUS, tmp);
	}else {
		tmp = intno - 16;
		sil_wrw_mem((void *)NVIC_CLRENA0 + (tmp >> 5), (1 << (tmp & 0x1f)));
	}

	return(true);
}

#define t_disable_int(intno) x_disable_int(intno)
#define i_disable_int(intno) x_disable_int(intno)

/*
 *  ׵ػߥե饰β
 *
 *  °ꤵƤʤ׵饤ФƳ׵ػ
 *  ե饰򥯥ꥢ褦Ȥˤϡfalse֤
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	uint32_t tmp;

	/*
	 *  °ꤵƤʤ
	 */
	if ((bitpat_cfgint[intno >> 5] & (1 << (intno & 0x1f))) == 0x00) {
		return(false);
	}

	if (intno == IRQNO_SYSTICK) {
		tmp = sil_rew_mem((void *)SYSTIC_CONTROL_STATUS);
		tmp |= SYSTIC_TICINT;
		sil_wrw_mem((void *)SYSTIC_CONTROL_STATUS, tmp);
	}else {
		tmp = intno - 16;
		sil_wrw_mem((void *)((uint32_t *)NVIC_SETENA0 + (tmp >> 5)),
					(1 << (tmp & 0x1f)));
	}
    
	return(true);
}

#define t_enable_int(intno) x_enable_int(intno)
#define i_enable_int(intno) x_enable_int(intno)

/*
 *  ׵饤°
 */
extern void x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ߥϥɥɬפIRC
 */
Inline void
i_begin_int(INTNO intno)
{
}

/*
 *  ߥϥɥνиɬפIRC
 */
Inline void
i_end_int(INTNO intno)
{
}

/*
 *  CPU㳰ϥɥط
 */ 

/*
 *  CPU㳰ϥɥֹ
 */
#define VALID_EXCNO_DEFEXC(excno)    (TMIN_EXCNO <= (excno) && (excno) <= TMAX_EXCNO)

/*
 *  CPU㳰ϥɥε
 */
extern void enable_exc(EXCNO excno);

/*
 *  CPU㳰ϥɥζػ
 */
extern void disable_exc(EXCNO excno);

/*
 *  CPU㳰ϥɥ
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
	/*
	 *  㳰ϵĤԤɬפ
	 */
	enable_exc(excno);
}

/*
 *  CPU㳰ϥɥޥ
 */
#define EXC_ENTRY(excno, exchdr)    exchdr
#define EXCHDR_ENTRY(excno, excno_num, exchdr) extern void exchdr(void *p_excinf);

/*
 *  CPU㳰ȯΥƥȤλ
 *
 *  CPU㳰ȯΥƥȤƥȤλfalse
 *  Ǥʤtrue֤
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	uint32_t exc_return;

	exc_return = *((uint32_t *)p_excinf + P_EXCINF_OFFSET_EXC_RETURN);
	if ((exc_return & EXC_RETURN_PSP) == EXC_RETURN_PSP){
		return false;
	}
	else {
		return true;
	}
}

/*
 *  CPU㳰ȯIPMʥϡɥγͥ٥ޥɽ
 *  ˤλ
 */
Inline uint32_t
exc_get_iipm(void *p_excinf)
{
	return(*((uint32_t *)p_excinf + P_EXCINF_OFFSET_BASEPRI));
}

/*
 *  CPU㳰ȯΥƥȤȳߤΥޥ֤λ
 *
 *  CPU㳰ȯΥƥ֤ͥ¹Ǥʤ
 *  ƥȤǤꡤߥå֤ǤʤCPUå֤Ǥʤʥ
 *  ǥΡ˳ͥ٥ޥ֤ǤtrueǤʤ
 *  false֤CPU㳰ͥγ߽ȯ
 *  ˤfalse֤ˡ
 *
 *  PU㳰ȯBASEPRIʥϡɥγͥ٥ޥ
 *  ٤ƤγߤĤ֤Ǥ뤳Ȥå뤳Ȥǡ
 *  ͥ¹Ǥʤȡߥå֤ǤʤȡCPUå֤Ǥ
 *  ȡʥǥΡ˳ͥ٥ޥ֤Ǥ뤳Ȥ4Ĥ
 *  å뤳ȤǤCPU㳰ȯlock_flag
 *  ȤɬפϤʤˡ
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return !exc_sense_context(p_excinf);
}

/*
 *  CPU㳰ȯΥƥȤȳߡCPUå֤λ
 *
 *  CPU㳰ȯΥƥ֤ͥ¹Ǥʤ
 *  ƥȤǤꡤߥå֤ǤʤCPUå֤Ǥʤ
 *  trueǤʤfalse֤CPU㳰ͥγ߽
 *  ȯˤfalse֤ˡ
 *
 *  CPU㳰ȯBASEPRIʥϡɥγͥ٥
 *  ˤTIPM_LOCK㤤Ȥå뤳Ȥǡͥ¹
 *  ʤȡߥå֤ǤʤȡCPUå֤ǤʤȤ3
 *  ξåƤCPU㳰ȯlock_flagϻȤ
 *  ʤˡˤꡤʥǥΡ˳ͥ٥ޥTIPM_LOCK
 *  ꤷƥ¹ԤƤˤfalse֤äƤޤȽǤ
 *  Τˤ뤿ΥХإåɤ礭Ȥ顤Ƥ뤳Ȥˤ롥
 */
Inline bool_t
exc_sense_unlock(void *p_excinf)
{
	return !exc_sense_context(p_excinf);
}

/*
 *  CPU㳰ȥprc_support.S
 */
extern void exc_entry(void);

/*
 *  ߥȥprc_support.S
 */
extern void int_entry(void);

/*
 *  ץå¸ν
 */
extern void prc_initialize(void);

/*
 *  ץå¸νλ
 */
extern void prc_terminate(void);

/*
 *  atexitνȥǥȥ饯μ¹
 */
Inline void
call_atexit(void)
{
	extern void    software_term_hook(void);
	void (*volatile fp)(void) = software_term_hook;

	/*
	 *  software_term_hookؤΥݥ󥿤򡤰övolatileΤfp
	 *  ƤȤΤϡ0ȤӤŬǺʤ褦ˤ뤿
	 *  Ǥ롥
	 */
	if (fp != 0) {
		(*fp)();
	}
}

/*
 * ϿƤʤ㳰ȯȸƤӽФ
 */
extern void default_exc_handler(void *p_excinf);

/*
 * ̤Ͽγߤȯ˸ƤӽФ
 */
extern void default_int_handler(void *p_excinf);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_CONFIG_H */
