/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: prc_insn.h 1304 2008-08-27 07:28:36Z ertl-honda $
 */


/*
 *  ¸ü̿Υ饤ؿARM-Mѡ
 */

#ifndef CORE_INSN_H
#define CORE_INSN_H

#include <arm_m.h>

/*
 *  FAULTMASKΥå
 */
Inline void
set_faultmask(void){
	Asm("cpsid f":::"memory");
}

/*
 *  FAULTMASKΥꥢ
 */
Inline void
clear_faultmask(void){
	Asm("cpsie f":::"memory");
}

/*
 *  PRIMASKΥå
 */
Inline void
set_primask(void){
	Asm("cpsid i":::"memory");
}

/*
 *  PRIMASKΥꥢ
 */
Inline void
clear_primask(void){
	Asm("cpsie i":::"memory");
}

/*
 *  BASEPRIΥå
 */
Inline void
set_basepri(uint32_t val){
	Asm("msr BASEPRI, %0" : : "r"(val) : "memory");
}

/*
 *  BASEPRIμ
 */
Inline uint32_t
get_basepri(void){
	uint32_t val;
	Asm("mrs  %0, BASEPRI" : "=r"(val));
	return(val);
}

/*
 *  CONTROLΥå
 */
Inline void
set_control(uint32_t val){
	Asm("msr control, %0 \n"
		" isb"
		: : "r"(val) : "memory");
}

/*
 *  CONTROLμ
 */
Inline uint32_t
get_control(void){
	uint32_t val;
	Asm("mrs  %0, CONTROL" : "=r"(val));
	return(val);
}

/*
 *  ơ쥸CPSRˤθͤɽФ
 */
Inline uint32_t
get_ipsr(void)
{
    uint32_t sr;
    Asm("mrs  %0, ipsr" : "=r"(sr));
    return(sr);
}

#endif /* CORE_INSN_H */
