/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: prc_support.S 1365 2008-09-28 07:23:15Z futl-takaki $
 */

/*
 *  ץå¸⥸塼 ֥ARM-Mѡ
 */

#define TOPPERS_MACRO_ONLY
#define UINT_C(val)		(val)		/* uint_tޥ */
#define ULONG_C(val)	(val)		/* ulong_tޥ */
#define CAST(type, val)	(val)		/* 㥹ȤԤޥ */

#include "kernel_impl.h"
#include "arm_m.h"


	.text


/*
 *  CPU㳰ȥ
 *
 *  ߥȥȽƤƱμबۤʤ뤿ᡤ
 *  ʬƤ롥
 */
	.align 2
	.syntax unified
	.code 16
	.global exc_entry
	.type exc_entry, function
exc_entry:
	/*
	 *  㳰/ߤȯȡȯ˥ƥ֤ʥå˥
	 *  å쥸¸롥
	 *  Ƥ˲äơCPU㳰ϥɥؤξȤơbasepri ͤȡ
	 *  EXC_RETURNξä¸롥basepriͤϡCPU㳰
	 *  ꥿˳ͥ٥ޥͤ򸵤᤹ˤѤ롥
	 *
	 *   -----------
	 *  | EXC_RETURN|  
	 *   -----------
	 *  |  basepri  |  
	 *   -----------
	 *  |    R0     |  
	 *   -----------
	 *  |    R1     |
	 *   -----------
	 *  |    R2     |
	 *   -----------
	 *  |    R3     |
	 *   -----------
	 *  |    R12    |
	 *   -----------
	 *  |    LR     |
	 *   -----------
	 *  |    PC     |
	 *   -----------
	 *  |   xPSR    |
	 *   -----------
	 *
	 */

	/*
	 *  ȯγͥ٥ޥ򥹥å¸뤿
	 */
	mrs   r2, basepri             /* baepriͤ */

	/*
	 * ¿ųߤå
	 * EXC_RETURNʳ߻LRꤵ͡ˤåơ㳰ȯ
	 * ƥ֤ʥåꤹ뤳Ȥ¿ųߤȽꤹ롥
	 */
	tst   lr, #EXC_RETURN_PSP    /* ߸MSPʤ¿ų */
	beq   exc_entry_1            /* ¿ųߤʤexc_entry_1 */
	mrs   r0, psp                /* ܤγߤξPSP */
	stmfd r0!,{r2}               /* ȯγͥ٥ޥѤ */
	stmfd r0!,{lr}               /* EXC_RETURN Ѥ             */
	msr   psp, r0                /* CPU㳰ϥɥؤΰȤʤ */
	push  {lr}                   /* MSPˤEXC_RETURN Ѥ    */ 
	b     exc_entry_2
exc_entry_1:                     /* ¿ųߤξ */
	push  {r2}                   /* ȯγͥ٥ޥѤ */
	push  {lr}                   /* EXC_RETURN Ѥ             */ 
	mov   r0, sp                 /* CPU㳰ϥɥؤΰȤʤ */

	/*
	 *  ̽
	 */
exc_entry_2:                     
	mrs   r3, ipsr               /* ϥɥ饢ɥ쥹 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

#ifdef LOG_EXC_ENTER
	push  {r0,r2,r3}
	mov   r0, r3                 /* 㳰ֹѥ᡼  */
	bl    log_exc_enter          /* log_exc_enterƤӽФ */
	pop   {r0,r2,r3}
	push  {r3}                   /* 㳰ֹ򥹥å    */
#endif /* LOG_EXC_ENTER */

	/*
	 *  CPU㳰ϥɥθƤӽФ
	 */
	blx   r2

#ifdef LOG_EXC_ENTER
	pop   {r0}                   /* 㳰ֹ        */
	bl    log_exc_leave          /* log_exc_leaveƤӽФ */
#endif /* LOG_EXC_ENTER */

	b     ret_exc


/*
 *  ߥȥ
 */
	.align 2
	.syntax unified
	.code 16
	.global int_entry
	.type int_entry, function
int_entry:
	/*
	 *  ȯγͥ٥ޥ򥹥å¸뤿
	 */
	mrs   r2, basepri             /* baepriͤ */

	/*
	 * ¿ųߤå
	 * EXC_RETURNʳ߻LRꤵ͡ˤåơ㳰ȯ
	 * ƥ֤ʥåꤹ뤳Ȥ¿ųߤȽꤹ롥
	 */
	tst   lr, #EXC_RETURN_PSP    /* ߸MSPʤ¿ų */
	beq   int_entry_1            /* ¿ųߤʤint_entry_1    */
	mrs   r0, psp                /* ܤγߤξPSP */
	stmfd r0!,{r2}               /* ȯγͥ٥ޥѤ */
	stmfd r0!,{lr}               /* EXC_RETURN Ѥ             */
	msr   psp, r0                /* CPU㳰ϥɥؤΰȤʤ */
	push  {lr}                   /* MSPˤEXC_RETURN Ѥ    */ 
	b     int_entry_2
int_entry_1:                     /* ¿ųߤξ */
	push  {r2}                   /* ȯγͥ٥ޥѤ */
	push  {lr}                   /* EXC_RETURN Ѥ             */ 
	mov   r0, sp                 /* ̤γߤȯξȤ */

	/*
	 *  ̽
	 */
int_entry_2:                     
	mrs   r3, ipsr               /* ϥɥ饢ɥ쥹 */
	ldr   r1, =_kernel_exc_tbl
	ldr   r2, [r1, r3, lsl #2]

#ifdef LOG_EXC_ENTER
	push  {r0,r2,r3}
	mov   r0, r3                 /* 㳰ֹѥ᡼  */
	bl    log_inh_enter          /* log_exc_enterƤӽФ */
	pop   {r0,r2,r3}
	push  {r3}                   /* 㳰ֹ򥹥å    */
#endif /* LOG_EXC_ENTER */

	/*
	 *  ߥϥɥθƤӽФ
	 */
	blx   r2

#ifdef LOG_EXC_ENTER
	pop   {r0}                   /* 㳰ֹ        */
	bl    log_exc_leave          /* log_exc_leaveƤӽФ */
#endif /* LOG_EXC_ENTER */



/*
 *  /㳰и
 *
 *  ret_exc/ret_intϡCPU㳰/ߥϥɥ餫äľ˼¹Ԥ
 *  롼Ǥ롥
 */
ret_exc:
ret_int:
	/*
	 *  ߥå֤Ȥ롥λǤϡCPUå֤ˤϤʤʤ
	 * baseprilock_flagsaved_iipmϹʤˡ
	 *
	 *  ߥå֤ȤΤϡΥƥȤΥåȡ
	 *  褬󥿥ƥȤǤäΥ꥿򥢥ȥߥå
	 *  ˹ԤǤ롥bsepriCPUåͤˤ뤳ȤǤ⥢ȥߥ
	 *  ʥåϲǽǤ뤬ߤ꥿󤷤Ƥ⡤
	 *  basepri ƤϸʤᡤѤ뤳ȤǤʤ 
	 *  FAULTMASKϡߤΥ꥿ˤäơ'0'˥
	 *  롥
	 */
	cpsid f                        

	/*
	 *  ΥƥȤȽ
	 * 
	 *  ߥϥɥ¹ԤLR˥åȤEXC_RETURNåơ
	 *  MSPȤƤС褬󥿥ƥȤȽꤹ롥
	 */
	pop   {r3}                     /* lr򥹥å         */
	tst   r3, #EXC_RETURN_PSP      /* 褬PSPʤ ret_int_1  */
	bne   ret_int_1
	pop   {r1}                     /* γͥ٥ޥ(basepri)r1 */
	b     ret_int_2                /* ͤMSP */

	/*
	 *  ܤγߤνи
	 */
ret_int_1:
	/*
	 *  PSP夫EXC_RETURN
	 */
	mrs   r2, psp                 
	add   r2, r2, #4
	msr   psp, r2                 

ret_int_2:
	/*
	 *  ˤϳߥå֡FAULTMASKåȡˤ줿֤롥
	 *  Thread⡼ɤΥ꥿ˤ꼫ưŪ˳ߥå֤ˤʤ롥
	 *  ͥ٥ޥϳ˾֤᤹
	 */ 
	msr   basepri, r1             /* ͥ٥ޥ˾֤ */
	bx    r3                      /* ꥿ */

/*
 *  ǥѥåư
 */
	.align	2
	.thumb
	.thumb_func
	.globl start_dispatch
start_dispatch:
	/*
	 *  Υ롼ϡͥ뵯ưˡ٤Ƥγߤػߤ
	 * ʳߥå֤ƱˤǸƤӽФ롥ޤߥ⡼ɡ
	 *  ƥȤƱˤǸƤӽФ뤳ȤꤷƤ롥
	 *
	 *  prc_initializeǡlock_flagtrueˡsaved_iipmIIPM_ENAALL
	 *  Ƥ뤿ᡤͥγߤĤ뤳Ȥǡ
	 *  CPUå֡ʥǥΡ˳ͥ٥ޥ֤ˤʤ롥
	 *  ޤtask_initializedisdspfalse˽Ƥ뤿ᡤǥ
	 *  ѥåľ֤ˤʤäƤ롥
	 */
	ldr   r0,=istkpt              /* MSP   */
	ldr   r1,[r0]                 /* start_dispatchƤӽФ˸ƤӽФѤ */
	msr   msp, r1                 /* ѤƤ뤿             */
	ldr   r1, =IIPM_LOCK          /* ͥγߤػ */
	msr   basepri, r1 
	cpsie f                       /* ͥγߤ */
	mov   r0, #CONTROL_PSP        /* PSPͭ  */
	msr   control, r0
	isb                           /* control ɬ */
	bx    lr

/*
 *  ͥνλθƽФ
 *
 *  å󥿥ƥѤڤؤ
 *  
 */
	.text
	.syntax unified
	.code 16
	.globl call_exit_kernel
	.type call_exit_kernel, function
call_exit_kernel:
	mov   r0, #CONTROL_MSP
	msr   control, r0       /* MSPͭ  */
	isb                     /* control ɬ */
	b     exit_kernel       /* ͥνλƤ */


/*
 *  Ԥ
 */
	.text
	.syntax unified
	.code 16
	.globl sil_dly_nse
	.type sil_dly_nse, function
sil_dly_nse:
	sub   r0, r0, #SIL_DLY_TIM1
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
sil_dly_nse1:
	sub   r0, r0, #SIL_DLY_TIM2
	cmp   r0, #0
	bgt   sil_dly_nse1
	mov   pc, lr
