/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id: tool_stddef.h 819 2008-03-18 12:58:50Z hiro $
 */

/*
 *		t_stddef.hγȯĶ¸GCCѡ
 */

#ifndef TOPPERS_TOOL_STDDEF_H
#define TOPPERS_TOOL_STDDEF_H

/*
 *  ѥγĥǽΤΥޥ
 */
#ifndef __cplusplus					/* C++ˤinline  */
#if __STDC_VERSION__ < 199901L		/* C99ˤinline  */
#define inline	__inline__			/* 饤ؿ */
#endif /* __STDC_VERSION__ < 199901L */
#endif /* __cplusplus */

#define Inline	static __inline__	/* 饤ؿ */

#ifndef __cplusplus					/* C++ˤasm */
#define asm		__asm__				/* 饤󥢥֥ */
#endif /* __cplusplus */

#define Asm		__asm__ volatile	/* 饤󥢥֥ʺŬ޻ߡ*/

#define NoReturn	__attribute__((__noreturn__))
									/* ꥿󤷤ʤؿ */

/*
 *  ȯĶɸ।󥯥롼ɥե
 *
 *  NULLstddef.h顤INT_MAXINT_MINUINT_MAXLONG_MAX
 *  LONG_MINULONG_MAXCHAR_BITlimits.hࡥ
 *
 *  C++/EC++Ǥϡɸ;ϤΥ󥯥롼ɥե뤬Ѱդ
 *  Ȥϸ¤ʤΤդɬפǤʤۤȤɤγȯĶѰդ
 *  Ƥˡ
 */
#ifndef TOPPERS_MACRO_ONLY
#include <stdint.h>
#include <limits.h>
#endif /* TOPPERS_MACRO_ONLY */

/*
 *  stdint.hѤȤʤ
 *
 *  ȯĶstdint.hѰդƤ餺Υѥ
 *  ƤϤޤˡstdint.hѤȤʤͿ롥
 *
 *  TOPPERS_STDINT_TYPE1: char/short/int/long longΥӥåĹ줾
 *                        8/16/32/64ӥåȤǡݥ󥿤ΥӥåĹlong
 *                        ΥӥåĹȰפ
 */
#ifdef TOPPERS_STDINT_TYPE1

/*
 *  ѥ¸Υǡ
 */
#ifndef TOPPERS_MACRO_ONLY

typedef signed char			int8_t;		/* դ8ӥå */
typedef unsigned char		uint8_t;	/* ̵8ӥå */

typedef signed short		int16_t;	/* դ16ӥå */
typedef unsigned short		uint16_t;	/* ̵16ӥå */

typedef signed int			int32_t;	/* դ32ӥå */
typedef unsigned int		uint32_t;	/* ̵32ӥå */

typedef signed long long	int64_t;	/* դ64ӥå */
typedef unsigned long long	uint64_t;	/* ̵64ӥå */

typedef int8_t				int_least8_t;	/* 8ӥåȰʾդ */
typedef uint8_t				uint_least8_t;	/* 8ӥåȰʾ̵ */

typedef long				intptr_t;	/* ݥ󥿤ǼǤդ */
typedef unsigned long		uintptr_t;	/* ݥ󥿤ǼǤ̵ */

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ѥ¸Υǡޥ
 */
#ifndef INT8_C
#define INT8_C(val)			(val)
#endif /* INT8_C */

#ifndef UINT8_C
#define UINT8_C(val)		(val ## U)
#endif /* UINT8_C */

#ifndef INT16_C
#define INT16_C(val)		(val)
#endif /* INT16_C */

#ifndef UINT16_C
#define UINT16_C(val)		(val ## U)
#endif /* UINT16_C */

#ifndef INT32_C
#define INT32_C(val)		(val)
#endif /* INT32_C */

#ifndef UINT32_C
#define UINT32_C(val)		(val ## U)
#endif /* UINT32_C */

#ifndef INT64_C
#define INT64_C(val)		(val ## LL)
#endif /* INT64_C */

#ifndef UINT64_C
#define UINT64_C(val)		(val ## ULL)
#endif /* UINT64_C */

/*
 *  ѥ¸Υǡ˳ǼǤͤȺǾͤ
 */
#define INT8_MAX			SCHAR_MAX
#define INT8_MIN			SCHAR_MIN
#define UINT8_MAX			UCHAR_MAX

#define INT16_MAX			SHRT_MAX
#define INT16_MIN			SHRT_MIN
#define UINT16_MAX			USHRT_MAX

#define INT32_MAX			INT_MAX
#define INT32_MIN			INT_MIN
#define UINT32_MAX			UINT_MAX

#define INT64_MAX			LLONG_MAX
#define INT64_MIN			LLONG_MIN
#define UINT64_MAX			ULLONG_MAX

#define INT_LEAST8_MAX		INT8_MAX
#define INT_LEAST8_MIN		INT8_MIN
#define UINT_LEAST8_MAX		INT8_MAX

#endif /* TOPPERS_STDINT_TYPE1 */

/*
 *  ư˴ؤ
 *
 *  TOPPERS_STDFLOAT_TYPE1: floatIEEE754ñư
 *							doubleưξ
 */
#ifdef TOPPERS_STDFLOAT_TYPE1
#ifndef TOPPERS_MACRO_ONLY

typedef float		float32_t;			/* IEEE754ñư */
typedef double		double64_t;			/* IEEE754ư */

#endif /* TOPPERS_MACRO_ONLY */

#define FLOAT32_MIN		1.17549435e-38F
#define FLOAT32_MAX		3.40282347e+38F
#define DOUBLE64_MIN	2.2250738585072014e-308
#define DOUBLE64_MAX	1.7976931348623157e+308

#endif /* TOPPERS_STDFLOAT_TYPE1 */
#endif /* TOPPERS_TOOL_STDDEF_H */
