﻿//------------------------------------------------------------------------------
// TOPPERS/ASP Sample1 Debuging Environment
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Test0001.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;
using SimBase;

namespace Sample1Sim.Test
{
	[ScenarioNameAttribute("テスト１")]
	class Test0001 : Scenario
	{
		public Test0001(IScenarioHost scenarioHost)
			: base(scenarioHost)
		{
		}

		int m_Timer;

		protected override void DoRun()
		{
			TotalSteps = 3;
			m_Timer = Host.SetTimer(10, new Action(StartSample1));
		}

		protected override void BeginStop()
		{
			EndStop();
		}

		private void StartSample1()
		{
			Host.KiiTimer(m_Timer);

			Step = 1;

			Host.SwitchUnit("Sample1");

			Host.CurrentUnit.Start();

			m_Timer = Host.SetTimer(1000, new Action(StopSample1));
		}

		private void StopSample1()
		{
			Host.KiiTimer(m_Timer);

			Step = 2;

			Host.CurrentUnit.Input(0, new byte[] { (byte)'Q' });

			m_Timer = Host.SetTimer(100, new Action(EndTest));
		}

		private void EndTest()
		{
			Host.KiiTimer(m_Timer);

			Step = 3;

			DoEnd(true);
		}
	}
}
