/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: kernel_impl.h 96 2012-03-03 06:30:56Z nagasima $
 */

/*
 *		TOPPERS/ASPJ[lWwb_t@C
 *
 *  ̃wb_t@ĆCJ[l\vÕ\[Xt@C
 *  ŕKCN[hׂWwb_t@CłD
 *
 *  AZũ\[Xt@C炱̃t@CCN[h鎞
 *  ́CTOPPERS_MACRO_ONLY`ĂDɂC}N`ȊO
 *  悤ɂȂĂD
 */

#ifndef TOPPERS_KERNEL_IMPL_H
#define TOPPERS_KERNEL_IMPL_H

/*
 *  J[l̓ʖ̃l[
 */
#include "kernel_rename.h"

/*
 *  AvP[VƋʂ̃wb_t@C
 */
#include <kernel.h>

/*
 *  VXeO@\̂߂̒`
 */
#include <t_syslog.h>

/*
 *  ^LXgs}N̒`
 */
#ifndef CAST
#define CAST(type, val)		((type)(val))
#endif /* CAST */

/*
 *  ^[Qbgˑ̒`
 */
#include "target_config.h"

/*
 *  ׂĂ̊֐RpC邽߂̒`
 */
#ifdef ALLFUNC
#include "allfunc.h"
#endif /* ALLFUNC */

/*
 *  rbgtB[hł̕^
 *
 *  8rbgȉ̃̕rbgtB[hŁClێꍇ
 *  ɗpׂf[^^DANSI Cł́CrbgtB[h̃f[^^ɂ
 *  intunsigned intȂ߁CftHg̒`unsigned
 *  intƂĂ邪C^[Qbgуc[ˑŁCunsigned char܂
 *  unsigned shortɒ`ǂꍇD
 */
#ifndef BIT_FIELD_UINT
#define BIT_FIELD_UINT		unsigned int
#endif /* BIT_FIELD_UINT */

/*
 *  rbgtB[hł̃u[^
 *
 *  1rbg̃rbgtB[hŁCu[lێꍇɗpׂ
 *  f[^^DftHgłBIT_FIELD_UINTƓɒ`Ă邪Cu[
 *  lێ邱Ƃ𖾎邽߂ɕʂ̖̂ƂĂD
 */
#ifndef BIT_FIELD_BOOL
#define BIT_FIELD_BOOL		BIT_FIELD_UINT
#endif /* BIT_FIELD_BOOL */

/*
 *  IuWFNgID̍ŏl̒`
 */
#define TMIN_TSKID		1		/* ^XNID̍ŏl */
#define TMIN_SEMID		1		/* Z}tHID̍ŏl */
#define TMIN_FLGID		1		/* tOID̍ŏl */
#define TMIN_DTQID		1		/* f[^L[ID̍ŏl */
#define TMIN_PDQID		1		/* Dxf[^L[ID̍ŏl */
#define TMIN_MBXID		1		/* [{bNXID̍ŏl */
#define TMIN_MPFID		1		/* Œ蒷v[ID̍ŏl */
#define TMIN_MPLID		1		/* ϒv[ID̍ŏl */
#define TMIN_CYCID		1		/* nhID̍ŏl */
#define TMIN_ALMID		1		/* A[nhID̍ŏl */
#define TMIN_ISRID		1		/* ݃T[rX[`ID̍ŏl */

/*
 *  Dx̒iK̒`
 */
#define TNUM_TPRI		(TMAX_TPRI - TMIN_TPRI + 1)
#define TNUM_MPRI		(TMAX_MPRI - TMIN_MPRI + 1)
#define TNUM_INTPRI		(TMAX_INTPRI - TMIN_INTPRI + 1)

/*
 *  J[lŎgp鑮̒`
 */
#define TA_NOEXS		((ATR)(-1))			/* o^ */

#ifndef TA_MEMALLOC
#define TA_MEMALLOC		UINT_C(0x8000)		/* ̈J[lŊm */
#endif /* TA_MEMALLOC */
#ifndef TA_MBALLOC
#define TA_MBALLOC		UINT_C(0x4000)		/* Ǘ̈J[lŊm */
#endif /* TA_MBALLOC */

/*
 *  ^[Qbg`̃G[`FbN}ÑftHgl̒`
 */
#ifndef TARGET_TSKATR
#define TARGET_TSKATR		0U		/* ^[Qbg`̃^XN */
#endif /* TARGET_TSKATR */

#ifndef TARGET_ISRATR
#define TARGET_ISRATR		0U		/* ^[Qbg`ISR */
#endif /* TARGET_ISRATR */

/*
 *  wb_t@CȂW[̊֐Eϐ̐錾
 */
#ifndef TOPPERS_MACRO_ONLY

/*
 *  eW[̏ikernel_cfg.cj
 */
extern void	initialize_object(void);

/*
 *  [`̎sikernel_cfg.cj
 */
extern void	call_inirtn(void);

/*
 *  I[`̎sikernel_cfg.cj
 */
extern void	call_terrtn(void);

/*
 *  ^XNReLXgp̃X^bN̈ikernel_cfg.cj
 */
extern const SIZE	istksz;		/* X^bN̈̃TCYiۂ߂lj */
extern STK_T *const	istk;		/* X^bN̈̐擪Ԓn */
#ifdef TOPPERS_ISTKPT
extern STK_T *const	istkpt;		/* X^bN|C^̏l */
#endif /* TOPPERS_ISTKPT */

/*
 *  J[lt郁̈ikernel_cfg.cj
 */
extern const SIZE	kmmsz;		/* J[lt郁̈̃TCY */
extern MB_T *const	kmm;		/* J[lt郁̈̐擪Ԓn */

/*
 *  J[lԃtOistartup.cj
 */
extern bool_t	kerflg;

/*
 *  J[l̋Nistartup.cj
 */
extern void	sta_ker(void);

/*
 *  J[l̏Iistartup.cj
 */
extern void	exit_kernel(void);

/*
 *  J[l̊t郁̈̊Ǘistartup.cj
 */
extern void initialize_kmm(void);
extern void *kernel_malloc(SIZE size);
extern void kernel_free(void *ptr);

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_KERNEL_IMPL_H */
