/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  $Id: task.c 96 2012-03-03 06:30:56Z nagasima $
 */

/*
 *		^XNǗW[
 */

#include "kernel_impl.h"
#include "wait.h"
#include "task.h"

/*
 *  g[XO}ÑftHg`
 */
#ifndef LOG_TEX_ENTER
#define LOG_TEX_ENTER(p_tcb, texptn)
#endif /* LOG_TEX_ENTER */

#ifndef LOG_TEX_LEAVE
#define LOG_TEX_LEAVE(p_tcb, texptn)
#endif /* LOG_TEX_LEAVE */

#ifdef TOPPERS_tskini

/*
 *  sԂ̃^XN
 */
TCB		*p_runtsk;

/*
 *  ōD揇ʂ̃^XN
 */
TCB		*p_schedtsk;

/*
 *  ^XNfBXpb`^^XNO[`NvtO
 */
bool_t	reqflg;

/*
 *  ݗDx}XNS
 */
bool_t	ipmflg;

/*
 *  fBXpb`֎~
 */
bool_t	disdsp;

/*
 *  ^XNfBXpb`\
 */
bool_t	dspflg;

/*
 *  fBL[
 */
QUEUE	ready_queue[TNUM_TPRI];

/*
 *  fBL[T[`̂߂̃rbg}bv
 */
uint16_t	ready_primap;

/*
 *  gpĂȂTCB̃Xg
 */
QUEUE	free_tcb;

/*
 *  ^XNǗW[̏
 */
void
initialize_task(void)
{
	uint_t	i, j;
	TCB		*p_tcb;
	TINIB	*p_tinib;

	p_runtsk = p_schedtsk = NULL;
	reqflg = false;
	ipmflg = true;
	disdsp = false;
	dspflg = true;

	for (i = 0; i < TNUM_TPRI; i++) {
		queue_initialize(&(ready_queue[i]));
	}
	ready_primap = 0U;

	for (i = 0; i < tnum_stsk; i++) {
		j = INDEX_TSK(torder_table[i]);
		p_tcb = &(tcb_table[j]);
		p_tcb->p_tinib = &(tinib_table[j]);
		p_tcb->actque = false;
		make_dormant(p_tcb);
		if ((p_tcb->p_tinib->tskatr & TA_ACT) != 0U) {
			make_active(p_tcb);
		}
	}
	queue_initialize(&free_tcb);
	for (j = 0; i < tnum_tsk; i++, j++) {
		p_tcb = &(tcb_table[i]);
		p_tinib = &(atinib_table[j]);
		p_tinib->tskatr = TA_NOEXS;
		p_tcb->p_tinib = ((const TINIB *) p_tinib);
		queue_insert_prev(&free_tcb, &(p_tcb->task_queue));
	}
}

#endif /* TOPPERS_tskini */

/*
 *  rbg}bvT[`֐
 *
 *  bitmap1̃rbg̓CłʁiEĵ̂T[`C̃rb
 *  gԍԂDrbgԍ́Cŉʃrbg0ƂDbitmap0w
 *  Ă͂ȂȂD̊֐ł́Cbitmap16rbgł邱Ƃ肵C
 *  uint16_t^ƂĂD
 *
 *  rbgT[`߂vZbTł́CrbgT[`߂g悤
 *  ǂꍇD̂悤ȏꍇɂ́C^[Qbg
 *  ˑŃrbgT[`߂gbitmap_search`C
 *  OMIT_BITMAP_SEARCH}N`΂悢D܂CrbgT[`߂
 *  T[`tȂǂ̗RŗDxƃrbgƂ̑ΉύXꍇ
 *  ́CPRIMAP_BIT}N`΂悢D
 *
 *  ܂CCuffsȂĈ悤ɒ`ăCu֐
 *  gǂ\D
 *		#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1U << (pri))
#endif /* PRIMAP_BIT */

#ifndef OMIT_BITMAP_SEARCH

static const unsigned char bitmap_search_table[] = { 0, 1, 0, 2, 0, 1, 0,
												3, 0, 1, 0, 2, 0, 1, 0 };

Inline uint_t
bitmap_search(uint16_t bitmap)
{
	uint_t	n = 0U;

	assert(bitmap != 0U);
	if ((bitmap & 0x00ffU) == 0U) {
		bitmap >>= 8;
		n += 8;
	}
	if ((bitmap & 0x0fU) == 0U) {
		bitmap >>= 4;
		n += 4;
	}
	return(n + bitmap_search_table[(bitmap & 0x0fU) - 1]);
}

#endif /* OMIT_BITMAP_SEARCH */

/*
 *  Dxrbg}bv󂩂̃`FbN
 */
Inline bool_t
primap_empty(void)
{
	return(ready_primap == 0U);
}

/*
 *  Dxrbg}bṽT[`
 */
Inline uint_t
primap_search(void)
{
	return(bitmap_search(ready_primap));
}

/*
 *  Dxrbg}bṽZbg
 */
Inline void
primap_set(uint_t pri)
{
	ready_primap |= PRIMAP_BIT(pri);
}

/*
 *  Dxrbg}bṽNA
 */
Inline void
primap_clear(uint_t pri)
{
	ready_primap &= ~PRIMAP_BIT(pri);
}

/*
 *  ōD揇ʃ^XÑT[`
 */
#ifdef TOPPERS_tsksched

TCB *
search_schedtsk(void)
{
	uint_t	schedpri;

	schedpri = primap_search();
	return((TCB *)(ready_queue[schedpri].p_next));
}

#endif /* TOPPERS_tsksched */

/*
 *  słԂւ̑J
 *
 *  ōD揇ʂ̃^XNXV̂́Csł^XNȂꍇ
 *  ƁCp_tcb̗DxōD揇ʂ̃^XN̗Dxꍇł
 *  D
 */
#ifdef TOPPERS_tskrun

bool_t
make_runnable(TCB *p_tcb)
{
	uint_t	pri = p_tcb->priority;

	queue_insert_prev(&(ready_queue[pri]), &(p_tcb->task_queue));
	primap_set(pri);

	if (p_schedtsk == (TCB *) NULL || pri < p_schedtsk->priority) {
		p_schedtsk = p_tcb;
		return(dspflg);
	}
	return(false);
}

#endif /* TOPPERS_tskrun */

/*
 *  słԂ瑼̏Ԃւ̑J
 *
 *  ōD揇ʂ̃^XNXV̂́Cp_tcbōD揇ʂ̃^XN
 *  ꍇłDp_tcbƓDx̃^XNɂꍇ́Cp_tcb
 *  ̎̃^XNōD揇ʂɂȂDłȂꍇ́CfBL[
 *  T[`KvD
 */
#ifdef TOPPERS_tsknrun

bool_t
make_non_runnable(TCB *p_tcb)
{
	uint_t	pri = p_tcb->priority;
	QUEUE	*p_queue = &(ready_queue[pri]);

	queue_delete(&(p_tcb->task_queue));
	if (queue_empty(p_queue)) {
		primap_clear(pri);
		if (p_schedtsk == p_tcb) {
			p_schedtsk = primap_empty() ? (TCB *) NULL : search_schedtsk();
			return(dspflg);
		}
	}
	else {
		if (p_schedtsk == p_tcb) {
			p_schedtsk = (TCB *)(p_queue->p_next);
			return(dspflg);
		}
	}
	return(false);
}

#endif /* TOPPERS_tsknrun */

/*
 *  x~Ԃւ̑J
 */
#ifdef TOPPERS_tskdmt

void
make_dormant(TCB *p_tcb)
{
	p_tcb->tstat = TS_DORMANT;
	p_tcb->priority = p_tcb->p_tinib->ipriority;
	p_tcb->wupque = false;
	p_tcb->enatex = false;
	p_tcb->texptn = 0U;
	LOG_TSKSTAT(p_tcb);
}

#endif /* TOPPERS_tskdmt */

/*
 *  x~ԂsłԂւ̑J
 */
#ifdef TOPPERS_tskact

bool_t
make_active(TCB *p_tcb)
{
	activate_context(p_tcb);
	p_tcb->tstat = TS_RUNNABLE;
	LOG_TSKSTAT(p_tcb);
	return(make_runnable(p_tcb));
}

#endif /* TOPPERS_tskact */

/*
 *  ^XN̗Dx̕ύX
 *
 *  ^XNsłԂ̏ꍇɂ́CfBL[̒ł̈ʒuύX
 *  DIuWFNg̑҂L[̒ő҂ԂɂȂĂꍇɂ́C
 *  L[̒ł̈ʒuύXD
 *
 *  ōD揇ʂ̃^XNXV̂́C(1) p_tcbōD揇ʂ̃^X
 *  NłāC̗DxꍇC(2) p_tcbōD揇ʂ̃^X
 *  Nł͂ȂCύX̗DxōD揇ʂ̃^XN̗Dx
 *  ꍇłD(1)̏ꍇɂ́CfBL[T[`KvD
 */
#ifdef TOPPERS_tskpri

bool_t
change_priority(TCB *p_tcb, uint_t newpri)
{
	uint_t	oldpri;

	oldpri = p_tcb->priority;
	p_tcb->priority = newpri;

	if (TSTAT_RUNNABLE(p_tcb->tstat)) {
		/*
		 *  ^XNsłԂ̏ꍇ
		 */
		queue_delete(&(p_tcb->task_queue));
		if (queue_empty(&(ready_queue[oldpri]))) {
			primap_clear(oldpri);
		}
		queue_insert_prev(&(ready_queue[newpri]), &(p_tcb->task_queue));
		primap_set(newpri);

		if (p_schedtsk == p_tcb) {
			if (newpri >= oldpri) {
				p_schedtsk = search_schedtsk();
				return(p_schedtsk != p_tcb && dspflg);
			}
		}
		else {
			if (newpri < p_schedtsk->priority) {
				p_schedtsk = p_tcb;
				return(dspflg);
			}
		}
	}
	else {
		if (TSTAT_WAIT_WOBJCB(p_tcb->tstat)) {
			/*
			 *  ^XNCEʐMIuWFNg̊ǗubN̋ʕ
			 *  iWOBJCBj̑҂L[ɂȂĂꍇ
			 */
			wobj_change_priority(((WINFO_WOBJ *)(p_tcb->p_winfo))->p_wobjcb,
																	p_tcb);
		}
	}
	return(false);
}

#endif /* TOPPERS_tskpri */

/*
 *  fBL[̉]
 *
 *  ōD揇ʂ̃^XNXV̂́CōD揇ʂ̃^XN^XNL
 *  [̖ɈړꍇłD
 */
#ifdef TOPPERS_tskrot

bool_t
rotate_ready_queue(uint_t pri)
{
	QUEUE	*p_queue = &(ready_queue[pri]);
	QUEUE	*p_entry;

	if (!queue_empty(p_queue) && p_queue->p_next->p_next != p_queue) {
		p_entry = queue_delete_next(p_queue);
		queue_insert_prev(p_queue, p_entry);
		if (p_schedtsk == (TCB *) p_entry) {
			p_schedtsk = (TCB *)(p_queue->p_next);
			return(dspflg);
		}
	}
	return(false);
}

#endif /* TOPPERS_tskrot */

/*
 *  ^XNO[`̌ďo
 *
 *  ASPJ[lł́C^XNO[`CPUbNԂɑJڂC
 *  ̏Ԃɖ߂Ƀ^[ꍇCJ[l̏Ԃɖ߂D
 */
#ifdef TOPPERS_tsktex

void
call_texrtn(void)
{
	TEXPTN	texptn;
	bool_t	saved_disdsp;

	saved_disdsp = disdsp;
	p_runtsk->enatex = false;
	do {
		texptn = p_runtsk->texptn;
		p_runtsk->texptn = 0U;

		t_unlock_cpu();
		LOG_TEX_ENTER(p_runtsk, texptn);
		(*((TEXRTN)(p_runtsk->p_tinib->texrtn)))(texptn,
												p_runtsk->p_tinib->exinf);
		LOG_TEX_LEAVE(p_runtsk, texptn);
		if (!t_sense_lock()) {
			t_lock_cpu();
		}
		if (!ipmflg) {
			t_set_ipm(TIPM_ENAALL);
			ipmflg = true;
		}
		disdsp = saved_disdsp;
		dspflg = !disdsp;
		p_runtsk->enatex = false;
		if (p_runtsk != p_schedtsk && dspflg) {
			/*
			 *  dispatchĂяóCݍċAďoɂȂ
			 *  邪CdispatchĂԑOp_runtsk->enatexfalseɂ
			 *  ΎxႪȂD̗RɂẮCuTOPPERS/ASP J[
			 *  l ݌vvQƂ̂ƁD
			 */
			dispatch();
		}
	} while (p_runtsk->texptn != 0U);
	p_runtsk->enatex = true;
}

/*
 *  ^XNO[`̋N
 */
#ifndef OMIT_CALLTEX

void
calltex(void)
{
	if (p_runtsk->enatex && p_runtsk->texptn != 0U && ipmflg) {
		call_texrtn();
	}
}

#endif /* OMIT_CALLTEX */
#endif /* TOPPERS_tsktex */
