$ ======================================================================
$ 
$   TOPPERS/ASP Kernel
$       Toyohashi Open Platform for Embedded Real-Time Systems/
$       Advanced Standard Profile Kernel
$ 
$   Copyright (C) 2008-2010 by Embedded and Real-Time Systems Laboratory
$               Graduate School of Information Science, Nagoya Univ., JAPAN
$  
$   L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
$   Ai{\tgEFAς̂܂ށDȉjgpEE
$   ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
$   (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
$       \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
$       XR[hɊ܂܂Ă邱ƁD
$   (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
$       pł`ōĔzzꍇɂ́CĔzzɔhLgip
$       ҃}jAȂǁjɁCL̒쌠\C̗pщL
$       ̖ۏ؋Kfڂ邱ƁD
$   (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
$       płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
$       ƁD
$     (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
$         쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
$     (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
$         񍐂邱ƁD
$   (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
$       QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
$       ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
$       RɊÂCL쌠҂TOPPERSvWFNg
$       Ɛӂ邱ƁD
$  
$   {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
$   TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
$   ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
$   A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
$   ̐ӔC𕉂ȂD
$ 
$   @(#) $Id: kernel_check.tf 2062 2011-04-10 16:27:41Z ertl-hiro $
$  
$ =====================================================================

$ 
$  ֐̐擪Ԓñ`FbN
$ 
$IF CHECK_FUNC_ALIGN || CHECK_FUNC_NONNULL$
$	// ^XNƃ^XNO[`̐擪Ԓñ`FbN
	$tinib = SYMBOL("_kernel_tinib_table")$
	$FOREACH tskid TSK.ID_LIST$
		$task = PEEK(tinib + offsetof_TINIB_task, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (task & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"task", TSK.TASK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && task == 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"task", TSK.TASK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$texrtn = PEEK(tinib + offsetof_TINIB_texrtn, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (texrtn & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR DEF_TEX.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"texrtn", TSK.TEXRTN[tskid], tskid, "DEF_TEX")$$END$
		$END$
		$tinib = tinib + sizeof_TINIB$
	$END$

$	// nh̐擪Ԓñ`FbN
	$cycinib = SYMBOL("_kernel_cycinib_table")$
	$FOREACH cycid CYC.ID_LIST$
		$cychdr = PEEK(cycinib + offsetof_CYCINIB_cychdr, 4)$
		$IF CHECK_FUNC_ALIGN && (cychdr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"cychdr", CYC.CYCHDR[cycid], cycid, "CRE_CYC")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && cychdr == 0$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"cychdr", CYC.CYCHDR[cycid], cycid, "CRE_CYC")$$END$
		$END$
		$cycinib = cycinib + sizeof_CYCINIB$
	$END$

$	// A[nh̐擪Ԓñ`FbN
	$alminib = SYMBOL("_kernel_alminib_table")$
	$FOREACH almid ALM.ID_LIST$
		$almhdr = PEEK(alminib + offsetof_ALMINIB_almhdr, 4)$
		$IF CHECK_FUNC_ALIGN && (almhdr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR ALM.TEXT_LINE[almid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"almhdr", ALM.ALMHDR[almid], almid, "CRE_ALM")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && almhdr == 0$
			$ERROR ALM.TEXT_LINE[almid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"almhdr", ALM.ALMHDR[almid], almid, "CRE_ALM")$$END$
		$END$
		$alminib = alminib + sizeof_ALMINIB$
	$END$

$	// ݃T[rX[`̐擪Ԓñ`FbN
	$isrinib = SYMBOL("_kernel_sisrinib_table")$
	$FOREACH order ISR.ORDER_LIST$
		$isr = PEEK(isrinib + offsetof_ISRINIB_isr, 4)$
		$IF CHECK_FUNC_ALIGN && (isr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR ISR.TEXT_LINE[order]$E_PAR: 
				$FORMAT(_("%1% `%2%\' in %4% is not aligned"),
				"isr", ISR.ISR[order], "ATT_ISR")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && isr == 0$
			$ERROR ISR.TEXT_LINE[order]$E_PAR: 
				$FORMAT(_("%1% `%2%\' in %4% is null"),
				"isr", ISR.ISR[order], "ATT_ISR")$$END$
		$END$
		$isrinib = isrinib + sizeof_ISRINIB$
	$END$
$END$

$ 
$  X^bN̈̐擪Ԓñ`FbN
$ 
$IF CHECK_STACK_ALIGN || CHECK_STACK_NONNULL$
$	// ^XÑX^bN̈̐擪Ԓñ`FbN
	$tinib = SYMBOL("_kernel_tinib_table")$
	$FOREACH tskid TSK.ID_LIST$
		$IF USE_TSKINICTXB$
			$stk = GET_STK_TSKINICTXB(tinib)$
		$ELSE$
			$stk = PEEK(tinib + offsetof_TINIB_stk, sizeof_void_ptr)$
		$END$
		$IF CHECK_STACK_ALIGN && (stk & (CHECK_STACK_ALIGN - 1)) != 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"stk", TSK.STK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$IF CHECK_STACK_NONNULL && stk == 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"stk", TSK.STK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$tinib = tinib + sizeof_TINIB$
	$END$

$	// ^XNReLXgp̃X^bN̈̐擪Ԓñ`FbN
	$istk = PEEK(SYMBOL("_kernel_istk"), sizeof_void_ptr)$
	$IF CHECK_STACK_ALIGN && (istk & (CHECK_STACK_ALIGN - 1)) != 0$
		$ERROR ICE.TEXT_LINE[1]$E_PAR: 
			$FORMAT(_("%1% `%2%\' in %3% is not aligned"),
			"istk", ICS.ISTK[1], "DEF_ICS")$$END$
	$END$
	$IF CHECK_STACK_NONNULL && istk == 0$
		$ERROR ICE.TEXT_LINE[1]$E_PAR: 
			$FORMAT(_("%1% `%2%\' in %3% is null"),
			"istk", ICS.ISTK[1], "DEF_ICS")$$END$
	$END$
$END$

$ 
$  Œ蒷v[̈̐擪Ԓñ`FbN
$ 
$IF CHECK_MPF_ALIGN || CHECK_MPF_NONNULL$
$	// Œ蒷v[̈̐擪Ԓñ`FbN
	$mpfinib = SYMBOL("_kernel_mpfinib_table")$
	$FOREACH mpfid MPF.ID_LIST$
		$mpf = PEEK(mpfinib + offsetof_MPFINIB_mpf, sizeof_void_ptr)$
		$IF CHECK_MPF_ALIGN && (mpf & (CHECK_MPF_ALIGN - 1)) != 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"mpf", MPF.MPF[mpfid], mpfid, "CRE_MPF")$$END$
		$END$
		$IF CHECK_MPF_NONNULL && mpf == 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"mpf", MPF.MPF[mpfid], mpfid, "CRE_MPF")$$END$
		$END$
		$mpfinib = mpfinib + sizeof_MPFINIB$
	$END$
$END$

$ 
$  ϒv[̈̐擪Ԓñ`FbN
$ 
$IF CHECK_MPL_ALIGN || CHECK_MPL_NONNULL$
$	// ϒv[̈̐擪Ԓñ`FbN
	$mplinib = SYMBOL("_kernel_mplinib_table")$
	$FOREACH mplid MPL.ID_LIST$
		$mpl = PEEK(mplinib + offsetof_MPLINIB_mpl, sizeof_void_ptr)$
		$IF CHECK_MPL_ALIGN && (mpl & (CHECK_MPL_ALIGN - 1)) != 0$
			$ERROR MPL.TEXT_LINE[mplid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"mpl", MPL.MPL[mplid], mplid, "CRE_MPL")$$END$
		$END$
		$IF CHECK_MPL_NONNULL && mpl == 0$
			$ERROR MPL.TEXT_LINE[mplid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"mpl", MPL.MPL[mplid], mplid, "CRE_MPL")$$END$
		$END$
		$mplinib = mplinib + sizeof_MPLINIB$
	$END$
$END$

$ 
$  J[lt郁̈̐擪Ԓñ`FbN
$ 
$IF CHECK_MB_ALIGN$
$	// J[lt郁̈̐擪Ԓñ`FbN
	$kmm = PEEK(SYMBOL("_kernel_kmm"), sizeof_void_ptr)$
	$IF CHECK_MB_ALIGN && (kmm & (CHECK_MB_ALIGN - 1)) != 0$
		$ERROR KMM.TEXT_LINE[1]$E_PAR: 
			$FORMAT(_("%1% `%2%\' in %3% is not aligned"),
			"kmm", KMM.KMM[1], "DEF_KMM")$$END$
	$END$
$END$
