/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 *
 *  Copyright (C) 2010-2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	vZbTˑW[iV850pj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_PRC_CONFIG_H
#define TOPPERS_PRC_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef TOPPERS_MACRO_ONLY

/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
#include "prc_insn.h"
#include <sil.h>

/*
 *  ^XNReLXgp̃X^bNl
 */
#define TOPPERS_ISTKPT(istk, istksz) ((STK_T *)((char *)(istk) + (istksz)))

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	void	*sp;		/* X^bN|C^ */
	FP		pc;			/* vOJE^ */
} TSKCTXB;

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ݗDx}XN색Cu
 *
 *	V850͕\ʏ͊ݗDx}XNȂ߁C\tgEFA
 *	G~[VD̓Iɂ́CCFG_INTŒ`ꂽݗvCݒ
 *	eݗDx}XN̒lɂɑΉISPRWX^l𐶐C
 *	ݒ肷邱ƂōsD
 */


/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 *
 *  AZũ\[Xt@CCN[hꍇ̂߂ɁCCASTgp
 */
#define EXT_IPM(iipm)	 (-CAST(PRI,(iipm)))	   /* \O\ */
#define INT_IPM(ipm)	 (CAST(uint32_t, -(ipm)))  /* O\\ */

#ifndef TOPPERS_MACRO_ONLY

/* (f)݂̊ݗDx */
extern uint8_t current_intpri;
/* CPUbNtO */
extern bool_t lock_flag;
/* CPUbNCPUbNOIMRWX^li[̈ */
extern uint16_t saved_imr[];
/* ֎~Ă銄ݗvi[̈ */
extern uint16_t disint_table[];
/* ݃lXg */
extern uint8_t intnest;

/*
 *  ReLXg̎Q
 */
Inline bool_t
sense_context(void)
{
    return (intnest > 0)? true : false;
}

/*
 *	݂̊ݗDx}XN(\)̎擾
 */
Inline uint8_t
get_intpri(void)
{
	return current_intpri;
}

/*
 *	݂̊ݗDx}XN(\)̐ݒ
 */

extern void set_intpri(uint8_t intpri);

/*
 *	IMRWX^l̑ޔ
 *
 *  restore_imrƑ΂ɌĂ΂Ȃ΂ȂȂD
 */
Inline void save_imr(void)
{
	uint_least8_t i;
	
	/* ISPRǂݏo */
	for(i = 0 ; i < IMR_SIZE ; i++)
	{
		saved_imr[i] = sil_reh_mem((uint16_t *)(IMR0 + (2 * i)));
	}
}

/*
 *  IMRWX^l̕A
 *
 *  save_imrƑ΂ɌĂ΂Ȃ΂ȂȂD
 */
Inline void restore_imr(void)
{
	uint_least8_t i;
	
	/* ISPRɏ */
	for(i = 0 ; i < IMR_SIZE ; i++)
	{
		sil_wrh_mem((uint16_t *)(IMR0 + (2 * i)) , saved_imr[i]);
	}
}

/*
 *  TOPPERSWݏf̎
 */


#endif /* TOPPERS_MACRO_ONLY */

/*
 *  CPUbNԂł̊ݗDx}XN
 *
 *  TIPM_LOCḰCCPUbNԂł̊ݗDx}XNCȂ킿CJ[l
 *  ǗÔׂ̂Ă݂̊}XNlɒ`D
 */
#define TIPM_LOCK		TMIN_INTPRI

/*
 *  CPUbNԂł̊ݗDx}XN̓\
 */
#define INTPRI_LOCK		INT_IPM(TIPM_LOCK)

/*
 *  TIPM_ENAALLiݗDx}XNSj̓\
 */
#define INTPRI_ENAALL	INT_IPM(TIPM_ENAALL)

#ifndef TOPPERS_MACRO_ONLY


/*
 *  CPUbNԂւ̈ڍs
 */
Inline void
x_lock_cpu(void)
{
	/* rŊ݂Ă͂ȂȂ߁C݂֎~D */
	disable_int();
	
	save_imr();	/* ݂IMRޔ */
	set_intpri(INTPRI_LOCK);
	lock_flag = true;
	
	/* ݉ */
	enable_int();
}

#define t_lock_cpu()    x_lock_cpu()
#define i_lock_cpu()    x_lock_cpu()

/*
 *  CPUbNԂ̉
 */
Inline void
x_unlock_cpu(void)
{
	/* rŊ݂Ă͂ȂȂ߁C݂֎~D */
	disable_int();
	
	restore_imr();	/* IMR𕜋A */
	set_intpri(current_intpri);
	lock_flag = false;
	
	/* ݉ */
	enable_int();
}

#define t_unlock_cpu()    x_unlock_cpu()
#define i_unlock_cpu()    x_unlock_cpu()

/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock(void)
{
    return lock_flag;
}

#define t_sense_lock()    x_sense_lock()
#define i_sense_lock()    x_sense_lock()

/* ena_int/disintŗLȊݔԍ͈̔͂̔ */
#define VALID_INTNO_CFGINT(intno)	(((7u <= (intno)) && ((intno) <= 63u))	\
										|| (intno == 1u))
#define VALID_INTNO_DISINT(intno)	VALID_INTNO_CFGINT((intno))

/* cre_intŗLȊݔԍ̎w  */
#define VALID_INTNO_CREINT          VALID_INTNO_CFGINT((intno))

/* cre_isrŗLȊݔԍ̎w  */
#define	VALID_INTNO_CREISR(intno)	VALID_INTNO_CFGINT((intno))

/*
 *  chg_ipmŗLȊݗDx͈̔͂̔
 */
#define VALID_INTPRI_CHGIPM(intpri) ((intpri) < 8)
/*
 * if́jݗDx}XN̐ݒ
 */

Inline void
x_set_ipm(PRI intpri)
{
	current_intpri = INT_IPM(intpri);
	set_intpri(current_intpri);
}

#define t_set_ipm(intpri)    x_set_ipm(intpri)
#define i_set_ipm(intpri)    x_set_ipm(intpri)

/*
 * if́jݗDx}XN̎Q
 */
Inline PRI
x_get_ipm(void)
{
	return EXT_IPM(current_intpri);
}

#define t_get_ipm()    x_get_ipm()
#define i_get_ipm()    x_get_ipm()

/*
 *  ōD揇ʃ^XNւ̃fBXpb`iprc_support.Sj
 *
 *  dispatch́C^XNReLXgĂяoꂽT[rXR[
 *  ĂяôׂŁC^XNReLXgECPUbNԁEfBXpb
 *  `ԁEif́jݗDx}XNSԂŌĂяo
 *  ΂ȂȂD
 */
extern void dispatch(void);

/*
 *  fBXpb`̓Jniprc_support.Sj
 *
 *  start_dispatch́CJ[lNɌĂяôׂŁCׂĂ̊
 *  ݂֎~ԁiS݃bNԂƓ̏ԁjŌĂяoȂ
 *  ȂȂD
 */
extern void start_dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`iprc_support.Sj
 *
 *  exit_and_dispatch́Cext_tskĂяôׂŁC^XNReL
 *  XgECPUbNԁEfBXpb`ԁEif́jݗD
 *  x}XNSԂŌĂяoȂ΂ȂȂD
 */
extern void exit_and_dispatch(void);

/*
 *  J[l̏Ǐďoiprc_support.Sj
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D̎_
 *  ŃX^bN̈gĂ͂ȂȂD
 *
 *  activate_contextCCC֐ł͂Ȃ}N`ƂĂ̂́C
 *  ̎_łTCB`ĂȂ߂łD
 */
extern void    start_r(void);

#define activate_context(p_tcb)												\
{																			\
	(p_tcb)->tskctxb.sp = (uint32_t *)(((uint32_t)(p_tcb)->p_tinib->stk) + 	\
								(p_tcb)->p_tinib->stksz);					\
	(p_tcb)->tskctxb.pc = (void *) start_r;									\
}

/*
 * ^[QbgˑɊ܂܂W̗OǗ@\̏pȂ
 */
#define OMIT_INITIALIZE_EXCEPTION

/*
 * CPUOnh̏
 * @}NɂAasp/kernel/exception.hŃvg^Cv錾
 * @Ă邽߁A֐ƂĒ`Ȃ΂ȂȂB
 */
extern void initialize_exception(void);

/*
 *  ݔԍE݃nhԍ
 *
 *  ݃nhԍ(inhno)Ɗݔԍ(intno)́CxN^ԍpD
 *
 *  xN^ԍ64n܂邽߁Ĉ܂܂̒lDxǗ̃e[u
 *  CfbNXɗpƁCʂȗ̈悪D̂߁CJ[l
 *  ł́C-64lpD
 *
 *  \̖ÓCiintno,iinhnoƂD
 */

/*
 * ݃nhԍ̓EO\ݕϊ
 */
/* \O\ */
#define EXT_INHNO(iintno) (iintno)
/* O\\ */
#define INT_INHNO(intno)  (intno)

/*
 * ݔԍ̓EO\ݕϊ
 */
/* \O\ */
#define EXT_INTNO(iintno)   (iintno)
/* O\\ */
#define INT_INTNO(intno)    (intno)

/*
 *  CPUOnhԍ
 *
 */
#define VALID_EXCNO_DEFEXC(excno) (1)

/*
 *  ݃nh̐ݒ
 *
 *	TFt@CŐ邽߁CɂĂ
 */

#define x_define_inh(inhno, int_entry)

/*
 *  ݃nh̏o̐}N
 *
 */
#define _INT_ENTRY(inhno, inthdr)    _kernel_##inthdr##_##inhno
#define INT_ENTRY(inhno, inthdr)     _INT_ENTRY(inhno, inthdr)

#define _INTHDR_ENTRY(inhno, inthdr) extern void _kernel_##inthdr##_##inhno(void);
#define INTHDR_ENTRY(inhno, inhno_num, inthdr)  _INTHDR_ENTRY(inhno, inthdr) 

/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	uint32_t intreg_addr = INTREG_ADDRESS(intno);
	
	if(!VALID_INTNO_DISINT(intno))
	{
		return false;
	}
	
	/* 6bitڂZbg */
	sil_wrb_mem((uint8_t *)intreg_addr , 
		sil_reb_mem((uint8_t *)intreg_addr) | (0x01U << 6));
	/* ݋֎~ԃrbgZbg */
	disint_table[(intno / 16u)] |= (1u << (intno % 16u));
	
	return(true);
}

#define t_disable_int(intno) x_disable_int(intno)
#define i_disable_int(intno) x_disable_int(intno)

/*
 *  ݗv֎~tỎ
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD
 */

Inline bool_t
x_enable_int(INTNO intno)
{
	uint32_t intreg_addr = INTREG_ADDRESS(intno);
	
	if(!VALID_INTNO_DISINT(intno))
	{
		return false;
	}
	
	/* 6bitڂNA */
	sil_wrb_mem((uint8_t *)intreg_addr , 
		sil_reb_mem((uint8_t *)intreg_addr) & ~(0x01U << 6));
	/* ݋֎~ԃrbgNA */
	disint_table[(intno / 16u)] &= ~(1u << (intno % 16u));
	
	return(true);
}

#define t_enable_int(intno) x_enable_int(intno)
#define i_enable_int(intno) x_enable_int(intno)


/*
 *  ݗṽNA
 */
Inline void
x_clear_int(INTNO intno)
{
	uint32_t intreg_addr = INTREG_ADDRESS(intno);
	
	if(!VALID_INTNO_DISINT(intno))
	{
		return ;
	}
	
	/* 7bitڂNA */
	sil_wrb_mem((uint8_t *)intreg_addr , 
		sil_reb_mem((uint8_t *)intreg_addr) & ~(0x01U << 7));
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)

/*
 *  ݗṽ`FbN
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	uint32_t intreg_addr = INTREG_ADDRESS(intno);
	
	if(!VALID_INTNO_DISINT(intno))
	{
		return false;
	}
	
	/* 6bitڂ̃rbglŔ肷D*/
	if((sil_reb_mem((uint8_t *)intreg_addr) & (0x01U << 6u)) != 0x00)
	{
		return true;
	}
	
	return false;
}

#define t_probe_int(intno) x_probe_int(intno)
#define i_probe_int(intno) x_probe_int(intno)


/*
 *  ݗvC̑̐ݒ
 *
 *  V850ł́CJ[lň銄ݗDx8iKł邽߁Cintpri
 *  Ƃė^邱Ƃłl-7`0WłD
 */
extern void x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ݃nhŕKvIRC
 *
 *  ݗv͎NA邽߉Ȃ
 */
Inline void
i_begin_int(INTNO intno)
{
}

/*
 *  ݃nh̏oŕKvIRC
 *
 * 
 */
Inline void
i_end_int(INTNO intno)
{
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  CPUOnh֌W
 */

/*
 *  Onh p_excinf eo߂̃}N
 */
#define P_EXCINF_OFFSET_PC				UINT_C(0)
#define P_EXCINF_OFFSET_SP				UINT_C(4)
#define P_EXCINF_OFFSET_PSW				UINT_C(8)
#define P_EXCINF_OFFSET_ECR				UINT_C(12)
#define P_EXCINF_OFFSET_CPU_LOCKED		UINT_C(16)

#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUOnh̐ݒ
 *
 *  ev[gt@CŗOnh𐶐邽߁Cɒ`D
 */
#define x_define_exc(excno, exc_entry)


/*
 *  CPUOnh̓̐}N
 */
#define EXC_ENTRY2(excno, exchdr)    _kernel_##exchdr##_##excno
#define EXC_ENTRY(excno, exchdr)     EXC_ENTRY2(excno, exchdr)
#define EXCHDR_ENTRY2(excno, exchdr) extern void _kernel_##exchdr##_##excno(void *sp);
#define EXCHDR_ENTRY(excno, excno_num, exchdr)  EXCHDR_ENTRY2(excno, exchdr)



/*
 *  CPUO̔̃ReLXg̎Q
 *
 *  CPUO̔̃ReLXgC^XNReLXg̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_context(void)
{
	return (intnest > 1u)? true : false;
}

/*
 *  CPUO̔̑S݋֎~Ԃ̎Q
 *
 *  CPUO̔̑S݋֎~ԂCS݋֎~Ԃ̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_id(void *p_excinf)
{
	return (((*((uint32_t *)((uint32_t)p_excinf + P_EXCINF_OFFSET_PSW)))
				& (1u << 5)) != 0u)?
			true : false;
}

/*
 *  CPUO̔CPUbNԂ̎Q
 *
 *  CPUO̔CPUbNԂCCPUbNԂ̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_lock(void *p_excinf)
{
	return *((bool_t *)((uint32_t)p_excinf + P_EXCINF_OFFSET_CPU_LOCKED));
}

/*
 *  CPUO̔̃ReLXgƊ݂̃}XNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłCS݃bNԂłȂCCPUbNԂłȂCi
 *  f́jݗDx}XNSԂł鎞trueCłȂ
 *  falseԂiCPUOJ[lǗO̊ݏŔꍇ
 *  ɂfalseԂjD
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return ((exc_sense_context() == false)
			&& (exc_sense_lock(p_excinf) == false)
			&& (exc_sense_id(p_excinf) == false)
			&& (get_intpri() == INTPRI_ENAALL))?
			true : false;
}

/*
 * TrapaȊO̗Oœo^ĂȂOƌĂяo
 */
extern void default_exc_handler(void *p_excinf);

/*
 * o^݂̊ꍇɌĂяo
 */
extern void default_int_handler(void *p_excinf);

/*
 *  vZbTˑ̏
 */
extern void prc_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void prc_terminate(void);

/*
 *  atexit̏ƃfXgN^̎s
 */
Inline void
call_atexit(void)
{
    extern void    software_term_hook(void);
    void (*volatile fp)(void) = software_term_hook;

    /*
     *  software_term_hookւ̃|C^CUvolatileŵfpɑ
     *  Ăĝ́C0Ƃ̔rœKō폜Ȃ悤ɂ邽
     *  ߂łD
     */
    if (fp != 0) {
        (*fp)();
    }
}

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_MACRO_ONLY */

#endif /* TOPPERS_PRC_CONFIG_H */
