/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: mempvar.h 1966 2010-11-20 07:23:56Z ertl-hiro $
 */

/*
 *		ϒv[@\
 */

#ifndef TOPPERS_MEMPVAR_H
#define TOPPERS_MEMPVAR_H

#include <queue.h>
#include "kmem.h"

/*
 *  ϒubNǗubN
 *
 *  nexttB[hɂ́CubNčς݂̏ꍇINDEX_ALLOCC
 *  Ă̏ꍇ͎̖ăubÑCfbNXԍi[D
 *  Ō̖ăubN̏ꍇɂ́CINDEX_NULLi[D
 */
typedef struct variable_memoryblock_management_block {
	uint_t		next;			/* ̖ăubN */
} MPLMB;

/*
 *  ϒv[ubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct variable_memorypool_initialization_block {
	ATR			mplatr;			/* ϒv[ */
	uint_t		mplsz;			/* ϒv[̈̃TCYioCgj */
	void		*mpl;			/* ϒv[̈̐擪Ԓn */
	MPLMB		*p_mplmb;		/* ϒv[Ǘ̈̐擪Ԓn */
} MPLINIB;

/*
 *  ϒv[ǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct variable_memorypool_control_block {
	QUEUE		wait_queue;		/* ϒv[҂L[ */
	const MPLINIB *p_mplinib;	/* ubNւ̃|C^ */
	KMEMB		*free_list;
} MPLCB;

/*
 *  ϒv[҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 */
typedef struct variable_memorypool_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	MPLCB		*p_mplcb;		/* ҂Ăϒv[̊ǗubN*/
	uint_t		blksz;			/* ҂Ăϒv[̃TCYioCgj*/
	void		*blk;			/* lubN */
} WINFO_MPL;

/*
 *  gpĂȂϒv[ǗubÑXg
 */
extern QUEUE	free_mplcb;

/*
 *  ϒv[ID̍őlikernel_cfg.cj
 */
extern const ID	tmax_mplid;
extern const ID	tmax_smplid;

/*
 *  ϒv[ubÑGAikernel_cfg.cj
 */
extern const MPLINIB	mplinib_table[];
extern MPLINIB			amplinib_table[];

/*
 *  ϒv[ǗubÑGAikernel_cfg.cj
 */
extern MPLCB	mplcb_table[];

/*
 *  ϒv[ǗubNϒv[IDo
 *  ߂̃}N
 */
#define	MPLID(p_mplcb)	((ID)(((p_mplcb) - mplcb_table) + TMIN_MPLID))

/*
 *  ϒv[@\̏
 */
extern void	initialize_mempvar(void);

#endif /* TOPPERS_MEMPVAR_H */
