/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_subr_cs.c,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1990, 1993, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp_subr.c	8.2 (Berkeley) 5/24/95
 * $FreeBSD: src/sys/netinet/tcp_subr.c,v 1.49.2.4 1999/08/29 16:29:55 peter Exp $
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet6/nd6.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>
#include <netinet/in_itron.h>

#ifdef SUPPORT_TCP

#ifdef TCP_CFG_SWBUF_CSAVE

#ifndef TCP_CFG_SWBUF_CSAVE_ONLY

/*
 *  TCP ʐM[_̑MEBhobt@̏ȃRs[@\Lȏꍇ
 *  AʐM[_̑MEBhobt@icep->sbufj̒lɂA
 *  TCP ʐM[_ɑMEBhobt@̏ȃRs[@\gp邩A
 *  gpȂ؂ւB
 */

/*
 *  tcp_drop_swbuf -- MEBhobt@w肳ꂽINebg폜iIjB
 */

void
tcp_drop_swbuf (T_TCP_CEP *cep, uint_t len)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		tcp_drop_swbuf_ncs(cep, len);
	else
		tcp_drop_swbuf_cs(cep, len);
}

/*
 *  tcp_write_swbuf -- MEBhobt@Ƀf[^ށiIjB
 */

ER_UINT
tcp_write_swbuf (T_TCP_CEP *cep, void *data, uint_t len)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		return tcp_write_swbuf_ncs(cep, data, len);
	else
		return tcp_write_swbuf_cs(cep, data, len);
}

/*
 *  tcp_read_swbuf -- MEBhobt@f[^ǂݏoiIjB
 */

void
tcp_read_swbuf (T_TCP_CEP *cep, T_NET_BUF *output, uint_t len, uint_t doff)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		tcp_read_swbuf_ncs(cep, output, len, doff);
}

/*
 *  tcp_wait_swbuf -- MEBhobt@Ƒ̎MEBhĴ҂iIjB
 */

ER
tcp_wait_swbuf (T_TCP_CEP *cep, TMO tmout)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		return tcp_wait_swbuf_ncs(cep, tmout);
	else
		return tcp_wait_swbuf_cs(cep, tmout);
}

/*
 *  tcp_get_swbuf_addr -- MEBhobt@̋󂫃AhXliIjB
 */

ER_UINT
tcp_get_swbuf_addr (T_TCP_CEP *cep, void **p_buf)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		return tcp_get_swbuf_addr_ncs(cep, p_buf);
	else
		return tcp_get_swbuf_addr_cs(cep, p_buf);
}

/*
 *  tcp_send_swbuf -- MEBhobt@̃f[^𑗐M\ɂiIjB
 */

void
tcp_send_swbuf (T_TCP_CEP *cep, uint_t len)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		tcp_send_swbuf_ncs(cep, len);
	else
		tcp_send_swbuf_cs(cep, len);
}

/*
 *  tcp_free_swbufq -- MEBhobt@L[̉wiIjB
 */

void
tcp_free_swbufq (T_TCP_CEP *cep)
{
	if (!IS_PTR_DEFINED(cep->sbuf))
		tcp_free_swbufq_cs(cep);
}

/*
 *  tcp_alloc_swbuf -- MEBhobt@p̃lbg[Nobt@̊蓖ĂwiIjB
 */

void
tcp_alloc_swbuf (T_TCP_CEP *cep)
{
	if (!IS_PTR_DEFINED(cep->sbuf))
		tcp_alloc_swbuf_cs(cep);
}

/*
 *  tcp_is_swbuf_full -- MEBhobt@t`FbNiIjB
 */

bool_t
tcp_is_swbuf_full (T_TCP_CEP *cep)
{
	if (IS_PTR_DEFINED(cep->sbuf))
		return tcp_is_swbuf_full_ncs(cep);
	else
		return tcp_is_swbuf_full_cs(cep);
}

#endif	/* of #ifndef TCP_CFG_SWBUF_CSAVE_ONLY */

/*
 *  tcp_drop_swbuf_cs -- MEBhobt@w肳ꂽINebg폜ipjB
 */

void
tcp_drop_swbuf_cs (T_TCP_CEP *cep, uint_t len)
{

	/*MEBhobt@w肳ꂽINebg폜B*/
	cep->swbuf_count -= (uint16_t)len;

	/* Mς݂ŁAACK҂̎́AACKɕύXB*/
	if (len > 0 && (cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SENT) {
		cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_ACKED;
		sig_sem(SEM_TCP_POST_OUTPUT);
	}
}

/*
 *  tcp_write_swbuf_cs -- MEBhobt@Ƀf[^ށipjB
 */

ER_UINT
tcp_write_swbuf_cs (T_TCP_CEP *cep, void *data, uint_t len)
{
	ER_UINT	error;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	if ((error = net_buf_siz(cep->swbufq)) > 0 && error >= IF_IP_TCP_HDR_SIZE) {


		/*
		 *  +-----------+--------+---------+---------+
		 *  | Ehter HDR | IP HDR | TCP HDR | TCP SDU |
		 *  +-----------+--------+---------+---------+
		 *        14        20        20        n
		 *   <---------------- error --------------->
		 *              ^
		 *              net_buf  4 INebgEɃACĂB
		 *
		 *  tcp_output  ip_output ŁA`FbNTvZƂA
		 *  n  4 INebgEɂȂ悤 SDU ̌ 0 
		 *  pbfBOB̕lđMEBhobt@
		 *  󂫃TCY 4 INebgEɒB
		 */
		error = (uint_t)(((error - IF_IP_TCP_HDR_SIZE) >> 2 << 2) + IF_IP_TCP_HDR_SIZE);

		if (len > cep->sbufsz - cep->swbuf_count)
			len = (uint_t)(cep->sbufsz - cep->swbuf_count);
		if (len > (error - IF_IP_TCP_HDR_SIZE))
			len = (uint_t)(error - IF_IP_TCP_HDR_SIZE);

		/* MEChTCYɂTCY𒲐B*/
		if (len > cep->snd_wnd) 
			len = cep->snd_wnd;
		if (len > cep->snd_cwnd)
			len = cep->snd_cwnd;

		/* ̍őMZOgTCY (maxseg) 𒴂Ȃ悤ɂB*/
		if (len > cep->maxseg) 
			len = cep->maxseg;

		/* f[^ڂB*/
		memcpy(cep->sbuf_wptr, (void*)((uint8_t*)data), (size_t)len);
		cep->sbuf_wptr   += len;
		cep->swbuf_count += len;
		error             = len;

		/* lbg[Nobt@ IP f[^Oݒ肷B*/
		cep->swbufq->len = (uint16_t)(cep->swbuf_count + IF_IP_TCP_HDR_SIZE);
		SET_IP_SDU_SIZE(GET_IP_HDR(cep->swbufq), cep->swbuf_count + TCP_HDR_SIZE);

		/* tOAM\ɐݒ肷B*/
		cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_SEND_READY;
	}

	else {	/* MEChobt@s */
		syslog(LOG_WARNING, "[TCP] illegal window buff for send, CEP: %d, %4d < %4d.",
		                    GET_TCP_CEPID(cep), error, IF_IP_TCP_HDR_SIZE);

		/* MEBhobt@L[̃lbg[Nobt@B*/
		tcp_free_swbufq_cs(cep);
	}

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	return error;
}

/*
 *  tcp_wait_swbuf_cs -- MEBhobt@Ƒ̎MEBhĴ҂ipjB
 */

ER
tcp_wait_swbuf_cs (T_TCP_CEP *cep, TMO tmout)
{
	FLGPTN	flag;
	SYSTIM	before, after;
	ER	error;
	int_t	win;


	/* MEBhobt@čς݂ŁA󂫂ΏIB*/
	if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_NBUF_READY &&
	    (cep->swbuf_count + IF_IP_TCP_HDR_SIZE) < net_buf_siz(cep->swbufq))
		return E_OK;

	/* Mł΁AI܂őҋ@B*/
	while ((cep->flags & TCP_CEP_FLG_WBCS_MASK) != TCP_CEP_FLG_WBCS_FREE) {

		/* M҂̎Ԃ tmout 猸B*/
		if (!(tmout == TMO_POL || tmout == TMO_FEVR))
			syscall(get_tim(&before));

		if ((error = twai_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY,
		                      TWF_ORW, &flag, tmout)) != E_OK)
			return error;
		syscall(clr_flg(cep->snd_flgid, (FLGPTN)(~TCP_CEP_EVT_SWBUF_READY)));

		/* M҂̎Ԃ tmout 猸B*/
		if (!(tmout == TMO_POL || tmout == TMO_FEVR)) {
			syscall(get_tim(&after));
			if (after - before > tmout)
				return E_TMOUT;
			tmout -= (TMO)(after - before);
		}

		/*
		 *  Mł邩ACEP  FSM ԂB
		 *  MEChobt@󂭂܂ő҂ԂɁAMs\ɂȂꍇ́A
		 *  RlNVؒfꂽƂӖĂB
		 */
		if (!TCP_FSM_CAN_SEND_MORE(cep->fsm_state))
			return E_CLS;
	}

	/* ̎MEBhĂꍇ́AJ܂őҋ@B*/
	while (true) {

		/*
		 *  snd_wnd:  ̎M\EBhTCY
		 *  snd_cwnd: tsEBhTCY
		 *
		 *  win: ǂ炩EBhTCYɐݒ肷B
		 */
		win = cep->snd_wnd < cep->snd_cwnd ? cep->snd_wnd : cep->snd_cwnd;
		if (win > 0)
			break;

		/* J҂̎Ԃ tmout 猸B*/
		if (!(tmout == TMO_POL || tmout == TMO_FEVR))
			syscall(get_tim(&before));

		if ((error = twai_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY,
		                      TWF_ORW, &flag, tmout)) != E_OK)
			return error;
		syscall(clr_flg(cep->snd_flgid, (FLGPTN)(~TCP_CEP_EVT_SWBUF_READY)));

		/* J҂̎Ԃ tmout 猸B*/
		if (!(tmout == TMO_POL || tmout == TMO_FEVR)) {
			syscall(get_tim(&after));
			if (after - before > tmout)
				return E_TMOUT;
			tmout -= (TMO)(after - before);
		}

		/*
		 *  Mł邩ACEP  FSM ԂB
		 *  MEChobt@󂭂܂ő҂ԂɁAMs\ɂȂꍇ́A
		 *  RlNVؒfꂽƂӖĂB
		 */
		if (!TCP_FSM_CAN_SEND_MORE(cep->fsm_state))
			return E_CLS;
	}

	/* lbg[Nobt@lB*/
	if ((error = tcp_get_segment(&cep->swbufq, cep, 0,
	                             TCP_CFG_SWBUF_CSAVE_MIN_SIZE,
	                             TCP_CFG_SWBUF_CSAVE_MAX_SIZE - IF_IP_TCP_HDR_SIZE,
	                             NBA_SEARCH_DESCENT, tmout)) != E_OK)
		return error;

	/* MEBhobt@B*/
	tcp_init_swbuf(cep);

	return E_OK;
}

/*
 *  tcp_get_swbuf_addr_cs -- MEBhobt@̋󂫃AhXlipjB
 */

ER_UINT
tcp_get_swbuf_addr_cs (T_TCP_CEP *cep, void **p_buf)
{
	ER_UINT	error;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	if ((error = net_buf_siz(cep->swbufq)) > 0) {

		/*
		 *  +-----------+--------+---------+---------+
		 *  | Ehter HDR | IP HDR | TCP HDR | TCP SDU |
		 *  +-----------+--------+---------+---------+
		 *        14        20        20        n
		 *   <---------------- error --------------->
		 *              ^
		 *              net_buf  4 INebgEɃACĂB
		 *
		 *  tcp_output  ip_output ŁA`FbNTvZƂA
		 *  n  4 INebgEɂȂ悤 SDU ̌ 0 
		 *  pbfBOB̕lđMEBhobt@
		 *  󂫃TCY 4 INebgEɒB
		 */
		error = (uint_t)(((error - IF_IP_TCP_HDR_SIZE) >> 2 << 2) - cep->swbuf_count);

		/* MEChTCYɂTCY𒲐B*/
		if (error > cep->snd_wnd) 
			error = cep->snd_wnd;
		if (error > cep->snd_cwnd)
			error = cep->snd_cwnd;

		/* ̍őMZOgTCY (maxseg) 𒴂Ȃ悤ɂB*/
		if (error > cep->maxseg) 
			error = cep->maxseg;

		/* MEBhobt@̋󂫃f[^ݒ肵A̒lԂB*/
		cep->get_buf_len = error;

		/* MEBhobt@̋󂫃AhX̐擪ݒ肷B*/
		*p_buf = cep->sbuf_wptr;
	}

	else {	/* lbg[Nobt@s */

		/* MEBhobt@L[̃lbg[Nobt@B*/
		tcp_free_swbufq_cs(cep);
	}

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	return error;
}

/*
 *  tcp_send_swbuf_cs -- MEBhobt@̃f[^𑗐M\ɂipjB
 */

void
tcp_send_swbuf_cs (T_TCP_CEP *cep, uint_t len)
{
	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	cep->sbuf_wptr  += len;
	cep->swbuf_count += len;

	/* lbg[Nobt@ IP f[^Oݒ肷B*/
	cep->swbufq->len = (uint16_t)(cep->swbuf_count + IF_IP_TCP_HDR_SIZE);
	SET_IP_SDU_SIZE(GET_IP_HDR(cep->swbufq), len + TCP_HDR_SIZE);

	/* tcp_get_buf ̊ĒZbgB*/
	cep->get_buf_len = 0;

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	/* tOAM\ɐݒ肵AIɑMB*/
	cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_SEND_READY
	                                               | TCP_CEP_FLG_FORCE
	                                               | TCP_CEP_FLG_FORCE_CLEAR
	                                               | TCP_CEP_FLG_POST_OUTPUT;
}

/*
 *  tcp_free_swbufq_cs -- MEBhobt@L[̉wipjB
 *
 *    :
 *      Kvł΁Å֐ĂяoOɁAʐM[_bNA
 *      ߂AKvB
 */

void
tcp_free_swbufq_cs (T_TCP_CEP *cep)
{
	/* MEBhobt@̋󂫑҂B*/
	cep->flags &= ~TCP_CEP_FLG_WBCS_NBUF_REQ;

	if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) != TCP_CEP_FLG_WBCS_FREE) {
		/*
		 *  MEBhobt@폜邽߂ɁAtO ACK ɐݒ肵A
		 *  TCP o̓^XNNB
		 */
		cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_ACKED;
		sig_sem(SEM_TCP_POST_OUTPUT);
	}
}

/*
 *  tcp_alloc_swbuf_cs -- MEBhobt@p̃lbg[Nobt@̊蓖ĂwipjB
 */

void
tcp_alloc_swbuf_cs (T_TCP_CEP *cep)
{
	cep->flags |= TCP_CEP_FLG_WBCS_NBUF_REQ;

	/*
	 *  MEBhobt@gp̏ꍇ̂݁A
	 *  MEBhobt@p̃lbg[Nobt@̊蓖ĂwB
	 */
	if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_FREE)
		sig_sem(SEM_TCP_POST_OUTPUT);
}

/*
 *  tcp_is_swbuf_full_cs -- MEBhobt@t`FbNipjB
 */

bool_t
tcp_is_swbuf_full_cs (T_TCP_CEP *cep)
{
	return (cep->flags & TCP_CEP_FLG_WBCS_MASK) != TCP_CEP_FLG_WBCS_NBUF_READY ||
	        cep->swbuf_count >= cep->swbufq->len - IF_IP_TCP_HDR_SIZE;
}

/*
 *  tcp_init_swbuf -- MEBhobt@ipjB
 *
 *    : tcp_get_segment Ńlbg[Nobt@l
 *          ɌĂяoƁB
 */

void
tcp_init_swbuf (T_TCP_CEP *cep)
{
	/* MEChobt@̎gpTCYZbgB*/
	cep->swbuf_count = 0;

	/* MEChobt@̃AhXݒ肷B*/
	cep->sbuf_wptr = cep->sbuf_rptr = GET_TCP_SDU(cep->swbufq, IF_IP_TCP_HDR_OFFSET);

	/* tOAlbg[Nobt@čς݂ɐݒ肷B*/
	cep->flags = (cep->flags & ~(TCP_CEP_FLG_WBCS_NBUF_REQ | TCP_CEP_FLG_WBCS_MASK))
	                         |   TCP_CEP_FLG_WBCS_NBUF_READY;
}

/*
 *  tcp_push_res_nbuf -- lbg[Nobt@\񂷂ipjB
 */

T_NET_BUF *
tcp_push_res_nbuf (T_NET_BUF *nbuf)
{
	static int_t last_ix = 0;

	T_TCP_CEP	*cep;
 	int_t		ix, sel_ix;

	if (++ last_ix == tmax_tcp_cepid)
		last_ix = 0;
	sel_ix = ix = last_ix;
	do {
		cep = &tcp_cep[ix];
		if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_NBUF_PEND) {

			/* lbg[Nobt@\񂷂B*/
			cep->swbufq = nbuf;
			nbuf = NULL;

			/* tO\ɐݒ肷B*/
			cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_NBUF_RSVD;
			sel_ix = ix;
			break;
		}
		if (++ ix == tmax_tcp_cepid)
			ix = 0;
	} while (ix != last_ix);

	last_ix = sel_ix;

	return nbuf;
}

/*
 *  tcp_pull_res_nbuf -- \񂵂Ălbg[Nobt@ԂipjB
 */

T_NET_BUF *
tcp_pull_res_nbuf (ATR nbatr)
{
	T_NET_BUF	*nbuf;
	T_TCP_CEP	*cep;

	cep = GET_TCP_CEP(nbatr & NBA_ID_MASK);
	if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_NBUF_RSVD) {

		/* \񂵂Ălbg[Nobt@ԂB*/
		nbuf = cep->swbufq;
		cep->swbufq = NULL;

		/* TCP o̓^XNNB*/
		sig_sem(SEM_TCP_POST_OUTPUT);
	}
	else
		nbuf = NULL;

	return nbuf;
}

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

#ifdef TCP_CFG_RWBUF_CSAVE 

#ifndef TCP_CFG_RWBUF_CSAVE_ONLY

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\Lȏꍇ
 *  AʐM[_̎MEBhobt@icep->rbufj̒lɂA
 *  TCP ʐM[_ɎMEBhobt@̏ȃRs[@\gp邩A
 *  gpȂ؂ւB
 */

/*
 *  tcp_drop_rwbuf -- MEBhobt@L[̍ŏ̃lbg[Nobt@B
 */

void
tcp_drop_rwbuf (T_TCP_CEP *cep, uint_t len)
{
	if (IS_PTR_DEFINED(cep->rbuf))
		tcp_drop_rwbuf_ncs(cep, len);
	else
		tcp_drop_rwbuf_cs(cep, len);
}

/*
 *  tcp_read_rwbuf -- MEBhobt@w肳ꂽINebgǂݏoB
 */

uint_t
tcp_read_rwbuf (T_TCP_CEP *cep, void *data, uint_t len)
{
	if (IS_PTR_DEFINED(cep->rbuf))
		return tcp_read_rwbuf_ncs(cep, data, len);
	else
		return tcp_read_rwbuf_cs(cep, data, len);
}

/*
 *  tcp_get_rwbuf_addr -- MEBhobt@̋󂫃AhXlB
 */

uint_t
tcp_get_rwbuf_addr (T_TCP_CEP *cep, void **p_buf)
{
	if (IS_PTR_DEFINED(cep->rbuf))
		return tcp_get_rwbuf_addr_ncs(cep, p_buf);
	else
		return tcp_get_rwbuf_addr_cs(cep, p_buf);
}

/*
 *  tcp_free_rwbufq -- MEBhobt@L[B
 */

void
tcp_free_rwbufq (T_TCP_CEP *cep)
{
	if (!IS_PTR_DEFINED(cep->rbuf))
		tcp_free_rwbufq_cs(cep);
}

/*
 *  tcp_write_rwbuf -- MEBhobt@Ƀf[^ށB
 */

void
tcp_write_rwbuf (T_TCP_CEP *cep, T_NET_BUF *input, uint_t thoff)
{
	if (IS_PTR_DEFINED(cep->rbuf))
		tcp_write_rwbuf_ncs(cep, input, thoff);
	else
		tcp_write_rwbuf_cs(cep, input, thoff);
}

#endif	/* of #ifndef TCP_CFG_RWBUF_CSAVE_ONLY */

/*
 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\L
 */

/*
 *  tcp_drop_rwbuf -- MEBhobt@L[̍ŏ̃lbg[Nobt@B
 */

void
tcp_drop_rwbuf_cs (T_TCP_CEP *cep, uint_t len)
{
	T_TCP_Q_HDR	*qhdr;

	if (cep->rwbufq != NULL) {

		qhdr = GET_TCP_Q_HDR(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff);
		cep->rwbuf_count -= len;

		/* lbg[Nobt@Ƀf[^ȂB*/
		if (len == qhdr->slen) {
			T_NET_BUF *next;

#ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES

			cep->rwbufq_entries --;

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES */

			next = qhdr->next;
			syscall(rel_net_buf(cep->rwbufq));
			cep->rwbufq = next;
		}
		else {
			qhdr->slen -= len;
			qhdr->soff += len;
		}
	}
}

/*
 *  tcp_read_rwbuf -- MEBhobt@w肳ꂽINebgǂݏoB
 */

uint_t
tcp_read_rwbuf_cs (T_TCP_CEP *cep, void *data, uint_t len)
{
	T_TCP_Q_HDR	*qhdr;
	uint_t		blen, rlen = 0;
	uint8_t		*buf = (uint8_t*)data;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	/*
	 *  MEBhobt@L[Ƀlbg[Nobt@Ȃ邩
	 *  len  0 ɂȂ܂őB
	 */
	while (cep->rwbufq != NULL && len > 0) {
		qhdr = GET_TCP_Q_HDR(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff);

		/*
		 *  len ƎMEBhobt@L[̐擪lbg[Nobt@
		 *  f[^̏ڂf[^ɂB
		 */
		if (len > qhdr->slen)
			blen = qhdr->slen;
		else
			blen = len;

		memcpy(buf,
		       GET_TCP_SDU(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff) + qhdr->soff,
		       (size_t)blen);

		/*
		 *  MEBhobt@L[̃lbg[Nobt@
		 *  f[^ȂB
		 */
		tcp_drop_rwbuf_cs(cep, blen);

		buf  += blen;
		rlen += blen;
		len  -= blen;
	}

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	return rlen;
}

/*
 *  tcp_get_rwbuf_addr -- MEBhobt@̋󂫃AhXlB
 */

uint_t
tcp_get_rwbuf_addr_cs (T_TCP_CEP *cep, void **p_buf)
{
	T_TCP_Q_HDR	*qhdr;
	uint_t		len;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	if (cep->rwbufq == NULL) {

		/* MEBhobt@SĊJĂƂB*/
		*p_buf = NULL;
		len = 0;
	}
	else {

		/* MEBhobt@̃f[^̃AhX̐擪ݒ肷B*/
		qhdr = GET_TCP_Q_HDR(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff);
		*p_buf = GET_TCP_SDU(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff) + qhdr->soff;

		/* MEBhobt@̃f[^vZB*/
		len = qhdr->slen;
	}

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

	/* MEBhobt@̃f[^ݒ肵A̒lԂB*/
	cep->rcv_buf_len = len;
	return len;
}

/*
 *  tcp_free_rwbufq -- MEBhobt@L[B
 *
 *    :
 *      Kvł΁Å֐ĂяoOɁAʐM[_bNA
 *      ߂AKvB
 */

void
tcp_free_rwbufq_cs (T_TCP_CEP *cep)
{
	T_NET_BUF *next;

	if (cep->rwbuf_count == 0 && cep->reassq == NULL) {
		while (cep->rwbufq != NULL) {
			next = GET_TCP_Q_HDR(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff)->next;

#ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES

			cep->rwbufq_entries --;

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES */

			syscall(rel_net_buf(cep->rwbufq));
			cep->rwbufq = next;
		}

		/* MEBhobt@̎gpTCYZbgB*/
		cep->rwbuf_count = 0;
	}
}

/*
 *  tcp_write_rwbuf -- MEBhobt@Ƀf[^ށB
 *
 *    :
 *	 input ́AT_TCP_Q_HDR ɂ胊NA
 *	בւIĂȂ΂ȂȂB܂A
 *	ǉf[^́AMEBhobt@Ɏ܂邱ƁB
 */

void
tcp_write_rwbuf_cs (T_TCP_CEP *cep, T_NET_BUF *input, uint_t thoff)
{
	T_TCP_Q_HDR	*qhdr;
	T_NET_BUF	**nextp;
	uint_t		inlen, last;

	/* ʐM[_bNB*/
	syscall(wai_sem(cep->semid_lock));

	qhdr  = (T_TCP_Q_HDR*)GET_TCP_HDR(input, thoff);

	inlen = qhdr->slen;

#ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES

	if (cep->rwbufq_entries >= TCP_CFG_RWBUF_CSAVE_MAX_QUEUES &&
	    inlen > 0 && (qhdr->flags & TCP_FLG_FIN) == 0) {

		/*
		 *  TCP ʐM[_̎MEBhobt@̏ȃRs[@\́A
		 *  MEBhobt@L[̍őGg𒴂Ƃ́A
		 *  MZOgjB
		 *  ASDU  0 ̃ZOg FIN ZOg͔jȂB
		 *  ȂAɎMZOgj邽߁Ađ񐔂B
		 */
		syscall(rel_net_buf(input));

		/* ʐM[_̃bNB*/
		syscall(sig_sem(cep->semid_lock));
		return;
	}

	cep->rwbufq_entries ++;

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE_MAX_QUEUES */

	qhdr  = (T_TCP_Q_HDR*)GET_TCP_HDR(input, thoff);

	/* Mς݃V[PXԍXVB*/
	cep->rcv_nxt += inlen;

	/* ً}f[^ SDU ␳sB*/
	if (qhdr->urp > 0 && inlen > 0) {
		inlen      -= qhdr->urp;
		qhdr->slen -= qhdr->urp;
		qhdr->urp   = 0;
	}

	last  = cep->rwbuf_count;

	/* lbg[Nobt@MEBhobt@L[̍ŌɘAB*/
	qhdr->next = NULL;
	nextp = &cep->rwbufq;
	while (*nextp)
		nextp = &GET_TCP_Q_HDR(*nextp, GET_TCP_IP_Q_HDR(*nextp)->thoff)->next;
	*nextp = input;

	/*
	 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
	 *  ́AAvP[VɁA肩炱ȏf[^
	 *  ȂƂm点邽߂łB
	 */
	if (inlen > 0) {
		cep->rwbuf_count += inlen;
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DATA_SEGS],   1);
		NET_COUNT_TCP(net_count_tcp[NC_TCP_RECV_DATA_OCTETS], inlen);
	}

	/* ʐM[_̃bNB*/
	syscall(sig_sem(cep->semid_lock));

#ifdef TCP_CFG_NON_BLOCKING

	if (cep->rcv_nblk_tfn == TFN_TCP_RCV_BUF) {	/* mubLOR[ */

		int_t	len;

		qhdr = GET_TCP_Q_HDR(cep->rwbufq, GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff);
		len = qhdr->slen;

		/*
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if (len > 0 || inlen == 0) {

			/* tcp_rcv_buf ̊Ēݒ肷B*/
			cep->rcv_buf_len = len;

			/* MEBhobt@̃AhXԂB*/
			*cep->rcv_p_buf = GET_TCP_SDU(cep->rwbufq,
			                  GET_TCP_IP_Q_HDR(cep->rwbufq)->thoff) + qhdr->soff;

			if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			else
				syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

			if (len == 0) {

				/*
				 *  ʐM[_bNāA
				 *  MEBhobt@L[̃lbg[Nobt@B
				 */
				syscall(wai_sem(cep->semid_lock));
				tcp_free_rwbufq_cs(cep);
				syscall(sig_sem(cep->semid_lock));
			}
		}

		/* LĂ^XN ID  API @\R[hNA[B*/
		cep->rcv_tskid = TA_NULL;
		cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;
	}

	else if (cep->rcv_nblk_tfn == TFN_TCP_RCV_DAT) {	/* mubLOR[ */
		int_t	len;

		/* MEBhobt@f[^oB*/
		if ((len = tcp_read_rwbuf_cs(cep, cep->rcv_data, (uint_t)cep->rcv_len)) > 0) {
			/* ɃEBhETCYςƂm点邽ߏo͂|XgB*/
			cep->flags |= TCP_CEP_FLG_POST_OUTPUT;
			sig_sem(SEM_TCP_POST_OUTPUT);
		}

		/*
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if (len > 0 || inlen == 0) {

			if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				(*cep->callback)(GET_TCP_CEPID(cep), cep->rcv_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

			else
				syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));
		}

		/* LĂ^XN ID  API @\R[hNA[B*/
		cep->rcv_tskid = TA_NULL;
		cep->rcv_tfn   = cep->rcv_nblk_tfn = TFN_TCP_UNDEF;
	}
	else {

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

		if (inlen == 0 && cep->rwbuf_count == 0) {
			/*
			 *  MEBhobt@̃f[^ 0 ŁA
			 *  肩 FIN tOtZOgMƂ́A
			 *  ʐM[_bNāA
			 *  MEBhobt@L[̃lbg[Nobt@B
			 */
			syscall(wai_sem(cep->semid_lock));
			tcp_free_rwbufq_cs(cep);
			syscall(sig_sem(cep->semid_lock));
		}

		/*
		 *  MEBhobt@Ƀf[^邩A inlen == 0 ̎A̓^XNNB
		 *  FIN tOtZOg inlen == 0 ɂȂ邱ƂB
		 *  ́AAvP[VɁA肩炱ȏf[^
		 *  ȂƂm点邽߂łB
		 */
		if ((last == 0 && cep->rwbuf_count > 0) || inlen == 0) {
			syscall(set_flg(cep->rcv_flgid, TCP_CEP_EVT_RWBUF_READY));
		}

#ifdef TCP_CFG_NON_BLOCKING

	}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

}

#endif	/* of #ifdef TCP_CFG_RWBUF_CSAVE */

#endif	/* of #ifdef SUPPORT_TCP */
