/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: nd6_nbr.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/nd6_nbr.c,v 1.13 2002/10/16 01:54:45 sam Exp $	*/
/*	$KAME: nd6_nbr.c,v 1.86 2002/01/21 02:33:04 jinmei Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>

#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>

#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <netinet6/ip6_var.h>

#include <net/if6_var.h>

#ifdef SUPPORT_INET6

/*
 *  Ǐ֐
 */

static void nd6_dad_timer (T_IN6_IFADDR *ifa);
static void nd6_dad_duplicated (T_IFNET *ifp, T_IN6_IFADDR *ifa);
static void nd6_dad_ns_output (T_IFNET *ifp, T_IN6_IFADDR *ifa);
static void nd6_dad_ns_input (T_IFNET *ifp, T_IN6_IFADDR *ifa);
static void nd6_dad_na_input (T_IFNET *ifp, T_IN6_IFADDR *ifa);

/*
 *  nd6_dad_duplicated -- dAhXȍ
 */

static void
nd6_dad_duplicated (T_IFNET *ifp, T_IN6_IFADDR *ifa)
{
	if ((ifa->flags & IN6_IFF_TENTATIVE) == 0)
		syslog(LOG_ERROR, "[ND6 DAD DUP] no pending.");
	else {
		syslog(LOG_ERROR, "[ND6 DAD DUP] dup IPv6 addr: %s.", ipv62str(NULL, &ifa->addr));
		ifa->flags &= ~IN6_IFF_TENTATIVE;
		ifa->flags |=  IN6_IFF_DUPLICATED;

		/* ^C}[~B*/
		untimeout((callout_func)nd6_dad_timer, ifa);

		/*
		 *   IPv6 AhXAj[NɊ蓖Ă炽
		 * iC[Tlbgp EUI-64jn[hEFAAhXx[XƂ
		 *  C^tF[X ID Őꂽ̂ł΁A
		 *  ̃C^tF[Xł IPv6 ͖̓ɂׂł
		 * iRFC2462bis-03 ZNV 5.4.5jB
		 */
		if (IN6_IS_ADDR_LINKLOCAL(&ifa->addr))
			ifp->flags |= ND6_IFF_IFDISABLED;
	}
}

/*
 *  nd6_dad_ns_output -- dAhXo (DAD) vo͂B
 */

static void
nd6_dad_ns_output (T_IFNET *ifp, T_IN6_IFADDR *ifa)
{
	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_DAD_OUT_PACKETS], 1);

	ifa->ns_ocount ++;
	nd6_ns_output(ifp, &in6_addr_unspecified, &ifa->addr, NULL, true);
}

/*
 *  nd6_dad_ns_input -- dAhXo (DAD) v
 */

static void
nd6_dad_ns_input (T_IFNET *ifp, T_IN6_IFADDR *ifa)
{
	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NS_IN_PACKETS], 1);

	/*
	 *  ܂AdAhXovo͂ĂȂꍇ
	 */
	if (ifa->ns_ocount == 0)
		nd6_dad_duplicated(ifp, ifa);
	else
		ifa->ns_icount ++;
}

/*
 *  nd6_dad_na_input -- dAhXo (DAD) ʒm
 */

static void
nd6_dad_na_input (T_IFNET *ifp, T_IN6_IFADDR *ifa)
{
	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NA_IN_PACKETS], 1);
	ifa->na_icount ++;
	nd6_dad_duplicated(ifp, ifa);
}

/*
 *  nd6_dad_timer -- dAhXo (DAD) ^C}[
 */

static void
nd6_dad_timer (T_IN6_IFADDR *ifa)
{
	T_IFNET *ifp = IF_GET_IFNET();

	if (ifa->flags & IN6_IFF_DUPLICATED) {
		syslog(LOG_ERROR, "[ND6 DAD] dup IPv6 addr: %s.", ipv62str(NULL, &ifa->addr));
		return;
	}

	if ((ifa->flags & IN6_IFF_TENTATIVE) == 0) {
		syslog(LOG_ERROR, "[ND6 DAD] no tentative IPv6 addr: %s.", ipv62str(NULL, &ifa->addr));
		return;
	}

	if (ifa->ns_ocount < NUM_IP6_DAD_COUNT) {
		nd6_dad_ns_output(ifp, ifa);

		/* ^CAEgߗגT̑MԊuɐݒ肷B*/
		timeout((callout_func)nd6_dad_timer, ifa, ND6_RETRANS_TIME * NET_TIMER_HZ / SYSTIM_HZ);
	}
	else if (ifa->na_icount || ifa->ns_icount)
		nd6_dad_duplicated(ifp, ifa);
	else {
		ifa->flags &= ~IN6_IFF_TENTATIVE;
		syslog(LOG_NOTICE, "[ND6 DAD] no dup IPv6 addr: %s.", ipv62str(NULL, &ifa->addr));
	}
}

/*
 *  nd6_ns_input -- ߗחv̓͏B
 */

void
nd6_ns_input (T_NET_BUF *input, uint_t off)
{
	T_IFNET			*ifp = IF_GET_IFNET();
	T_IP6_HDR		*ip6h;
	T_NEIGHBOR_SOLICIT_HDR	*nsh;
	T_ND_OPT_HDR		*opth;
	T_IN6_IFADDR		*ifa;
	bool_t			tlladdr;
	uint_t			lladdr_len = 0;
	uint32_t		flags;
	uint8_t			*lladdr = NULL;
	uint8_t			nd_opt_off[ND_OPT_OFF_ARRAY_SIZE];

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NS_IN_PACKETS], 1);

	ip6h = GET_IP6_HDR(input);

	/*
	 *  wb_̃`FbNAȉ̏ꍇ͔jB
	 *    Ezbv~bg IPV6_MAXHLIM (255) ȊO
	 *    Ewb_Z
	 */
	if (ip6h->hlim != IPV6_MAXHLIM || input->len - off < NEIGHBOR_SOLICIT_HDR_SIZE)
		goto err_ret;

	nsh  = (T_NEIGHBOR_SOLICIT_HDR *)(input->buf + off);

	if (IN6_IS_ADDR_UNSPECIFIED(&ip6h->src)) {
		/*
		 *  n_AhXwȂAdAhXo
		 *  ĐAhX́Av}`LXgłȂ΂ȂȂB
		 */
		if (!IN6_IS_ADDR_NS_MULTICAST(&ip6h->dst))
			goto err_ret;
	}

	/* ړIAhX}`LXgȂG[ */
	if (IN6_IS_ADDR_MULTICAST(&nsh->target))
		goto err_ret;

	/* ߗגTIvṼItZbgL^B*/
	if (nd6_options(nd_opt_off, input->buf + (off + NEIGHBOR_SOLICIT_HDR_SIZE),
	                            input->len - (off + NEIGHBOR_SOLICIT_HDR_SIZE)) != E_OK)
		goto err_ret;

	/* ߗגTIvV (n_NAhX) */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_SOURCE_LINKADDR)]) {
		opth = (T_ND_OPT_HDR *)((uint8_t *)(input->buf + off + NEIGHBOR_SOLICIT_HDR_SIZE) +
		                        nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_SOURCE_LINKADDR)] - 8);
	 	/* : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB*/
		lladdr     = (uint8_t *)(opth + 1);
		lladdr_len = (opth->len << 3);
	}

	if (IN6_IS_ADDR_UNSPECIFIED(&ip6h->src) && lladdr != NULL)
		goto err_ret;

	/* AhX}`LXgȂߗגʒmɃf[^Nw̃AhXtB*/
	if (IN6_IS_ADDR_MULTICAST(&ip6h->dst))
		tlladdr = true;
	else
		tlladdr = false;

	/*
	 *  ړIAhXÃlbg[NC^tF[X
	 *  蓖ĂĂAhXׂB
	 *  ȂA㗝T[rX͎ĂȂB
	 */
	ifa = in6_lookup_ifaddr(ifp, &nsh->target);

	if (ifa == NULL)
		goto free_ret;

	/* TʃAhXdĂΉȂŏIB*/
	if (ifa->flags & IN6_IFF_DUPLICATED)
		goto err_ret;

	/*
	 *  lbg[NC^tF[X̃AhXvȂ΃G[
	 */
	if (lladdr && lladdr_len != ((sizeof(T_IF_ADDR) + sizeof(T_ND_OPT_HDR) + 7) & ~7))
		goto err_ret;

	/*
	 *  n_AhX̃AhXƈvΏdĂB
	 */
	if (IN6_ARE_ADDR_EQUAL(&ifa->addr, &ip6h->src))
		goto free_ret;

	/* doɁAߗחvMƂ̏ */
	if (ifa->flags & IN6_IFF_TENTATIVE) {
		if (IN6_IS_ADDR_UNSPECIFIED(&ip6h->src))
			nd6_dad_ns_input(ifp, ifa);
		goto free_ret;
	}

	if ((ifa->flags & IN6_IFF_ANYCAST) || !tlladdr)
		flags = 0;
	else
		flags = ND_NA_FLG_OVERRIDE;

	/*
	 *  n_AhXwȂAM͏dAhXoŁA
	 *  ڑM邱Ƃ͂łȂ̂ŁASm[h}`LXg
	 *  AhXɑMB
	 */
	if (IN6_IS_ADDR_UNSPECIFIED(&ip6h->src)) {
		nd6_na_output(ifp, &in6_addr_linklocal_allnodes, &nsh->target, flags, tlladdr);
		goto free_ret;
	}

	/* ߗ׃LbVɓo^B*/
	nd6_cache_lladdr(ifp, &ip6h->src, (T_IF_ADDR *)lladdr, ND_NEIGHBOR_SOLICIT, 0);

	nd6_na_output(ifp, &ip6h->src, &nsh->target, flags | ND_NA_FLG_SOLICITED, tlladdr);

free_ret:
	syscall(rel_net_buf(input));
	return;

err_ret:
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_IN_ERR_PACKETS], 1);
	syscall(rel_net_buf(input));
}

/*
 *  nd6_ns_output -- ߗחvo͂B
 */

void
nd6_ns_output (T_IFNET *ifp, T_IN6_ADDR *daddr,
               T_IN6_ADDR *taddr, T_LLINFO_ND6 *ln, bool_t dad)
{
	T_NEIGHBOR_SOLICIT_HDR	*nsh;
	T_NET_BUF		*output;
	T_IP6_HDR		*ip6h;
	T_IF_ADDR		*mac = NULL;
	uint_t			len;
	uint16_t		ipflags = 0;

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NS_OUT_PACKETS], 1);

	if (IN6_IS_ADDR_MULTICAST(taddr))
		return;

	/* ߗחvyC[hvZB*/
	if (!dad && IF_SOFTC_TO_IFADDR(ifp->ic))
		len = (NEIGHBOR_SOLICIT_HDR_SIZE + ND_OPT_HDR_SIZE + sizeof(T_IF_ADDR) + 7) >> 3 << 3;
	else
		len = (NEIGHBOR_SOLICIT_HDR_SIZE + 7) >> 3 << 3;

	/*
	 *  v}`LXgEAhX̋ߗגTł́A
	 *  ̃N̋Uꂽf[^O
	 *  r邽߁Azbv~bg IPV6_MAXHLIM (255) ݒ肷B
	 */
	if (IN6_IS_ADDR_UNSPECIFIED(daddr) || IN6_IS_ADDR_MULTICAST(daddr))
		ipflags = IPV6_OUT_SET_HOP_LIMIT(IPV6_OUT_FLG_HOP_LIMIT, IPV6_MAXHLIM);

	/* lbg[Nobt@lAIPv6 wb_ݒ肷B*/
	if (in6_get_datagram(&output, len, 0, daddr, NULL,
	                     IPPROTO_ICMPV6, IPV6_MAXHLIM,
	                     NBA_SEARCH_ASCENT, TMO_ND6_NS_OUTPUT) != E_OK)
		return;

	ip6h = GET_IP6_HDR(output);

	if (IN6_IS_ADDR_UNSPECIFIED(daddr)) {

		/* AhXw̏ꍇ́Av}`LXgAhXݒ肷B*/
		ip6h->dst.s6_addr32[0] = IPV6_ADDR_INT32_MLL;
		ip6h->dst.s6_addr32[2] = IPV6_ADDR_INT32_ONE;
		ip6h->dst.s6_addr32[3] = taddr->s6_addr32[3];
		ip6h->dst.s6_addr8[12] = 0xff;
	}

	/* MAhX̐ݒ */
	if (!dad) {

		/* dAhXoł͂Ȃ̑MAhX菈B*/
		T_IN6_ADDR *saddr;

		if (ln && ln->hold) {
			/*
			 * MyfBOĂf[^O
			 * MAhX𗘗pB
			 */
			if (ln->hold->len > IF_IP6_HDR_SIZE)
				saddr = &GET_IP6_HDR(ln->hold)->src;
			else
				saddr = NULL;
		}
		else
			saddr = NULL;

		if (saddr && in6_lookup_ifaddr(ifp, saddr))
			ip6h->src = *saddr;
		else {
			/*
			 *  AhXɂӂ킵MAhXA
			 *  lbg[NC^tF[XTėpB
			 */
			T_IN6_IFADDR *ifa;

			if ((ifa = in6_ifawithifp(ifp, &ip6h->dst)) == NULL) {
				syscall(rel_net_buf(output));
				return;
			}
			ip6h->src = ifa->addr;
		}
	}
	else {

		/* dAhXȏMAhX͖wB*/
		memset(&ip6h->src, 0, sizeof(T_IN6_ADDR));
	}

 	/* ߗחvwb_ݒ肷B*/
 	nsh = GET_NEIGHBOR_SOLICIT_HDR(output, IF_IP6_NEIGHBOR_SOLICIT_HDR_OFFSET);
 	nsh->hdr.type        = ND_NEIGHBOR_SOLICIT;
 	nsh->hdr.code        = 0;
 	nsh->hdr.data.data32 = 0;
 	nsh->target          = *taddr;

	if (!dad && (mac = IF_SOFTC_TO_IFADDR(ifp->ic)) != NULL) {

		/* ߗגTIvVƂāATڕW MAC AhXݒ肷B*/
		T_ND_OPT_HDR	*opth;
		uint_t		optlen;

		opth   = (T_ND_OPT_HDR *)GET_NEIGHBOR_SOLICIT_SDU(output, IF_IP6_NEIGHBOR_SOLICIT_HDR_OFFSET);
		optlen = (ND_OPT_HDR_SIZE + sizeof(T_IF_ADDR) + 7) >> 3 << 3;
		memset(opth, 0, optlen);
		opth->type = ND_OPT_SOURCE_LINKADDR;
		opth->len  = optlen >> 3;
		memcpy((uint8_t *)opth + sizeof(T_ND_OPT_HDR), mac, sizeof(T_IF_ADDR));
	}

	/* `FbNTvZB*/
	nsh->hdr.sum = 0;
	nsh->hdr.sum = in6_cksum(output, IPPROTO_ICMPV6, (uint8_t*)nsh - output->buf, len);

	/* MB*/
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_OCTETS],
	               output->len - GET_IF_IP6_HDR_SIZE(output));
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutMsgs, 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutNeighborSolicits, 1);
	ip6_output(output, ipflags | IPV6_OUT_FLG_DAD, TMO_ND6_NS_OUTPUT);
}

/*
 *  nd6_na_input -- ߗגʒm̓͏B
 */

void
nd6_na_input (T_NET_BUF *input, uint_t off)
{
	T_IFNET			*ifp = IF_GET_IFNET();
	T_IP6_HDR		*ip6h;
	T_NEIGHBOR_ADVERT_HDR	*nah;
	T_ND_OPT_HDR		*opth;
	T_IN6_IFADDR		*ifa;
	T_LLINFO_ND6		*ln;
	SYSTIM			now;
	bool_t			llchange;
	uint_t			lladdr_len = 0;
	uint8_t			*lladdr = NULL;
	uint8_t			nd_opt_off[ND_OPT_OFF_ARRAY_SIZE];

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NS_IN_PACKETS], 1);

	ip6h = GET_IP6_HDR(input);

	/*
	 *  wb_̃`FbNAȉ̏ꍇ͔jB
	 *    Ezbv~bg IPV6_MAXHLIM (255) ȊO
	 *    Ewb_Z
	 */
	if (ip6h->hlim != IPV6_MAXHLIM || input->len - off < NEIGHBOR_ADVERT_HDR_SIZE)
		goto err_ret;

	nah  = (T_NEIGHBOR_ADVERT_HDR *)(input->buf + off);

	/* ړIAhX}`LXgȂG[ */
	if (IN6_IS_ADDR_MULTICAST(&nah->target))
		goto err_ret;

	/* ߗחvւ̉ŁAAhX}`LXgȂG[ */
	if ((nah->nd_na_flags_reserved & ND_NA_FLG_SOLICITED) &&
	    IN6_IS_ADDR_MULTICAST(&ip6h->dst))
		goto err_ret;

	/* ߗגTIvṼItZbgL^B*/
	if (nd6_options(nd_opt_off, input->buf + (off + NEIGHBOR_ADVERT_HDR_SIZE), 
	                            input->len - (off + NEIGHBOR_ADVERT_HDR_SIZE)) != E_OK)
		goto err_ret;

	/* ߗגTIvV (ړINAhX) */
	if (nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_TARGET_LINKADDR)]) {
		opth = (T_ND_OPT_HDR *)((uint8_t *)(input->buf + off + NEIGHBOR_ADVERT_HDR_SIZE) +
		                        nd_opt_off[ND_OPT_OFF_ARRAY_IX(ND_OPT_TARGET_LINKADDR)] - 8);
	 	/* : IvVItZbgzɂ́AItZbg + 8 ݒ肳ĂB*/
		lladdr     = (uint8_t *)(opth + 1);
		lladdr_len = (opth->len << 3);
	}

	ifa = in6_lookup_ifaddr(ifp, &nah->target);

	/*
	 *  ړIAhX̃lbg[NC^tF[XɊ蓖ĂĂAhX
	 *  ꂩɈvƂ́AdĂ邱ƂӖĂB
	 */
	if (ifa) {
		if (ifa->flags & IN6_IFF_TENTATIVE)
			nd6_dad_na_input(ifp, ifa);
		else
			syslog(LOG_ERROR, "[ND6 NA INPUT] dup IPv6 addr: %s.", ipv62str(NULL, &ifa->addr));
		goto err_ret;
	}

	/*
	 *  lbg[NC^tF[X̃AhXvȂ΃G[
	 */
	if (lladdr && lladdr_len != ((sizeof(T_IF_ADDR) + sizeof(T_ND_OPT_HDR) + 7) & ~7))
		goto err_ret;

	/* ߗ׃LbVTB*/
	syscall(wai_sem(SEM_ND6_CACHE));
	if ((ln = nd6_lookup(&nah->target, false)) == NULL)
		goto free_ret;

	/* ߗ׃LbV̏ԂAf[^Nw̃AhX̏ꍇ */
	if (ln->state == ND6_LLINFO_INCOMPLETE) {
		/* ʒmꂽf[^Nw̃AhX̒ 0 ̏ꍇ */
		if (lladdr == NULL)
			goto free_ret;

		ln->ifaddr = *(T_IF_ADDR *)lladdr;
		if (nah->nd_na_flags_reserved & ND_NA_FLG_SOLICITED) {
			ln->state = ND6_LLINFO_REACHABLE;
			/*ln->byhint = 0*/;
			if (ln->expire) {
				syscall(get_tim(&now));
				ln->expire = now + ND6_REACHABLE_TIME;
			}
		}
		else {
			syscall(get_tim(&now));
			ln->expire = now + ND6_GCOLLECTION_TIME;
			ln->state  = ND6_LLINFO_STALE;
		}

		if ((nah->nd_na_flags_reserved & ND_NA_FLG_ROUTER) != 0)
			ln->flags |=  ND6_LLIF_ROUTER;
		else
			ln->flags &= ~ND6_LLIF_ROUTER;
		if ((ln->flags & ND6_LLIF_ROUTER) != 0)
			/*pfxlist_onlink_check()*/;
	}
	else {
		if (lladdr == NULL)
			llchange = false;
		else if (memcmp(lladdr, &ln->ifaddr, sizeof(T_IF_ADDR)))
			llchange = true;
		else
			llchange = false;

		/*
		 *  ԑJڕ\
		 *
		 *  nd_na_flags_reserved
		 *  OVERRIDE    SOLICTED lladdr llchange  (L: lladdr o^)
		 *
		 *      F           F       N      -    (2c)
		 *      F           F       Y      F    (2b) L
		 *      F           F       Y      T    (1)    REACHABLE -> STALE
		 *      F           T       N      -    (2c)           * -> REACHABLE
		 *      F           T       Y      F    (2b) L         * -> REACHABLE
		 *      F           T       Y      T    (1)    REACHABLE -> STALE
		 *      T           F       N      -    (2a)
		 *      T           F       Y      F    (2a) L
		 *      T           F       Y      T    (2a) L         *-> STALE
		 *      T           T       N      -    (2a)           * -> REACHABLE
		 *      T           T       Y      F    (2a) L         * -> REACHABLE
		 *      T           T       Y      T    (2a) L         * -> REACHABLE
		 */
		if ((nah->nd_na_flags_reserved & ND_NA_FLG_OVERRIDE) == 0 && (lladdr != NULL && llchange)) {	/* (1) */
			/* Ԃ REACHABLE Ȃ STALE ɑJڂB*/
			if (ln->state == ND6_LLINFO_REACHABLE) {
				syscall(get_tim(&now));
				ln->expire = now + ND6_GCOLLECTION_TIME;
				ln->state  = ND6_LLINFO_STALE;
			}
			goto free_ret;
		}
		else if ((nah->nd_na_flags_reserved & ND_NA_FLG_OVERRIDE) ||						/* (2a) */
		         ((nah->nd_na_flags_reserved & ND_NA_FLG_OVERRIDE) == 0 && (lladdr != NULL && !llchange)) ||	/* (2b) */
		         lladdr == NULL) {										/* (2c) */

			/* f[^Nw̃AhXʒmĂ΍XVB*/
			if (lladdr != NULL)
				ln->ifaddr = *(T_IF_ADDR *)lladdr;

			/* ߗחvւ̉Ȃ REACHABLE ɑJڂB*/
			if (nah->nd_na_flags_reserved & ND_NA_FLG_SOLICITED) {
				ln->state = ND6_LLINFO_REACHABLE;
				/*ln->byhint = 0*/;
				if (ln->expire) {
					syscall(get_tim(&now));
					ln->expire = now + ND6_REACHABLE_TIME;
				}
			}
			/*
			 *  f[^Nw̃AhXʒmA
			 *  قȂAhXȂXVB
			 */
			else if (lladdr != NULL && llchange) {
				syscall(get_tim(&now));
				ln->expire = now + ND6_GCOLLECTION_TIME;
				ln->state  = ND6_LLINFO_STALE;
			}
		}

		/* [^ʒmtȌ */
		if ((ln->flags        & ND6_LLIF_ROUTER ) != 0 &&
		    (nah->nd_na_flags_reserved & ND_NA_FLG_ROUTER) == 0) {
			/*
			 *  M肪[^ʒmtO𖳌ɂꍇB
			 *  fBtHgE[^XgΏۂ̃[^폜A
			 *  ߗגTLbVXVB
			 */
			T_DEF_ROUTER	*dr = NULL;

			syscall(wai_sem(SEM_ND6_DEFRTRLIST));
			if ((dr = nd6_defrtrlist_lookup(&ln->addr)) != NULL) {
				nd6_defrtrlist_del(dr);
			}
			syscall(sig_sem(SEM_ND6_DEFRTRLIST));
		}
		if ((nah->nd_na_flags_reserved & ND_NA_FLG_ROUTER) != 0)
			ln->flags |=  ND6_LLIF_ROUTER;
		else
			ln->flags &= ~ND6_LLIF_ROUTER;
	}

	ln->asked = 0;

	/* AhX҂̃f[^OΑMB*/
	nd6_output_hold(ifp, ln);

free_ret:
	syscall(sig_sem(SEM_ND6_CACHE));
	syscall(rel_net_buf(input));
	return;

err_ret:
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_IN_ERR_PACKETS], 1);
	syscall(rel_net_buf(input));
}

/*
 *  nd6_na_output -- ߗגʒmo͂B
 */

void
nd6_na_output (T_IFNET *ifp, T_IN6_ADDR *daddr,
               T_IN6_ADDR *taddr, uint32_t flags, bool_t tlladdr)
{
	T_NEIGHBOR_ADVERT_HDR	*nah;
	T_NET_BUF		*output;
	T_IP6_HDR		*ip6h;
	T_IN6_IFADDR		*ifa;
	T_IF_ADDR		*mac = NULL;
	uint_t			len;
	uint16_t		ipflags = 0;

	NET_COUNT_ICMP6(net_count_nd6[NC_ND6_NA_OUT_PACKETS], 1);

	/*
	 *  ߗגʒmyC[hvZB
	 *  tlladdr ^Ȃlbg[NC^tF[X̃AhXǉB
	 */
	if (tlladdr && IF_SOFTC_TO_IFADDR(ifp->ic))
		len = (NEIGHBOR_ADVERT_HDR_SIZE + ND_OPT_HDR_SIZE + sizeof(T_IF_ADDR) + 7) >> 3 << 3;
	else
		len = (NEIGHBOR_ADVERT_HDR_SIZE + 7) >> 3 << 3;

	/*
	 *  ̃N̋Uꂽf[^O
	 *  r邽߁Azbv~bg IPV6_MAXHLIM (255) ݒ肷B
	 */
	ipflags = IPV6_OUT_SET_HOP_LIMIT(IPV6_OUT_FLG_HOP_LIMIT, IPV6_MAXHLIM);

	/* lbg[Nobt@lAIPv6 wb_ݒ肷B*/
	if (in6_get_datagram(&output, len, 0, daddr, NULL,
	                     IPPROTO_ICMPV6, IPV6_MAXHLIM,
	                     NBA_SEARCH_ASCENT, TMO_ND6_NA_OUTPUT) != E_OK)
		return;

	ip6h = GET_IP6_HDR(output);

	if (IN6_IS_ADDR_UNSPECIFIED(daddr)) {
		/*
		 *  AhXw̏ꍇ́A
		 *  N[JSm[hE}`LXgAhXݒ肷B
		 */
		ip6h->dst.s6_addr32[0] = IPV6_ADDR_INT32_MLL;
		ip6h->dst.s6_addr32[1] = 0;
		ip6h->dst.s6_addr32[2] = 0;
		ip6h->dst.s6_addr32[3] = IPV6_ADDR_INT32_ONE;
		flags &= ~ND_NA_FLG_SOLICITED;
	}
	else
		ip6h->dst = *daddr;

	/*
	 *  AhXɂӂ킵MAhXA
	 *  lbg[NC^tF[XTėpB
	 */
	if ((ifa = in6_ifawithifp(ifp, &ip6h->dst)) == NULL) {
		syscall(rel_net_buf(output));
		return;
	}
	ip6h->src = ifa->addr;

 	/* ߗגʒmwb_ݒ肷B*/
 	nah = GET_NEIGHBOR_ADVERT_HDR(output, IF_IP6_NEIGHBOR_ADVERT_HDR_OFFSET);
 	nah->hdr.type        = ND_NEIGHBOR_ADVERT;
 	nah->hdr.code        = 0;
 	nah->target          = *taddr;

	/* tlladdr ^Ȃlbg[NC^tF[X̃AhXǉB*/
	if (tlladdr && (mac = IF_SOFTC_TO_IFADDR(ifp->ic)) != NULL) {

		T_ND_OPT_HDR	*opth;
		uint_t		optlen;

		opth   = (T_ND_OPT_HDR *)GET_NEIGHBOR_ADVERT_SDU(output, IF_IP6_NEIGHBOR_ADVERT_HDR_OFFSET);
		optlen = (ND_OPT_HDR_SIZE + sizeof(T_IF_ADDR) + 7) >> 3 << 3;
		memset(opth, 0, optlen);
		opth->type = ND_OPT_TARGET_LINKADDR;
		opth->len  = optlen >> 3;
		memcpy((uint8_t *)opth + sizeof(T_ND_OPT_HDR), mac, sizeof(T_IF_ADDR));
	}
	else
		flags &= ~ND_NA_FLG_OVERRIDE;

	nah->nd_na_flags_reserved = flags;

	/* `FbNTvZB*/
	nah->hdr.sum = 0;
	nah->hdr.sum = in6_cksum(output, IPPROTO_ICMPV6, (uint8_t*)nah - output->buf, len);

	/* MB*/
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_OCTETS],
	               output->len - GET_IF_IP6_HDR_SIZE(output));
	NET_COUNT_ICMP6(net_count_nd6[NC_ICMP6_OUT_PACKETS], 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutMsgs, 1);
	NET_COUNT_MIB(icmp6_ifstat.ipv6IfIcmpOutNeighborAdvertisements, 1);
	ip6_output(output, ipflags, TMO_ND6_NS_OUTPUT);
}

/*
 *  nd6_dad_start -- dAhXo (DAD) JnB
 *
 *    3tick ́AC^tF[XNĂAdo
 *    M܂ł̍ŏxlłB
 */

void
nd6_dad_start (T_IFNET *ifp, T_IN6_IFADDR *ifa, int_t *tick)
{
	/* tO`FbNB*/
	if (!(ifa->flags & IN6_IFF_TENTATIVE))
		return;

#if NUM_IP6_DAD_COUNT == 0

	ifa->flags &= ~IN6_IFF_TENTATIVE;

#else	/* of #if NUM_IP6_DAD_COUNT == 0 */

	if (ifa->flags & IN6_IFF_ANYCAST) {
		ifa->flags &= ~IN6_IFF_TENTATIVE;
		return;
	}
	else if ((ifa->flags & IN6_IFF_TENTATIVE) == 0)
		return;

	/* dAhXoJE^ZbgB*/
	ifa->ns_icount = ifa->na_icount = ifa->ns_ocount = 0;

	/*
	 *  dAhXov𑗐MBAC^tF[X
	 *  ɁAŏɑMꍇ́A_ȒxsB
	 */
	if (tick == NULL) {
		nd6_dad_ns_output(ifp, ifa);

		/* ^CAEgߗגT̑MԊuɐݒ肷B*/
		timeout((callout_func)nd6_dad_timer, ifa, ND6_RETRANS_TIME * NET_TIMER_HZ / SYSTIM_HZ);
	}
	else {
		int_t ntick;

		if (*tick == 0)	/* ŏ̑M */
			ntick = net_rand() % (ND6_FIRST_DAD_DELAY_TIME * NET_TIMER_HZ / SYSTIM_HZ);
		else
			ntick = *tick + net_rand() % (ND6_DAD_DELAY_TIME * NET_TIMER_HZ / SYSTIM_HZ);
		*tick = ntick;
		timeout((callout_func)nd6_dad_timer, ifa, ntick);
	}

#endif	/* of #if NUM_IP6_DAD_COUNT == 0 */

}

#endif /* of #ifdef SUPPORT_INET6 */
