﻿//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Sample1.cs 117 2013-02-11 09:48:41Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace Console
{
	public interface IEtherConnection
	{
		void Receive(byte[] packet);
	}

	public class SifEtherCtrl : IEtherConnection, IUnitInterface
	{
		IUnitSim m_UnitSim;
		string m_Name;
		ulong m_MacAddr;
		int m_Kind;
		IEtherConnection m_EtherConnection;
		uint m_SelfIP;
		ushort m_PortNo;
		uint m_TargetIP;
		ushort m_TargetPortNo;

		public SifEtherCtrl(IUnitSim unitSim, string name, int kind)
		{
			m_UnitSim = unitSim;
			m_Name = name;
			m_Kind = kind;
			m_MacAddr = (ulong)((new Random()).NextDouble() * 0x1000000000000UL) & 0xFFFFFFFFFFFEUL | 2UL;
		}

		public void Init(uint selfIP, ushort portNo, uint targetIP, ushort targetPortNo)
		{
			m_SelfIP = selfIP;
			m_PortNo = portNo;
			m_TargetIP = targetIP;
			m_TargetPortNo = targetPortNo;
		}

		public IEtherConnection EtherConnection
		{
			get { return m_EtherConnection; }
			set { m_EtherConnection = value; }
		}

		public void Receive(byte[] packet)
		{
			m_UnitSim.Input(m_Kind, packet);
		}

		public void SendMsg(byte[] msg)
		{
			if (m_EtherConnection == null)
				return;

			m_EtherConnection.Receive(msg);
		}

		public string InterfaceName
		{
			get { return m_Name; }
		}

		public IUnitSim UnitSim
		{
			get { return m_UnitSim; }
		}
	}
}
