/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: core_config.h 92 2011-08-07 05:57:30Z nagasima $
 */

/*
 *		RAˑW[iARM-Mpj
 *
 *  ̃CN[ht@ĆCtarget_config.hi܂́CCN
 *  [ht@Cĵ݂CN[hD̃t@C
 *  ڃCN[hĂ͂ȂȂD
 */

#ifndef TOPPERS_CORE_CONFIG_H
#define TOPPERS_CORE_CONFIG_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef TOPPERS_MACRO_ONLY

/*
 *  RA̓ꖽ߂̃CC֐`
 */
#include "core_insn.h"

/*
 *  ^[Qbgˑ̃IuWFNg
 */
#define TARGET_INHATR  TA_NONKERNEL /* ^[Qbg`̊݃nh */

/*
 *  G[`FbN@̎w
 */
#define CHECK_STKSZ_ALIGN	8	/* X^bNTCỸACP */
#define CHECK_FUNC_ALIGN	1	/* ֐̃ACP */
#define CHECK_FUNC_NONNULL		/* ֐̔NULL`FbN */
#define CHECK_STACK_ALIGN	8	/* X^bN̈̃ACP */
#define CHECK_STACK_NONNULL		/* X^bN̈̔NULL`FbN */
#define CHECK_MPF_ALIGN		4	/* Œ蒷v[̈̃ACP */
#define CHECK_MPF_NONNULL		/* Œ蒷v[̈̔NULL`FbN */
#define CHECK_MB_ALIGN		4	/* Ǘ̈̃ACP */

/*
 *  ^XNReLXgp̃X^bNl
 */
#define TOPPERS_ISTKPT(istk, istksz) ((STK_T *)((char_t *)(istk) + (istksz)))

/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	void	(*start)(void);
	void	*cpu_context;
} TSKCTXB;

#endif /* TOPPERS_MACRO_ONLY */

#ifndef TOPPERS_MACRO_ONLY
/*
 *  ReLXg̎Q
 *
 */
Inline bool_t
sense_context(void)
{
	/*
	 *  PSPLȂ^XNReLXgCMSPLȂ^XNReLXg
	 *  ƂD 
	 */
	if ((get_control() & CONTROL_PSP) == CONTROL_PSP){
		return false;
	}
	else {
		return true;
	}
}

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  TOPPERSWݏf̎
 *
 *  ݗDx}XNƂẮCBASEPRIpDS݂֎~
 *  @\ƂāCFAULTMASKPRIMASK邪CJ[lǗO݂̊
 *  T|[g邽߁CCPUbN̂߂ɗpȂD
 *  ̂߁CBASEPRIpċ[ICPUbNtOD
 *
 *  ܂CCPUbNԂǗ߂̕ϐ(lock_flag)pӂD
 *
 *  CPUbNtONAĂԂ́CBASEPRIf̊
 *  Dx}XN̒lɐݒ肷D̊Ԃ́Cf̊ݗDx}X
 *  ŃCBASEPRIpD
 * 
 *  ɑ΂CPUbNtOZbgꂢԂ́CBASEPRICJ[l
 *  ǗÔׂ̂Ă̊ݗv}XNl(TIPM_LOCK)ƁC
 *  f̊ݗDx}XNƂ̍ɐݒ肷D̊Ԃ̃f
 *  ̊ݗDx}XŃĈ߂̕ϐ(saved_iipm, \ŕێ)
 *  pӂĕێD
 */

/*
 *  ݗDx}XN̊O\Ɠ\̕ϊ
 *
 *  AZũ\[Xt@CCN[hꍇ̂߂ɁC
 *  CASTgp
 *  ݗDx̃rbg(TBITW_IPRI) 8 ̏ꍇ́CDx 255
 *  ́CODx -1 ɑΉD
 */
#define EXT_IPM(iipm)   (CAST(PRI,((iipm >> (8 - TBITW_IPRI)) - (1 << TBITW_IPRI))))       /* \O\ */
#define INT_IPM(ipm)    (((1 << TBITW_IPRI) - CAST(uint8_t, -(ipm)))  << (8 - TBITW_IPRI)) /* O\\ */

/*
 *  CPUbNԂł̊ݗDx}XN
 */
#define TIPM_LOCK    TMIN_INTPRI

/*
 *  CPUbNԂł̊ݗDx}XN̓\
 *
 *  TIPM_LOCḰCCPUbNԂłBASEPRI̒lDJ[lǗÔ̂
 *  ׂĂ݂̊}XNlɒ`D  
 */
#define IIPM_LOCK    INT_IPM(TIPM_LOCK)

/*
 *  TIPM_ENAALLiݗDx}XNSj̓\
 *
 *  BASEPRI '0' ݒ肷邱ƂŁCS݂D
 */
#define IIPM_ENAALL  (0)


#ifndef TOPPERS_MACRO_ONLY

/*
 *  CPUbNtÔ߂̕ϐ
 * 
 *  ̕ϐ́CCPUbNԂ̎̂ݏĂ悢ƂD
 *  CC֐ŁCANZX̏ωȂ悤Cvolatile wD 
 */
extern volatile bool_t  lock_flag;    /* CPUbNtO̒lێϐ */
extern volatile uint32_t saved_iipm;  /* ݗDx}XNϐ */

/*
 *  CPUbNԂւ̈ڍs
 *
 *  BASEPRIin[hEFÅݗDx}XNjCsaved_iipmɕۑC
 *  J[lǗÔׂ̂Ă݂̊}XNliTIPM_LOCKj
 *  ɐݒ肷D܂Clock_flagtrueɂD
 *
 *  BASEPRICŏTIPM_LOCKƓ荂ꍇɂ́C
 *  saved_iipmɕۑ݂̂ŁCTIPM_LOCKɂ͐ݒ肵ȂD́Cf
 *  ̊ݗDx}XNCTIPM_LOCKƓ荂xɐݒ
 *  ĂԂɂD
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjŌĂ΂邱Ƃ
 *  Ȃ̂Ƒz肵ĂD
 */
Inline void
x_lock_cpu(void)
{
	uint32_t iipm;

	/*
	 *  get_basepri()̕Ԃl𒼐saved_iipmɕۑCꎞϐiipm
	 *  pĂ̂́Cget_baespri()Ă񂾒Ɋ݂C
	 *  Nꂽݏsaved_iipmύX\邽߂
	 *  D
	 */
	iipm = get_basepri();
	/*
	 *  BASEPRIWX^͒lقǗDxCIIPM_ENAALL 
	 *  '0'ł邽߁CPɗDxrł͕s\łD
	 */
	if ((IIPM_LOCK < iipm) || (IIPM_ENAALL == iipm)) {
		set_basepri(IIPM_LOCK);
	}
	saved_iipm = iipm;
	lock_flag = true;
	/* NeBJZNV̑OŃ\ */
	//Asm("":::"memory");
}

#define t_lock_cpu()    x_lock_cpu()
#define i_lock_cpu()    x_lock_cpu()

/*
 *  CPUbNԂ̉
 *
 *  lock_flagfalseɂCIPMin[hEFÅݗDx}XNjC
 *  saved_iipmɕۑlɖ߂D
 *
 *  ̊֐́CCPUbNԁilock_flagtruȅԁjł̂݌Ă΂
 *  ̂Ƒz肵ĂD
 */
Inline void
x_unlock_cpu(void)
{
	/* NeBJZNV̑OŃ\ */
	//Asm("":::"memory");
	lock_flag = false;
	set_basepri(saved_iipm);
}

#define t_unlock_cpu()    x_unlock_cpu()
#define i_unlock_cpu()    x_unlock_cpu()

/*
 *  CPUbNԂ̎Q
 */
Inline bool_t
x_sense_lock(void)
{
	return(lock_flag);
}

#define t_sense_lock()    x_sense_lock()
#define i_sense_lock()    x_sense_lock()

/*
 *  chg_ipmŗLȊݗDx͈̔͂̔
 *
 *  TMIN_INTPRI̒lɂ炸Cchg_ipmł́C-(1 << TBITW_IPRI)`TIPM_ENAALLi0j
 *  ͈̔͂ɐݒł邱ƂƂi^[Qbg`̊gjD
 *  ݗDx̃rbg(TBITW_IPRI) 8 ̏ꍇ́C-256 ` 0 w\łD
 *   
 */
#define VALID_INTPRI_CHGIPM(intpri) \
				((-((1 << TBITW_IPRI) - 1) <= (intpri) && (intpri) <= TIPM_ENAALL))

/*
 * if́jݗDx}XN̐ݒ
 *
 *  CPUbNtONAĂ鎞́Cn[hEFÅݗDx}
 *  XNݒ肷DCPUbNtOZbgĂ鎞́Csaved_iipm
 *  ݒ肵CɁCn[hEFÅݗDx}XNCݒ肵悤
 *  if́jݗDx}XNTIPM_LOCK̍ɐݒ肷D
 */
Inline void
x_set_ipm(PRI intpri)
{
	uint8_t   iipm = INT_IPM(intpri);

	if (intpri == TIPM_ENAALL){
		iipm = IIPM_ENAALL;
	}

	if (!lock_flag) {
		set_basepri(iipm);
	}
	else {
		saved_iipm = iipm;
		set_basepri(iipm < IIPM_LOCK ? iipm : IIPM_LOCK);
	}
}

#define t_set_ipm(intpri)    x_set_ipm(intpri)
#define i_set_ipm(intpri)    x_set_ipm(intpri)

/*
 * if́jݗDx}XN̎Q
 *
 *  CPUbNtONAĂ鎞̓n[hEFÅݗDx}
 *  XNCZbgĂ鎞saved_iipmQƂD
 */
Inline PRI
x_get_ipm(void)
{
	uint8_t iipm;

	if (!lock_flag) {
		iipm = get_basepri();
	}
	else {
		iipm = saved_iipm;
	}

	if (iipm == IIPM_ENAALL) {
		return(TIPM_ENAALL);
	}
	else {
		return(EXT_IPM(iipm));
	}
}

#define t_get_ipm()    x_get_ipm()
#define i_get_ipm()    x_get_ipm()

/*
 *  SVCnhicore_support.Sj
 */
extern void svc_handler(void);

/*
 *  X^[gAbv[`istart.Sj
 */
extern void _start(void);

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icore_support.Sj
 *
 *  dispatch́C^XNReLXgĂяoꂽT[rXR[
 *  ĂяôׂŁC^XNReLXgECPUbNԁEfBXpb
 *  `ԁEif́jݗDx}XNSԂŌĂяo
 *  ΂ȂȂD
 */
extern void dispatch(void);

/*
 *  fBXpb`̓Jnicore_support.Sj
 *
 *  start_dispatch́CJ[lNɌĂяôׂŁCׂĂ̊
 *  ݂֎~ԁi݃bNԂƓ̏ԁjŌĂяoȂ
 *  ȂȂD
 */
#define _kernel_start_dispatch()	return

/*
 *  ݂̃ReLXĝĂăfBXpb`icore_support.Sj
 *
 *  exit_and_dispatch́Cext_tskĂяôׂŁC^XNReL
 *  XgECPUbNԁEfBXpb`ԁEif́jݗD
 *  x}XNSԂŌĂяoȂ΂ȂȂD
 */
extern void exit_and_dispatch(void) NoReturn;

/*
 *  J[l̏Ǐďoicore_support.Sj
 *
 *  call_exit_kerneĺCJ[l̏IɌĂяôׂŁC^XN
 *  ReLXgɐ؂芷āCJ[l̏Iiexit_kerneljĂяo
 *  D
 */
extern void call_exit_kernel(void) NoReturn;

/*
 *  ^XNReLXg̏
 *
 *  ^XNx~ԂsłԂɈڍs鎞ɌĂ΂D̎_
 *  ŃX^bN̈gĂ͂ȂȂD
 *
 *  activate_contextCCC֐ł͂Ȃ}N`ƂĂ̂́C
 *  ̎_łTCB`ĂȂ߂łD
 */
extern void    start_r(void);

extern void   *new_context(void *p_tcb);
#define activate_context(p_tcb)                                         \
{                                                                       \
    (p_tcb)->tskctxb.start = (void *) start_r;                         \
    (p_tcb)->tskctxb.cpu_context = new_context(p_tcb);                  \
}

/*
 *  calltex͎gpȂ
 */
#define OMIT_CALLTEX

/*
 *  ݔԍE݃nhԍ
 *
 *  ݃nhԍ(inhno)Ɗݔԍ(intno)́C荞ݔ
 *  EPSRɐݒ肳OԍƂD 
 */

/*
 *  ݔԍ͈̔͂̔
 */
#define VALID_INTNO(intno)           ((TMIN_INTNO <= (intno)) && ((intno) <= TMAX_INTNO))
#define VALID_INTNO_DISINT(intno)    VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)    VALID_INTNO(intno)

/*
 *  ݃nh̐ݒ
 *
 *  xNgԍinhno̊݃nh̋NԒnint_entryɐݒ肷D
 *  nhe[u
 */
extern void x_define_inh(INHNO inhno, FP int_entry);

/*
 *  ݃nh̏o̐}N
 *
 */
#define INT_ENTRY(inhno, inthdr)    inthdr
#define INTHDR_ENTRY(inhno, inhno_num, inthdr) extern void inthdr(void);

/*
 *  ݗv֎~tO
 */

/*
 *  ݑݒ肳Ă邩𔻕ʂ邽߂̕ϐikernel_cfg.cj
 */
extern const uint32_t	bitpat_cfgint[];

/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD  
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	uint32_t tmp;

	/*
	 *  ݑݒ肳ĂȂꍇ
	 */
	if ((bitpat_cfgint[intno >> 5] & (1 << (intno & 0x1f))) == 0x00) {
		return(false);
	}

	if (intno == IRQNO_SYSTICK) {
		tmp = sil_rew_mem((void *)SYSTIC_CONTROL_STATUS);
		tmp &= ~SYSTIC_TICINT;
		sil_wrw_mem((void *)SYSTIC_CONTROL_STATUS, tmp);
	}else {
		tmp = intno - 16;
		sil_wrw_mem((void *)((uint32_t *)NVIC_CLRENA0 + (tmp >> 5)),
					(1 << (tmp & 0x1f)));
	}

	return(true);
}

#define t_disable_int(intno) x_disable_int(intno)
#define i_disable_int(intno) x_disable_int(intno)

/*
 *  ݗv֎~tỎ
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CfalseԂD
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	uint32_t tmp;

	/*
	 *  ݑݒ肳ĂȂꍇ
	 */
	if ((bitpat_cfgint[intno >> 5] & (1 << (intno & 0x1f))) == 0x00) {
		return(false);
	}

	if (intno == IRQNO_SYSTICK) {
		tmp = sil_rew_mem((void *)SYSTIC_CONTROL_STATUS);
		tmp |= SYSTIC_TICINT;
		sil_wrw_mem((void *)SYSTIC_CONTROL_STATUS, tmp);
	}else {
		tmp = intno - 16;
		sil_wrw_mem((void *)((uint32_t *)NVIC_SETENA0 + (tmp >> 5)),
					(1 << (tmp & 0x1f)));
	}
    
	return(true);
}

#define t_enable_int(intno) x_enable_int(intno)
#define i_enable_int(intno) x_enable_int(intno)

/*
 *  ݗvC̑̐ݒ
 */
extern void x_config_int(INTNO intno, ATR intatr, PRI intpri);

/*
 *  ݃nhŕKvIRC
 */
Inline void
i_begin_int(INTNO intno)
{
}

/*
 *  ݃nh̏oŕKvIRC
 */
Inline void
i_end_int(INTNO intno)
{
}

/*
 *  CPUOnh֌W
 */ 

/*
 *  CPUOnhԍ
 */
#define VALID_EXCNO_DEFEXC(excno)    (TMIN_EXCNO <= (excno) && (excno) <= TMAX_EXCNO)

/*
 *  CPUOnh̋
 */
extern void enable_exc(EXCNO excno);

/*
 *  CPUOnh̋֎~
 */
extern void disable_exc(EXCNO excno);

/*
 *  CPUOnh̐ݒ
 */
Inline void
x_define_exc(EXCNO excno, FP exc_entry)
{
	/*
	 *  ꕔ̗O͋sKv
	 */
	enable_exc(excno);
}

/*
 *  CPUOnh̓̐}N
 */
#define EXC_ENTRY(excno, exchdr)    exchdr
#define EXCHDR_ENTRY(excno, excno_num, exchdr) extern void exchdr(void *p_excinf);

/*
 *  CPUO̔̃ReLXg̎Q
 *
 *  CPUO̔̃ReLXgC^XNReLXg̎falseC
 *  łȂtrueԂD
 */
Inline bool_t
exc_sense_context(void *p_excinf)
{
	uint32_t exc_return;

	exc_return = *((uint32_t *)p_excinf + P_EXCINF_OFFSET_EXC_RETURN);
	if ((exc_return & EXC_RETURN_PSP) == EXC_RETURN_PSP){
		return false;
	}
	else {
		return true;
	}
}

/*
 *  CPUO̔IPMin[hEFÅݗDx}XNC\
 *  j̎Q
 */
Inline uint32_t
exc_get_iipm(void *p_excinf)
{
	return(*((uint32_t *)p_excinf + P_EXCINF_OFFSET_BASEPRI));
}

/*
 *  CPUO̔̃ReLXgƊ݂̃}XNԂ̎Q
 *
 *  CPUO̔̃VXeԂCJ[lsłȂC^XNR
 *  eLXgłC݃bNԂłȂCCPUbNԂłȂCi
 *  f́jݗDx}XNSԂł鎞trueCłȂ
 *  falseԂiCPUOJ[lǗO̊ݏŔꍇ
 *  ɂfalseԂjD
 *
 *  CPUO̔BASEPRIin[hEFÅݗDx}XNj
 *  ׂĂ݂̊Ԃł邱Ƃ`FbN邱ƂŁCJ[
 *  lsłȂƁC݃bNԂłȂƁCCPUbNԂł
 *  ƁCif́jݗDx}XNSԂł邱Ƃ4
 *  `FbN邱ƂłiCPUOlock_flagQ
 *  ƂKv͂ȂjD
 */
Inline bool_t
exc_sense_intmask(void *p_excinf)
{
	return(!exc_sense_context(p_excinf)
		   && (exc_get_iipm(p_excinf) == IIPM_ENAALL));
}

/*
 *  CPUOGgicore_support.Sj
 */
extern void core_exc_entry(void);

/*
 *  ݃Ggicore_support.Sj
 */
extern void core_int_entry(void);

/*
 *  RAˑ̏
 */
extern void core_initialize(void);

/*
 *  RAˑ̏I
 */
extern void core_terminate(void);

/*
 * o^ĂȂOƌĂяo
 */
extern void default_exc_handler(void *p_excinf);

/*
 * o^݂̊ꍇɌĂяo
 */
extern void default_int_handler(void *p_excinf);

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_CORE_CONFIG_H */
