/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2008 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: pridataq.h 1 2010-03-29 04:33:11Z nagasima $
 */

/*
 *		Dxf[^L[@\
 */

#ifndef TOPPERS_PRIDATAQ_H
#define TOPPERS_PRIDATAQ_H

#include <queue.h>

/*
 *  Dxf[^ǗubN
 */
typedef struct pridata_management_block PDQMB;

struct pridata_management_block {
	PDQMB		*p_next;		/* ̃f[^ */
	intptr_t	data;			/* f[^{ */
	PRI			datapri;		/* f[^Dx */
};

/*
 *  Dxf[^L[ubN
 *
 *  ̍\̂́CEʐMIuWFNg̏ubN̋ʕ
 *  iWOBJINIBjgiIuWFNgw̌pɑĵŁC
 *  ŏ̃tB[hʂɂȂĂD
 */
typedef struct pridataq_initialization_block {
	ATR			pdqatr;			/* Dxf[^L[ */
	uint_t		pdqcnt;			/* Dxf[^L[̗e */
	PRI			maxdpri;		/* f[^Dx̍ől */
	PDQMB		*p_pdqmb;		/* Dxf[^L[Ǘ̈̐擪Ԓn */
} PDQINIB;

/*
 *  Dxf[^L[ǗubN
 *
 *  ̍\̂́CEʐMIuWFNg̊ǗubN̋ʕiWOBJCBj
 *  giIuWFNgw̌pɑĵŁCŏ2
 *  tB[hʂɂȂĂD
 */
typedef struct pridataq_control_block {
	QUEUE		swait_queue;	/* Dxf[^L[M҂L[ */
	const PDQINIB *p_pdqinib;	/* ubNւ̃|C^ */
	QUEUE		rwait_queue;	/* Dxf[^L[M҂L[ */
	uint_t		count;			/* Dxf[^L[̃f[^̐ */
	PDQMB		*p_head;		/* ŏ̃f[^ */
	uint_t		unused;			/* gpf[^ǗubN̐擪 */
	PDQMB		*p_freelist;	/* ăf[^ǗubÑXg */
} PDQCB;

/*
 *  Dxf[^L[҂ubN̒`
 *
 *  ̍\̂́CEʐMIuWFNg̑҂ubN̋ʕ
 *  iWINFO_WOBJjgiIuWFNgw̌pɑĵŁC
 *  ŏ2̃tB[hʂɂȂĂD
 *  Dxf[^L[ւ̑M҂ƗDxf[^L[̎M҂ŁC
 *  ҂ubNgD
 */
typedef struct pridataq_waiting_information {
	WINFO		winfo;			/* W̑҂ubN */
	PDQCB		*p_pdqcb;		/* ҂ĂDxf[^L[̊ǗubN*/
	intptr_t	data;			/* Mf[^ */
	PRI			datapri;		/* f[^Dx */
} WINFO_PDQ;

/*
 *  Dxf[^L[ID̍őlikernel_cfg.cj
 */
extern const ID	tmax_pdqid;

/*
 *  Dxf[^L[ubÑGAikernel_cfg.cj
 */
extern const PDQINIB	pdqinib_table[];

/*
 *  Dxf[^L[ǗubÑGAikernel_cfg.cj
 */
extern PDQCB	pdqcb_table[];

/*
 *  Dxf[^L[ǗubNDxf[^L[IDo
 *  ߂̃}N
 */
#define	PDQID(p_pdqcb)	((ID)(((p_pdqcb) - pdqcb_table) + TMIN_PDQID))

/*
 *  Dxf[^L[@\̏
 */
extern void	initialize_pridataq(void);

/*
 *  Dxf[^L[Ǘ̈ւ̃f[^̊i[
 */
extern void	enqueue_pridata(PDQCB *p_pdqcb, intptr_t data, PRI datapri);

/*
 *  Dxf[^L[Ǘ̈悩̃f[^̎o
 */
extern void	dequeue_pridata(PDQCB *p_pdqcb, intptr_t *p_data, PRI *p_datapri);

/*
 *  Dxf[^L[ւ̃f[^M
 */
extern bool_t	send_pridata(PDQCB *p_pdqcb, intptr_t data,
											PRI datapri, bool_t *p_reqdsp);

/*
 *  Dxf[^L[̃f[^M
 */
extern bool_t	receive_pridata(PDQCB *p_pdqcb, intptr_t *p_data,
											PRI *p_datapri, bool_t *p_reqdsp);

#endif /* TOPPERS_PRIDATAQ_H */
