/**
 * @file pll.c
 *
 *  @date 2010/08/08
 *  @author takemasa
 *  @brief PLL制御関数
 */
#include "pll.h"
#include "LPC17xx.h"



void initPLL0(
		pllClockSource_type 	clkSrc,
		unsigned int 			isMainOsc20MHzMore,
		unsigned int			N,
		unsigned int			M,
		unsigned int			cpuClkDiv
	)
{

	if ( clkSrc == eMainOsc )
	{
			// メインオシレータを使う場合には、周波数レンジに応じてSCSの設定を変える。
		if ( isMainOsc20MHzMore )
			LPC_SC->SCS = 1<<5;
		else
			LPC_SC->SCS = 1<<5 | 1<<4;

		while
			((LPC_SC->SCS & (1<<6)) == 0);/* Wait for Oscillator to be ready    */
	}

	LPC_SC->CCLKCFG   = cpuClkDiv-1;      	/* CPUクロックデバイダの設定    */
	LPC_SC->CLKSRCSEL = clkSrc;    			/* PLLに入力するクロック源の設定   */

	LPC_SC->PLL0CFG   = (N-1) <<16 | (M-1); /* 分周比と低倍比の設定 */
	LPC_SC->PLL0FEED  = 0xAA;
	LPC_SC->PLL0FEED  = 0x55;

	LPC_SC->PLL0CON   = 0x01;             /* PLL0 Enable                        */
	LPC_SC->PLL0FEED  = 0xAA;
	LPC_SC->PLL0FEED  = 0x55;
	while
	  (!(LPC_SC->PLL0STAT & (1<<26)));/* Wait for PLOCK0                    */

	LPC_SC->PLL0CON   = 0x03;             /* PLL0 Enable & Connect              */
	LPC_SC->PLL0FEED  = 0xAA;
	LPC_SC->PLL0FEED  = 0x55;
	while
	  (!(LPC_SC->PLL0STAT & ((1<<25) | (1<<24))));/* Wait for PLLC0_STAT & PLLE0_STAT */


}
