/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#ifndef H_LOADED_TPI_HANDLE
#define H_LOADED_TPI_HANDLE

#define wxUSE_DYNLIB_CLASS  1
#include <wx/dynlib.h>

//******************************************************************************
//    Class (TPIHandle)
//******************************************************************************

class TPIHandle
{
	public:
		TPIHandle(void);
		~TPIHandle(void);
		bool InitLibrary(const wxString & _szLibName, const wxString & _szArcName, wxULongLong_t _llTypeId = 0);
		bool FreeLibrary(void);

		bool GetPluginInformation(unsigned int _uInfoId, wxULongLong_t _llSubOption, void * _pPtr);
		bool GetFormatInformation(TPI_FORMATINFO * _fiInfo, bool _bFirst = false);

		bool OpenArchive(const wxString & _szArcName, wxULongLong_t * _llFileCount = NULL);
		bool CloseArchive(void);
		bool GetFileInformation(TPI_FILEINFO * _fiInfo, bool _bFirst = false);
		bool GetArchiveInformation(TPI_ARCHIVEINFO * _aiInfo);

		bool Command(wxULongLong_t _eCommand, TPI_SWITCHES * _swInfo, const wxString & _szArcName, const wxArrayString & _szFiles);

		bool SetCallbackProc(TPI_PROC _prProc);

		int nErrorCode;

	private:
		wxDynamicLibrary lib;
		void * archive;
};

#endif
