﻿/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#include "lychee.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"

//******************************************************************************
// myFileDropTarget
//******************************************************************************

myFileDropTarget::myFileDropTarget(MainFrame * mainFrame)
{
	this->mainFrame = mainFrame;
}

//******************************************************************************
// Event handler.
//******************************************************************************

bool myFileDropTarget::OnDropFiles(wxCoord, wxCoord, const wxArrayString & asFiles)
{
#if wxCHECK_VERSION(2, 9, 0)
	wxThreadEvent * e;
#else
	wxCommandEvent * e;
#endif

	// ファイルが存在するか確認。
	if (asFiles.GetCount() == 1 && ::wxFileExists(asFiles[0]))
	{
		// 対応しているかどうか確認。
		wxULongLong_t llFileCount = 0;
		if (this->mainFrame->LoadTPI(asFiles[0], & llFileCount))
		{
			// 書庫を開く。
#if wxCHECK_VERSION(2, 9, 0)
			e = new wxThreadEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Open"));
#else
			e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Open"));
#endif
			e->SetInt(2);
			e->SetExtraLong((long) llFileCount);
			this->mainFrame->fnArchive = wxFileName(asFiles[0]);
#if wxCHECK_VERSION(2, 9, 0)
			::wxQueueEvent(this->mainFrame, e);
#else
			this->mainFrame->OnArcOpen(* e);
			delete e;
#endif
			return true;
		}
	}

	// 対応していない場合は書庫の作成を試みる。
	this->as = asFiles;
#if wxCHECK_VERSION(2, 9, 0)
	e = new wxThreadEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Create"));
#else
	e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Create"));
#endif
	e->SetClientData(& this->as);
#if wxCHECK_VERSION(2, 9, 0)
	::wxQueueEvent(this->mainFrame, e);
#else
	this->mainFrame->OnArcCreate(* e);
	delete e;
#endif
	return true;
}

//******************************************************************************
// myFileDataObject
//******************************************************************************

myFileDataObject::~myFileDataObject()
{
	// ファイルを削除。
	for (size_t i = 0; i < this->m_filenames.GetCount(); i++)
	{
		chmod(this->m_filenames[i].ToUTF8(), 0600);
		::wxRemoveFile(this->m_filenames[i]);
	}

	// 一時ディレクトリを削除。
	::wxRmdir(this->szTempDir);
}

#ifdef __LINUX__
// wxGTKのwxFileDataObjectでは多バイト文字の扱いに問題があるので代替。
bool myFileDataObject::GetDataHere(void * buf) const
{
	wxString filenames;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		filenames += wxT("file:") + m_filenames[i] + wxT("\r\n");
	}
	memcpy(buf, filenames.mbc_str(), strlen(filenames.mbc_str()) + 1);
	return true;
}

size_t myFileDataObject::GetDataSize() const
{
	size_t res = 1;
	for (size_t i = 0; i < m_filenames.GetCount(); i++)
	{
		res += strlen(m_filenames[i].mbc_str()) + 5 + 2; // "file:" (5) + "\r\n" (2)
	}
	return res;
}

void myFileDataObject::AddFile(const wxString & filename)
{
	m_filenames.Add(filename);
}
#endif
