/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.annotations;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.annotations.AbstractXYAnnotation;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleEdge;
import org.afree.ui.TextAnchor;
import org.afree.util.PaintTypeUtilities;
import org.afree.util.PublicCloneable;

public class XYTextAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2946063342782506328L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    public static final PaintType DEFAULT_PAINT_TYPE = new SolidColor(-16777216);
    public static final TextAnchor DEFAULT_TEXT_ANCHOR = TextAnchor.CENTER;
    public static final TextAnchor DEFAULT_ROTATION_ANCHOR = TextAnchor.CENTER;
    public static final double DEFAULT_ROTATION_ANGLE = 0.0;
    private String text;
    private Font font;
    private transient PaintType paintType;
    private double x;
    private double y;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double rotationAngle;
    private transient PaintType backgroundPaintType;
    private boolean outlineVisible;
    private transient PaintType outlinePaintType;
    private transient float outlineStroke;

    public XYTextAnnotation(String text, double x, double y) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        this.text = text;
        this.font = DEFAULT_FONT;
        this.paintType = DEFAULT_PAINT_TYPE;
        this.x = x;
        this.y = y;
        this.textAnchor = DEFAULT_TEXT_ANCHOR;
        this.rotationAnchor = DEFAULT_ROTATION_ANCHOR;
        this.rotationAngle = 0.0;
        this.backgroundPaintType = null;
        this.outlineVisible = false;
        this.outlinePaintType = new SolidColor(-16777216);
        this.outlineStroke = 0.5f;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.font = font;
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void setPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paintType = paintType;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(TextAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.textAnchor = anchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public void setRotationAnchor(TextAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.rotationAnchor = anchor;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public PaintType getBackgroundPaintType() {
        return this.backgroundPaintType;
    }

    public void setBackgroundPaintType(PaintType paintType) {
        this.backgroundPaintType = paintType;
    }

    public PaintType getOutlinePaintType() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.outlinePaintType = paintType;
    }

    public float getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(float stroke) {
        if (stroke == 0.0f) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.outlineStroke = stroke;
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean visible) {
        this.outlineVisible = visible;
    }

    public void draw(Canvas canvas, XYPlot plot, RectShape dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        float anchorX = (float)domainAxis.valueToJava2D(this.x, dataArea, domainEdge);
        float anchorY = (float)rangeAxis.valueToJava2D(this.y, dataArea, rangeEdge);
        if (orientation == PlotOrientation.HORIZONTAL) {
            float tempAnchor = anchorX;
            anchorX = anchorY;
            anchorY = tempAnchor;
        }
        Paint paint = PaintUtility.createPaint(1, this.getPaintType(), this.getFont());
        RectShape hotspot = TextUtilities.calculateRotatedStringBounds(this.getText(), paint, anchorX, anchorY, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor());
        if (this.backgroundPaintType != null) {
            PaintUtility.updatePaint(paint, this.backgroundPaintType);
            hotspot.fill(canvas, paint);
        }
        PaintUtility.updatePaint(paint, this.backgroundPaintType);
        TextUtilities.drawRotatedString(this.getText(), canvas, anchorX, anchorY, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor(), paint);
        if (this.outlineVisible) {
            PaintUtility.updatePaint(paint, this.backgroundPaintType);
            paint.setStrokeWidth(this.outlineStroke);
            hotspot.draw(canvas, paint);
        }
        String toolTip = this.getToolTipText();
        String url = this.getURL();
        if (toolTip != null || url != null) {
            this.addEntity(info, hotspot, rendererIndex, toolTip, url);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYTextAnnotation)) {
            return false;
        }
        XYTextAnnotation that = (XYTextAnnotation)obj;
        if (!this.text.equals(that.text)) {
            return false;
        }
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        if (!this.font.equals(that.font)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.paintType, that.paintType)) {
            return false;
        }
        if (!this.rotationAnchor.equals(that.rotationAnchor)) {
            return false;
        }
        if (this.rotationAngle != that.rotationAngle) {
            return false;
        }
        if (!this.textAnchor.equals(that.textAnchor)) {
            return false;
        }
        if (this.outlineVisible != that.outlineVisible) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.backgroundPaintType, that.backgroundPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.outlinePaintType, that.outlinePaintType)) {
            return false;
        }
        if (this.outlineStroke != that.outlineStroke) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = 193;
        result = 37 * this.text.hashCode();
        result = 37 * this.font.hashCode();
        long temp = Double.doubleToLongBits(this.x);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        result = 37 * result + this.textAnchor.hashCode();
        result = 37 * result + this.rotationAnchor.hashCode();
        temp = Double.doubleToLongBits(this.rotationAngle);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.paintType, stream);
        SerialUtilities.writePaintType(this.backgroundPaintType, stream);
        SerialUtilities.writePaintType(this.outlinePaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paintType = SerialUtilities.readPaintType(stream);
        this.backgroundPaintType = SerialUtilities.readPaintType(stream);
        this.outlinePaintType = SerialUtilities.readPaintType(stream);
    }
}

