/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.axis.NumberAxis;
import org.afree.chart.plot.IntervalMarker;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.util.ObjectUtilities;

public class MarkerAxisBand
implements Serializable {
    private static final long serialVersionUID = -1729482413886398919L;
    private NumberAxis axis;
    private double topOuterGap;
    private double topInnerGap;
    private double bottomOuterGap;
    private double bottomInnerGap;
    private Font font;
    private List markers;

    public MarkerAxisBand(NumberAxis axis, double topOuterGap, double topInnerGap, double bottomOuterGap, double bottomInnerGap, Font font) {
        this.axis = axis;
        this.topOuterGap = topOuterGap;
        this.topInnerGap = topInnerGap;
        this.bottomOuterGap = bottomOuterGap;
        this.bottomInnerGap = bottomInnerGap;
        this.font = font;
        this.markers = new ArrayList();
    }

    public void addMarker(IntervalMarker marker) {
        this.markers.add(marker);
    }

    public double getHeight(Canvas canvas) {
        double result = 0.0;
        if (this.markers.size() > 0) {
            Paint p = PaintUtility.createPaint(1, new SolidColor(-16777216), this.font);
            RectShape rec = TextUtilities.getTextBounds("123g", p);
            result = this.topOuterGap + this.topInnerGap + (double)rec.getHeight() + this.bottomInnerGap + this.bottomOuterGap;
        }
        return result;
    }

    private void drawStringInRect(Canvas canvas, RectShape bounds, PaintType paintType, Font font, String text) {
        Paint p = PaintUtility.createPaint(1, paintType, this.font);
        RectShape r = TextUtilities.getTextBounds(text, p);
        double x = bounds.getX();
        if (r.getWidth() < bounds.getWidth()) {
            x += (double)((bounds.getWidth() - r.getWidth()) / 2.0f);
        }
        canvas.drawText(text, (float)x, (float)((double)bounds.getMaxY() - this.bottomInnerGap), p);
    }

    public void draw(Canvas canvas, RectShape plotArea, RectShape dataArea, double x, double y) {
        double h = this.getHeight(canvas);
        for (IntervalMarker marker : this.markers) {
            double start = Math.max(marker.getStartValue(), this.axis.getRange().getLowerBound());
            double end = Math.min(marker.getEndValue(), this.axis.getRange().getUpperBound());
            double s = this.axis.valueToJava2D(start, dataArea, RectangleEdge.BOTTOM);
            double e = this.axis.valueToJava2D(end, dataArea, RectangleEdge.BOTTOM);
            RectShape r = new RectShape(s, y + this.topOuterGap, e - s, h - this.topOuterGap - this.bottomOuterGap);
            Paint p = PaintUtility.createPaint(1, marker.getPaintType());
            p.setStyle(Paint.Style.FILL);
            canvas.drawRect(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), p);
            PaintUtility.updatePaint(p, marker.getOutlinePaintType());
            p.setStyle(Paint.Style.STROKE);
            canvas.drawRect(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), p);
            p.setAlpha(255);
            this.drawStringInRect(canvas, r, marker.getLabelPaintType(), this.font, marker.getLabel());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MarkerAxisBand)) {
            return false;
        }
        MarkerAxisBand that = (MarkerAxisBand)obj;
        if (this.topOuterGap != that.topOuterGap) {
            return false;
        }
        if (this.topInnerGap != that.topInnerGap) {
            return false;
        }
        if (this.bottomInnerGap != that.bottomInnerGap) {
            return false;
        }
        if (this.bottomOuterGap != that.bottomOuterGap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.font, that.font)) {
            return false;
        }
        return ObjectUtilities.equal(this.markers, that.markers);
    }

    public int hashCode() {
        int result = 37;
        result = 19 * result + this.font.hashCode();
        result = 19 * result + this.markers.hashCode();
        return result;
    }
}

