/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot;

import android.graphics.PathEffect;
import java.io.Serializable;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.ui.LengthAdjustmentType;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleInsets;
import org.afree.ui.TextAnchor;

public abstract class Marker
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -734389651405327166L;
    private transient PaintType paintType;
    private transient float stroke;
    private transient PathEffect effect;
    private transient PaintType outlinePaintType;
    private transient float outlineStroke;
    private transient PathEffect outlineEffect;
    private int alpha;
    private String label = null;
    private Font labelFont;
    private transient PaintType labelPaintType;
    private RectangleAnchor labelAnchor;
    private TextAnchor labelTextAnchor;
    private RectangleInsets labelOffset;
    private LengthAdjustmentType labelOffsetType;

    protected Marker() {
        this(-7829368);
    }

    protected Marker(int paint) {
        this(paint, 0.5f, -7829368, 0.5f, 200);
    }

    protected Marker(int paintType, float stroke, int outlinePaintType, float outlineStroke, int alpha) {
        this.paintType = new SolidColor(paintType);
        this.stroke = stroke;
        this.outlinePaintType = new SolidColor(outlinePaintType);
        this.outlineStroke = outlineStroke;
        this.alpha = alpha;
        this.labelFont = new Font("SansSerif", 0, 9);
        this.labelPaintType = new SolidColor(-16777216);
        this.labelAnchor = RectangleAnchor.TOP_LEFT;
        this.labelOffset = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
        this.labelOffsetType = LengthAdjustmentType.CONTRACT;
        this.labelTextAnchor = TextAnchor.CENTER;
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void setPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paintType = paintType;
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setEffect(PathEffect effect) {
        this.effect = effect;
    }

    public PathEffect getEffect() {
        return this.effect;
    }

    public void setStroke(float stroke) {
        this.stroke = stroke;
    }

    public PaintType getOutlinePaintType() {
        return this.outlinePaintType;
    }

    public void setOutlinePaintType(PaintType paintType) {
        this.outlinePaintType = paintType;
    }

    public Float getOutlineStroke() {
        return Float.valueOf(this.outlineStroke);
    }

    public void setOutlineStroke(float stroke) {
        this.outlineStroke = stroke;
    }

    public PathEffect getOutlineEffect() {
        return this.outlineEffect;
    }

    public void setOutlineEffect(PathEffect outlineEffect) {
        this.outlineEffect = outlineEffect;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
    }

    public PaintType getLabelPaintType() {
        return this.labelPaintType;
    }

    public void setLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaintType = paintType;
    }

    public RectangleAnchor getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(RectangleAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelAnchor = anchor;
    }

    public RectangleInsets getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.labelOffset = offset;
    }

    public LengthAdjustmentType getLabelOffsetType() {
        return this.labelOffsetType;
    }

    public void setLabelOffsetType(LengthAdjustmentType adj) {
        if (adj == null) {
            throw new IllegalArgumentException("Null 'adj' argument.");
        }
        this.labelOffsetType = adj;
    }

    public TextAnchor getLabelTextAnchor() {
        return this.labelTextAnchor;
    }

    public void setLabelTextAnchor(TextAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelTextAnchor = anchor;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

