/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.Serializable;
import org.afree.chart.Effect3D;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.CategoryItemLabelGenerator;
import org.afree.chart.labels.ItemLabelAnchor;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.Marker;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.ValueMarker;
import org.afree.chart.renderer.category.BarRenderer;
import org.afree.chart.renderer.category.CategoryItemRendererState;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.category.CategoryDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.LengthAdjustmentType;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.RectangleEdge;
import org.afree.ui.TextAnchor;

public class BarRenderer3D
extends BarRenderer
implements Effect3D,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7686976503536003636L;
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final PaintType DEFAULT_WALL_PAINT = new SolidColor(-7829368);
    private double xOffset;
    private double yOffset;
    private transient PaintType wallPaintType;

    public BarRenderer3D() {
        this(12.0, 8.0);
    }

    public BarRenderer3D(double xOffset, double yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.wallPaintType = DEFAULT_WALL_PAINT;
        ItemLabelPosition p1 = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.TOP_CENTER);
        this.setBasePositiveItemLabelPosition(p1);
        ItemLabelPosition p2 = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.TOP_CENTER);
        this.setBaseNegativeItemLabelPosition(p2);
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public PaintType getWallPaintType() {
        return this.wallPaintType;
    }

    public void setWallPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.wallPaintType = paintType;
    }

    public CategoryItemRendererState initialise(Canvas canvas, RectShape dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        RectShape adjusted = new RectShape((double)dataArea.getX(), (double)dataArea.getY() + this.getYOffset(), (double)dataArea.getWidth() - this.getXOffset(), (double)dataArea.getHeight() - this.getYOffset());
        CategoryItemRendererState state = super.initialise(canvas, adjusted, plot, rendererIndex, info);
        return state;
    }

    public void drawBackground(Canvas canvas, CategoryPlot plot, RectShape dataArea) {
        float x0 = dataArea.getX();
        float x1 = x0 + (float)Math.abs(this.xOffset);
        float x3 = dataArea.getMaxX();
        float x2 = x3 - (float)Math.abs(this.xOffset);
        float y0 = dataArea.getMaxY();
        float y1 = y0 - (float)Math.abs(this.yOffset);
        float y3 = dataArea.getMinY();
        float y2 = y3 + (float)Math.abs(this.yOffset);
        PathShape clip = new PathShape();
        clip.moveTo(x0, y0);
        clip.lineTo(x0, y2);
        clip.lineTo(x1, y3);
        clip.lineTo(x3, y3);
        clip.lineTo(x3, y1);
        clip.lineTo(x2, y0);
        clip.closePath();
        PaintType backgroundPaintType = plot.getBackgroundPaintType();
        if (backgroundPaintType != null) {
            Paint backgroundPaint = PaintUtility.createPaint(1, backgroundPaintType);
            clip.fill(canvas, backgroundPaint);
        }
        Paint wallPaint = PaintUtility.createPaint(1, this.getWallPaintType());
        PathShape leftWall = new PathShape();
        leftWall.moveTo(x0, y0);
        leftWall.lineTo(x0, y2);
        leftWall.lineTo(x1, y3);
        leftWall.lineTo(x1, y1);
        leftWall.closePath();
        leftWall.fill(canvas, wallPaint);
        PathShape bottomWall = new PathShape();
        bottomWall.moveTo(x0, y0);
        bottomWall.lineTo(x1, y1);
        bottomWall.lineTo(x3, y1);
        bottomWall.lineTo(x2, y0);
        bottomWall.closePath();
        bottomWall.fill(canvas, wallPaint);
        wallPaint.setColor(-3355444);
        LineShape corner = new LineShape(x0, y0, x1, y1);
        corner.draw(canvas, wallPaint);
        corner.setLine(x1, y1, x1, y3);
        corner.draw(canvas, wallPaint);
        corner.setLine(x1, y1, x3, y1);
        corner.draw(canvas, wallPaint);
    }

    public void drawOutline(Canvas canvas, CategoryPlot plot, RectShape dataArea) {
        float x0 = dataArea.getX();
        float x1 = x0 + (float)Math.abs(this.xOffset);
        float x3 = dataArea.getMaxX();
        float x2 = x3 - (float)Math.abs(this.xOffset);
        float y0 = dataArea.getMaxY();
        float y1 = y0 - (float)Math.abs(this.yOffset);
        float y3 = dataArea.getMinY();
        float y2 = y3 + (float)Math.abs(this.yOffset);
        PathShape clip = new PathShape();
        clip.moveTo(x0, y0);
        clip.lineTo(x0, y2);
        clip.lineTo(x1, y3);
        clip.lineTo(x3, y3);
        clip.lineTo(x3, y1);
        clip.lineTo(x2, y0);
        clip.closePath();
        PaintType outlinePaintType = plot.getOutlinePaintType();
        if (plot.getOutlineStroke() != 0.0f && outlinePaintType != null) {
            Paint outlinePaint = PaintUtility.createPaint(1, outlinePaintType, plot.getOutlineStroke(), plot.getOutlineEffect());
            outlinePaint.setStrokeWidth(plot.getOutlineStroke());
            clip.draw(canvas, outlinePaint);
        }
    }

    public void drawDomainGridline(Canvas canvas, CategoryPlot plot, RectShape dataArea, double value) {
        float stroke;
        LineShape line1 = null;
        LineShape line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double y0 = value;
            double y1 = value - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxX();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x2, y1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double x0 = value;
            double x1 = value + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x1, y2);
        }
        PaintType paintType = plot.getDomainGridlinePaintType();
        if (paintType == null) {
            paintType = Plot.DEFAULT_OUTLINE_PAINT_TYPE;
        }
        if ((stroke = plot.getDomainGridlineStroke()) != 0.0f) {
            Paint paint = PaintUtility.createPaint(1, paintType, stroke, plot.getOutlineEffect());
            line1.draw(canvas, paint);
            line2.draw(canvas, paint);
        }
    }

    public void drawRangeGridline(Canvas canvas, CategoryPlot plot, ValueAxis axis, RectShape dataArea, double value) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        RectShape adjusted = new RectShape((double)dataArea.getX(), (double)dataArea.getY() + this.getYOffset(), (double)dataArea.getWidth() - this.getXOffset(), (double)dataArea.getHeight() - this.getYOffset());
        LineShape line1 = null;
        LineShape line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double x0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double x1 = x0 + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x1, y2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double y0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double y1 = y0 - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxX();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x2, y1);
        }
        PaintType paintType = plot.getRangeGridlinePaintType();
        if (paintType == null) {
            paintType = Plot.DEFAULT_OUTLINE_PAINT_TYPE;
        }
        float stroke = plot.getRangeGridlineStroke();
        if (plot.getRangeGridlineStroke() != 0.0f) {
            Paint paint = PaintUtility.createPaint(1, paintType, stroke, plot.getOutlineEffect());
            line1.draw(canvas, paint);
            line2.draw(canvas, paint);
        }
    }

    public void drawRangeLine(Canvas canvas, CategoryPlot plot, ValueAxis axis, RectShape dataArea, double value, Paint paint, float stroke) {
        Range range = axis.getRange();
        if (!range.contains(value)) {
            return;
        }
        RectShape adjusted = new RectShape((double)dataArea.getX(), (double)dataArea.getY() + this.getYOffset(), (double)dataArea.getWidth() - this.getXOffset(), (double)dataArea.getHeight() - this.getYOffset());
        LineShape line1 = null;
        LineShape line2 = null;
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            double x0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double x1 = x0 + this.getXOffset();
            double y0 = dataArea.getMaxY();
            double y1 = y0 - this.getYOffset();
            double y2 = dataArea.getMinY();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x1, y2);
        } else if (orientation == PlotOrientation.VERTICAL) {
            double y0 = axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
            double y1 = y0 - this.getYOffset();
            double x0 = dataArea.getMinX();
            double x1 = x0 + this.getXOffset();
            double x2 = dataArea.getMaxX();
            line1 = new LineShape(x0, y0, x1, y1);
            line2 = new LineShape(x1, y1, x2, y1);
        }
        paint.setStrokeWidth(stroke);
        line1.draw(canvas, paint);
        line2.draw(canvas, paint);
    }

    public void drawRangeMarker(Canvas canvas, CategoryPlot plot, ValueAxis axis, Marker marker, RectShape dataArea) {
        RectShape adjusted = new RectShape((double)dataArea.getX(), (double)dataArea.getY() + this.getYOffset(), (double)dataArea.getWidth() - this.getXOffset(), (double)dataArea.getHeight() - this.getYOffset());
        if (marker instanceof ValueMarker) {
            ValueMarker vm = (ValueMarker)marker;
            double value = vm.getValue();
            Range range = axis.getRange();
            if (!range.contains(value)) {
                return;
            }
            PathShape path = null;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                float x = (float)axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
                float y = adjusted.getMaxY();
                path = new PathShape();
                path.moveTo(x, y);
                path.lineTo((float)((double)x + this.getXOffset()), y - (float)this.getYOffset());
                path.lineTo((float)((double)x + this.getXOffset()), (float)((double)adjusted.getMinY() - this.getYOffset()));
                path.lineTo(x, adjusted.getMinY());
                path.closePath();
            } else if (orientation == PlotOrientation.VERTICAL) {
                float y = (float)axis.valueToJava2D(value, adjusted, plot.getRangeAxisEdge());
                float x = dataArea.getX();
                path = new PathShape();
                path.moveTo(x, y);
                path.lineTo(x + (float)this.xOffset, y - (float)this.yOffset);
                path.lineTo((float)((double)adjusted.getMaxX() + this.xOffset), y - (float)this.yOffset);
                path.lineTo(adjusted.getMaxX(), y);
                path.closePath();
            }
            Paint paint = PaintUtility.createPaint(1, marker.getPaintType());
            path.fill(canvas, paint);
            paint = PaintUtility.createPaint(1, marker.getOutlinePaintType(), marker.getOutlineStroke().floatValue(), marker.getOutlineEffect());
            path.draw(canvas, paint);
            String label = marker.getLabel();
            RectangleAnchor anchor = marker.getLabelAnchor();
            if (label != null) {
                paint = PaintUtility.createPaint(1, marker.getLabelPaintType(), marker.getLabelFont());
                RectShape rectShape = new RectShape();
                path.getBounds(rectShape);
                PointF coordinates = this.calculateRangeMarkerTextAnchorPoint(canvas, orientation, dataArea, rectShape, marker.getLabelOffset(), LengthAdjustmentType.EXPAND, anchor);
                TextUtilities.drawAlignedString(label, canvas, coordinates.x, coordinates.y, marker.getLabelTextAnchor(), paint);
            }
        } else {
            super.drawRangeMarker(canvas, plot, axis, marker, adjusted);
        }
    }

    public void drawItem(Canvas canvas, CategoryItemRendererState state, RectShape dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        RectShape adjusted = new RectShape((double)dataArea.getX(), (double)dataArea.getY() + this.getYOffset(), (double)dataArea.getWidth() - this.getXOffset(), (double)dataArea.getHeight() - this.getYOffset());
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = this.calculateBarW0(plot, orientation, adjusted, domainAxis, state, row, column);
        double[] barL0L1 = this.calculateBarL0L1(value);
        if (barL0L1 == null) {
            return;
        }
        RectangleEdge edge = plot.getRangeAxisEdge();
        double transL0 = rangeAxis.valueToJava2D(barL0L1[0], adjusted, edge);
        double transL1 = rangeAxis.valueToJava2D(barL0L1[1], adjusted, edge);
        double barL0 = Math.min(transL0, transL1);
        double barLength = Math.abs(transL1 - transL0);
        RectShape bar = null;
        bar = orientation == PlotOrientation.HORIZONTAL ? new RectShape(barL0, barW0, barLength, state.getBarWidth()) : new RectShape(barW0, barL0, state.getBarWidth(), barLength);
        PaintType itemPaintType = this.getItemFillPaintType(row, column);
        Paint itemPaint = PaintUtility.createPaint(1, itemPaintType);
        bar.fill(canvas, itemPaint);
        double x0 = bar.getMinX();
        double x1 = x0 + this.getXOffset();
        double x2 = bar.getMaxX();
        double x3 = x2 + this.getXOffset();
        double y0 = (double)bar.getMinY() - this.getYOffset();
        double y1 = bar.getMinY();
        double y2 = (double)bar.getMaxY() - this.getYOffset();
        double y3 = bar.getMaxY();
        PathShape bar3dRight = null;
        PathShape bar3dTop = null;
        if (barLength > 0.0) {
            bar3dRight = new PathShape();
            bar3dRight.moveTo((float)x2, (float)y3);
            bar3dRight.lineTo((float)x2, (float)y1);
            bar3dRight.lineTo((float)x3, (float)y0);
            bar3dRight.lineTo((float)x3, (float)y2);
            bar3dRight.closePath();
            itemPaintType = itemPaintType.getDarkerSides();
            Paint rightPaint = PaintUtility.createPaint(1, itemPaintType);
            bar3dRight.fill(canvas, rightPaint);
        }
        bar3dTop = new PathShape();
        bar3dTop.moveTo((float)x0, (float)y1);
        bar3dTop.lineTo((float)x1, (float)y0);
        bar3dTop.lineTo((float)x3, (float)y0);
        bar3dTop.lineTo((float)x2, (float)y1);
        bar3dTop.closePath();
        bar3dTop.fill(canvas, itemPaint);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            Paint paint = PaintUtility.createPaint(1, this.getItemOutlinePaintType(row, column), this.getItemOutlineStroke(row, column).floatValue(), this.getItemOutlineEffect(row, column));
            bar.draw(canvas, paint);
            if (bar3dRight != null) {
                bar3dRight.draw(canvas, paint);
            }
            bar3dTop.draw(canvas, paint);
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(canvas, dataset, row, column, plot, generator, bar, value < 0.0);
        }
        if ((entities = state.getEntityCollection()) != null) {
            PathShape barOutline = new PathShape();
            barOutline.moveTo((float)x0, (float)y3);
            barOutline.lineTo((float)x0, (float)y1);
            barOutline.lineTo((float)x1, (float)y0);
            barOutline.lineTo((float)x3, (float)y0);
            barOutline.lineTo((float)x3, (float)y2);
            barOutline.lineTo((float)x2, (float)y3);
            barOutline.closePath();
            this.addItemEntity(entities, dataset, row, column, barOutline);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BarRenderer3D)) {
            return false;
        }
        BarRenderer3D that = (BarRenderer3D)obj;
        if (this.xOffset != that.xOffset) {
            return false;
        }
        if (this.yOffset != that.yOffset) {
            return false;
        }
        return super.equals(obj);
    }
}

