/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.data.Range;
import org.afree.data.general.DatasetUtilities;
import org.afree.data.xy.IntervalXYDataset;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.util.ObjectUtilities;
import org.afree.util.PaintTypeUtilities;

public class XYErrorRenderer
extends XYLineAndShapeRenderer {
    static final long serialVersionUID = 5162283570955172424L;
    private boolean drawXError = true;
    private boolean drawYError = true;
    private double capLength = 4.0;
    private transient PaintType errorPaintType = null;
    private transient float errorStroke = 0.0f;

    public XYErrorRenderer() {
        super(false, true);
    }

    public boolean getDrawXError() {
        return this.drawXError;
    }

    public void setDrawXError(boolean draw) {
        if (this.drawXError != draw) {
            this.drawXError = draw;
        }
    }

    public boolean getDrawYError() {
        return this.drawYError;
    }

    public void setDrawYError(boolean draw) {
        if (this.drawYError != draw) {
            this.drawYError = draw;
        }
    }

    public double getCapLength() {
        return this.capLength;
    }

    public void setCapLength(double length) {
        this.capLength = length;
    }

    public PaintType getErrorPaintType() {
        return this.errorPaintType;
    }

    public void setErrorPaintType(PaintType paintType) {
        this.errorPaintType = paintType;
    }

    public float getErrorStroke() {
        return this.errorStroke;
    }

    public void setErrorStroke(float stroke) {
        this.errorStroke = stroke;
    }

    public Range findDomainBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtilities.findDomainBounds(dataset, true);
        }
        return null;
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            return DatasetUtilities.findRangeBounds(dataset, true);
        }
        return null;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (pass == 0 && dataset instanceof IntervalXYDataset && this.getItemVisible(series, item)) {
            Paint paint;
            float stroke;
            PaintType paintType;
            LineShape line;
            double adj;
            LineShape cap2;
            LineShape cap1;
            RectangleEdge edge;
            IntervalXYDataset ixyd = (IntervalXYDataset)dataset;
            PlotOrientation orientation = plot.getOrientation();
            if (this.drawXError) {
                double x0 = ixyd.getStartXValue(series, item);
                double x1 = ixyd.getEndXValue(series, item);
                double y = ixyd.getYValue(series, item);
                edge = plot.getDomainAxisEdge();
                double xx0 = domainAxis.valueToJava2D(x0, dataArea, edge);
                double xx1 = domainAxis.valueToJava2D(x1, dataArea, edge);
                double yy = rangeAxis.valueToJava2D(y, dataArea, plot.getRangeAxisEdge());
                cap1 = null;
                cap2 = null;
                adj = this.capLength / 2.0;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new LineShape(xx0, yy, xx1, yy);
                    cap1 = new LineShape(xx0, yy - adj, xx0, yy + adj);
                    cap2 = new LineShape(xx1, yy - adj, xx1, yy + adj);
                } else {
                    line = new LineShape(yy, xx0, yy, xx1);
                    cap1 = new LineShape(yy - adj, xx0, yy + adj, xx0);
                    cap2 = new LineShape(yy - adj, xx1, yy + adj, xx1);
                }
                paintType = this.errorPaintType != null ? this.errorPaintType : this.getItemPaintType(series, item);
                stroke = this.errorStroke != 0.0f ? this.errorStroke : this.getItemStroke(series, item).floatValue();
                paint = PaintUtility.createPaint(1, paintType, stroke, this.getItemEffect(series, item));
                line.draw(canvas, paint);
                cap1.draw(canvas, paint);
                cap2.draw(canvas, paint);
            }
            if (this.drawYError) {
                double y0 = ixyd.getStartYValue(series, item);
                double y1 = ixyd.getEndYValue(series, item);
                double x = ixyd.getXValue(series, item);
                edge = plot.getRangeAxisEdge();
                double yy0 = rangeAxis.valueToJava2D(y0, dataArea, edge);
                double yy1 = rangeAxis.valueToJava2D(y1, dataArea, edge);
                double xx = domainAxis.valueToJava2D(x, dataArea, plot.getDomainAxisEdge());
                cap1 = null;
                cap2 = null;
                adj = this.capLength / 2.0;
                if (orientation == PlotOrientation.VERTICAL) {
                    line = new LineShape(xx, yy0, xx, yy1);
                    cap1 = new LineShape(xx - adj, yy0, xx + adj, yy0);
                    cap2 = new LineShape(xx - adj, yy1, xx + adj, yy1);
                } else {
                    line = new LineShape(yy0, xx, yy1, xx);
                    cap1 = new LineShape(yy0, xx - adj, yy0, xx + adj);
                    cap2 = new LineShape(yy1, xx - adj, yy1, xx + adj);
                }
                paintType = this.errorPaintType != null ? this.errorPaintType : this.getItemPaintType(series, item);
                stroke = this.errorStroke != 0.0f ? this.errorStroke : this.getItemStroke(series, item).floatValue();
                paint = PaintUtility.createPaint(1, paintType, stroke, this.getItemEffect(series, item));
                line.draw(canvas, paint);
                cap1.draw(canvas, paint);
                cap2.draw(canvas, paint);
            }
        }
        super.drawItem(canvas, state, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYErrorRenderer)) {
            return false;
        }
        XYErrorRenderer that = (XYErrorRenderer)obj;
        if (this.drawXError != that.drawXError) {
            return false;
        }
        if (this.drawYError != that.drawYError) {
            return false;
        }
        if (this.capLength != that.capLength) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.errorPaintType, that.errorPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.errorStroke), Float.valueOf(that.errorStroke))) {
            return false;
        }
        return super.equals(obj);
    }
}

