/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import org.json.JSONObject;
import twitter4j.Trend;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.util.ParseUtil;

final class TrendJSONImpl
extends TwitterResponseImpl
implements Trend,
Serializable {
    private String name;
    private String url = null;
    private String query = null;
    private static final long serialVersionUID = 1925956704460743946L;

    TrendJSONImpl(HttpResponse res, JSONObject json, boolean storeJSON) {
        super(res);
        this.name = ParseUtil.getRawString("name", json);
        this.url = ParseUtil.getRawString("url", json);
        this.query = ParseUtil.getRawString("query", json);
    }

    TrendJSONImpl(JSONObject json, Configuration conf) {
        this(null, json, conf.isJSONStoreEnabled());
    }

    TrendJSONImpl(JSONObject json, boolean storeJSON) {
        this(null, json, storeJSON);
    }

    TrendJSONImpl(JSONObject json) {
        this(null, json, false);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)o;
        if (!this.name.equals(trend.getName())) {
            return false;
        }
        if (this.query != null ? !this.query.equals(trend.getQuery()) : trend.getQuery() != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(trend.getUrl()) : trend.getUrl() != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

