package com.td;

import java.util.ArrayList;
import java.util.List;

import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;

import com.td.db.Keyword;
import com.td.db.KeywordDao;
import com.td.service.TrainDelayedServiceImpl;
import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;

public class SearchWordActivity extends BaseActivity {
	private KeywordDao dao;
	private List<Keyword> list = new ArrayList<Keyword>();
	private Keyword curKeyword = null;

	private View mode = null;
	private ListView listView;
	private EditText editText;
	private Button addButton;
	private Button updateButton;
	private Button deleteButton;
	private Button confButton;
	private Button cancelButton;
	private Button closeButton;

	private EditPrefUtil pref = new EditPrefUtil(this);

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.search_word);

		try {
			listView = (ListView) findViewById(R.id.listView81);
			editText = (EditText) findViewById(R.id.editText81);
			addButton = (Button) findViewById(R.id.button81);
			updateButton = (Button) findViewById(R.id.button82);
			deleteButton = (Button) findViewById(R.id.button83);
			confButton = (Button) findViewById(R.id.button84);
			cancelButton = (Button) findViewById(R.id.button85);
			closeButton = (Button) findViewById(R.id.button86);

			dao = KeywordDao.getInstance();
			updateList();

			listView.setOnItemClickListener(new OnItemClickListener() {
				public void onItemClick(AdapterView<?> parent, View view,
						int position, long id) {
					selectedItemView(parent, view, position, id);
				}
			});
			listView.setOnItemSelectedListener(new OnItemSelectedListener() {
				public void onItemSelected(AdapterView<?> parent, View view,
						int position, long id) {
					selectedItemView(parent, view, position, id);
				}

				public void onNothingSelected(AdapterView<?> arg0) {
					;
				}
			});

			editText.addTextChangedListener(new TextWatcher() {
				public void afterTextChanged(Editable editable) {
					changedEditText();
				}

				public void beforeTextChanged(CharSequence s, int start,
						int count, int after) {
					;
				}

				public void onTextChanged(CharSequence s, int start,
						int before, int count) {
					;
				}
			});

			addButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickAddButton();
				}
			});

			updateButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickUpdateButton();
				}
			});

			deleteButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickDeleteButton();
				}
			});

			cancelButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickCancelButton();
				}
			});

			confButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickConfButton();
					TrainDelayedServiceImpl.clearSchedule(
							SearchWordActivity.this, pref);
				}
			});

			closeButton.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					clickCloseButton();
				}
			});
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void updateList() {
		list = dao.search();
		ArrayAdapter<Keyword> adapter = new ArrayAdapter<Keyword>(this,
				android.R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			setStatus(null);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	private void selectedItemView(AdapterView<?> parent, View view,
			int position, long id) {
		curKeyword = list.get(position);
		String text = curKeyword.getText();
		editText.setText(text);

		setStatus(listView);
	}

	private void changedEditText() {
		if (mode == addButton || mode == updateButton) {
			String text = editText.getText().toString();
			confButton.setEnabled((text.length() > 0) ? true : false);
		}
	}

	private void clickAddButton() {
		editText.setText("");

		curKeyword = null;
		setStatus(addButton);
		changedEditText();
	}

	private void clickUpdateButton() {
		setStatus(updateButton);
		changedEditText();
	}

	private void clickDeleteButton() {
		setStatus(deleteButton);
	}

	private void clickCancelButton() {
		curKeyword = null;
		setStatus(cancelButton);
	}

	private void clickConfButton() {
		String text;
		Keyword keyword;
		long id;

		if (mode == addButton) {
			text = editText.getText().toString();
			keyword = new Keyword(text);
			dao.add(keyword);
			updateList();
		} else if (mode == updateButton) {
			text = editText.getText().toString();
			id = curKeyword.getId();
			dao.set(id, text);
			updateList();
		} else if (mode == deleteButton) {
			id = curKeyword.getId();
			dao.delete(id);
			updateList();
		}
		curKeyword = null;
		setStatus(confButton);
	}

	private void clickCloseButton() {
		setStatus(closeButton);
		this.finish();
	}

	private void setStatus(View view) {
		if (view == null) {
			listView.setEnabled(true);
			editText.setVisibility(View.GONE);
			editText.setEnabled(false);
			addButton.setVisibility(View.VISIBLE);
			addButton.setEnabled(true);
			updateButton.setVisibility(View.VISIBLE);
			updateButton.setEnabled(false);
			deleteButton.setVisibility(View.VISIBLE);
			deleteButton.setEnabled(false);
			confButton.setVisibility(View.GONE);
			confButton.setEnabled(true);
			cancelButton.setVisibility(View.GONE);
			closeButton.setVisibility(View.VISIBLE);
		} else if (view == listView) {
			editText.setVisibility(View.VISIBLE);
			editText.setEnabled(false);
			addButton.setEnabled(false);
			updateButton.setEnabled(true);
			deleteButton.setEnabled(true);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == addButton) {
			listView.setEnabled(false);
			editText.setVisibility(View.VISIBLE);
			editText.setEnabled(true);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == updateButton) {
			listView.setEnabled(false);
			editText.setEnabled(true);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == deleteButton) {
			listView.setEnabled(false);
			addButton.setVisibility(View.GONE);
			updateButton.setVisibility(View.GONE);
			deleteButton.setVisibility(View.GONE);
			confButton.setVisibility(View.VISIBLE);
			cancelButton.setVisibility(View.VISIBLE);
			closeButton.setVisibility(View.GONE);
		} else if (view == confButton) {
			setStatus(null);
		} else if (view == cancelButton) {
			setStatus(null);
		} else if (view == closeButton) {
			setStatus(null);
		}
		mode = view;
	}
}
