package com.td;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

import com.td.utility.BaseActivity;
import com.td.utility.Debug;
import com.td.utility.StatusFlag;
import com.td.utility.StatusFlagFactory;
import com.td.wait.IWating;

public class WaitActivity extends BaseActivity {
	public static final String CLASS = "CLASS";
	public static final String MESSAGE0 = "MESSAGE0";
	public static final String MESSAGE1 = "MESSAGE1";
	public static final String MESSAGE2 = "MESSAGE2";
	public static final String MESSAGE3 = "MESSAGE3";

	public static final int ID_OK = 1;
	public static final int ID_NG = 0;
	public static final int ID_NONE = -1;

	private TextView textView;
	private WaitView waitView;
	private Button button;

	private String clazzName;
	private String message0;
	private String message1;
	private String message2;
	private String message3;

	private static IWating waiting = null;
	private Thread thread = null;

	private StatusFlag waSf = StatusFlagFactory.getInstance().getStatusFlag(
			this, StatusFlagFactory.Type.WAIT_ACTIVITY);

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.wait);

		try {
			textView = (TextView) findViewById(R.id.textViewa1);
			waitView = (WaitView) findViewById(R.id.waitViewa1);
			button = (Button) findViewById(R.id.buttona1);

			button.setOnClickListener(new OnClickListener() {
				public void onClick(View v) {
					WaitActivity.this.setResult(ID_OK);
					WaitActivity.this.finish();
				}
			});

			Bundle extras = getIntent().getExtras();
			clazzName = extras.getString(CLASS);
			message0 = extras.getString(MESSAGE0);
			message1 = extras.getString(MESSAGE1);
			message2 = extras.getString(MESSAGE2);
			message3 = extras.getString(MESSAGE3);

			waitView.setMessage(message0);

			if (waSf.isOff()) {
				textView.setText(message1);
			} else if (waSf.isRdy()) {
				textView.setText(message1);
			} else if (waSf.isOn()) {
				textView.setText(message2);
			} else {
				textView.setText(message3);
			}

			if (waSf.isOff() || waiting == null) {
				if (!waSf.isOff() && waiting == null) {
					// vZX~畜Ȁꍇ
					waSf.setOff();
				}

				Class<IWating> clazz;
				try {
					clazz = (Class<IWating>) Class.forName(clazzName);
					IWating obj = clazz.newInstance();
					waiting = obj;
				} catch (Exception e) {
					this.setResult(ID_NG);
					this.finish();
					return;
				}

				waiting.setContext(this);
				waitView.start();
				button.setEnabled(false);
			} else if (waSf.isRdy()) {
				waiting.setContext(this);
				waitView.start();
				button.setEnabled(false);
			} else {
				waiting.setContext(this);
				waitView.stop();
				waiting = null;
			}
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onStart() {
		super.onStart();

		try {
			if (waiting != null && waSf.isOff()) {
				waSf.setRdy();
				waiting.onStart();
			}

			thread = new Thread() {
				public void run() {
					while (thread != null) {
						if (waiting != null) {
							int status = waiting.getStatus();
							if (status != ID_NONE) {
								handler.sendMessage(handler
										.obtainMessage(status));
								break;
							}
						}
						try {
							Thread.sleep(3 * 1000);
						} catch (InterruptedException e) {
							;
						}
					}
				}
			};
			thread.start();
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	@Override
	protected void onStop() {
		super.onStop();

		thread = null;
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();

		try {
			if (waitView != null) {
				// onCreateŐVɍ쐬邽߁AwaitView͎~߂ĂȂ΂Ȃ
				waitView.stop();
				waitView = null;
			}
			thread = null;
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);
		}
	}

	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			// ߂{^΍
			waiting.onStop();
			waiting = null;
		}
		return super.onKeyDown(keyCode, event);
	}

	private Handler handler = new Handler() {
		public void handleMessage(android.os.Message msg) {
			try {
				Debug.d(this, "handleMessage start");
				int code = msg.what;

				switch (code) {
				case ID_OK:
				case ID_NG:
					if (waitView != null) {
						waitView.stop();
						waitView = null;
					}
					textView.setText((code == ID_OK) ? message2 : message3);
					button.setEnabled(true);
					if (code == ID_OK) {
						waSf.setOn();
					} else {
						waSf.setErr();
					}
					if (waiting != null) {
						waiting.onStop();
						waiting.setContext(null);
						waiting = null;
					}
					break;
				default:
					super.handleMessage(msg);
					break;
				}
			} catch (Exception e) {
				Debug.d(this, null, e);
				showDialog(this, e);
			} finally {
				Debug.d(this, "handleMessage end");
			}
		}
	};

	public static void init(Context context) {
		StatusFlag waSf = StatusFlagFactory.getInstance().getStatusFlag(
				context, StatusFlagFactory.Type.WAIT_ACTIVITY);
		waSf.setOff();
	}
}
