package com.td;

import com.td.utility.Debug;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;

public class WaitView extends View {
	private boolean flag = false;
	private int x = 0;
	private int y = 0;
	private Thread thread = null;
	private Paint paint = new Paint();
	private String message = "";
	
	public WaitView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public void setMessage(String message){
		this.message = message;
	}
	
	public void start(){
		initialize();		
	}
	
	public void stop(){
		thread = null;
	}
	
	private void initialize() {
		final Handler handler = new Handler();
		thread = new Thread() {
			public void run() {
				Debug.d(this, "WaitView start");
				while (thread != null) {
					try {
						handler.post(new Runnable() {
							public void run() {
								WaitView.this.invalidate();
							}
						});
						Thread.sleep(100);
					} catch (InterruptedException e) {
						;
					}
				}
				handler.post(new Runnable() {
					public void run() {
						WaitView.this.invalidate();
					}
				});
				Debug.d(this, "WaitView end");
			}
		};
		thread.start();
	}

	@Override
	protected void onDraw(Canvas canvas) {
		if (thread == null){
			return;
		}
		int h = getHeight();
		paint.setColor(Color.BLACK);
		paint.setTextSize(h / 10);
		int w = (int)paint.measureText(message);

		if (!flag) {
			x = getWidth();
			y = getHeight() / 2;
			flag = true;
		}
		else if (x < -w){
			x = getWidth();			
		}
		canvas.drawText(message, x, y, paint);
		x -= 5;
	}

	@Override
	protected void onDetachedFromWindow() {
		super.onDetachedFromWindow();
	}
	
	
}
