package com.td.utility;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
	public static final int WEEK = 7;
	public static final int HM_MIN = 0;
	public static final int HM_MAX = 9999;
	// ĎԊu()
	public static final int LEN = 10;
	private static DecimalFormat fmt2 = new DecimalFormat("00");
	
	public static int getYmd(Date date){
		int y = date.getYear();
		int m = date.getMonth();
		int d = date.getDate();

		return getYmd(y, m, d);
	}

	public static int getYmd(int y, int m, int d){
		return (1900 + y) * 10000 + (m + 1) * 100 + d;		
	}
	
	public static int getHm(Date date){
		int h = date.getHours();
		int m = date.getMinutes();

		return getHm(h, m);
	}

	public static int getHm(int h, int m){
		return h * 100 + m;		
	}
	
	public static String toName(int index){
		String[] names = {
				"", "", "", "", "", "", "y"
		};
		return names[index];
	}
	
	public static String formatted(Calendar cal){
		Date d = cal.getTime();
		int ymd = getYmd(d);
		int hm = getHm(d);
		return formattedYmd(ymd) + " " + formattedHm(hm);
	}
	
	public static String formatted(long t){
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(t);
		return formatted(cal);
	}
	
	public static String formattedHm(int hm){
		StringBuffer sb = new StringBuffer();
		sb.append(fmt2.format((int) (hm / 100)));
		sb.append(":");
		sb.append(fmt2.format((int) (hm % 100)));
		return sb.toString();
	}

	public static String formattedDate(int ymd, int from, int to){
		StringBuffer sb = new StringBuffer();
		sb.append(formattedYmd(ymd));
		sb.append(" ");
		sb.append(formattedHm(from));
		sb.append(" - ");
		sb.append(formattedHm(to));
		return sb.toString();
	}
	
	public static String formattedYmd(int ymd){
		StringBuffer sb = new StringBuffer();
		sb.append(ymd / 10000);
		sb.append("/");
		sb.append(fmt2.format((int) (ymd % 10000 / 100)));
		sb.append("/");
		sb.append(fmt2.format((int) (ymd % 100)));
		return sb.toString();
	}

	public static Calendar getTime(Date date, int i, int from) {
		// (date)AíAfrom
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_MONTH, i);
		cal.set(Calendar.HOUR_OF_DAY, from / 100);
		cal.set(Calendar.MINUTE, from % 100);
		
		return cal;
	}
	
	public static Calendar getCalendar(int y, int m, int d, int h, int mi){
		Calendar cal = Calendar.getInstance();
		cal.set(y, m - 1, d, h, mi);
		return cal;
	}
	
	public static Calendar getCalendar(int ymd, int hm){
		int y = getY(ymd);
		int m = getM(ymd);
		int d = getD(ymd);
		int h = getH(hm);
		int mi = getMi(hm);
		
		Calendar cal = Calendar.getInstance();
		cal.set(y, m - 1, d, h, mi);
		return cal;
	}
	
	public static Date getDate(long t){
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(t);
		return cal.getTime();		
	}
	
	public static int getWeek(Calendar cal){
		return cal.get(Calendar.DAY_OF_WEEK) - 1;
	}
	
	public static int getYear(Calendar cal){
		return cal.get(Calendar.YEAR);
	}
	
	public static int getMonth(Calendar cal){
		return cal.get(Calendar.MONTH) + 1;
	}
	
	public static int getDay(Calendar cal){
		return cal.get(Calendar.DAY_OF_MONTH);
	}
	
	public static int getHour(Calendar cal){
		return cal.get(Calendar.HOUR_OF_DAY);
	}
	
	public static int getMinute(Calendar cal){
		return cal.get(Calendar.MINUTE);
	}
	
	public static String getHour(String t){
		return t.substring(0, 2);
	}
	
	public static String getMinute(String t){
		return t.substring(3, 5);
	}
	
	public static int getY(int ymd){
		return ymd / 10000;
	}
	
	public static int getM(int ymd){
		return (ymd % 10000) / 100;
	}
	
	public static int getD(int ymd){
		return ymd % 100;
	}

	public static int getH(int hm){
		return hm / 100;
	}

	public static int getMi(int hm){
		return hm % 100;
	}	
}
