/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.net.sourceforge.yamlbeans;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.Beans;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.emitter.Emitter;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.emitter.EmitterException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.AliasEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.DocumentStartEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.Event;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.MappingStartEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.ScalarEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.parser.SequenceStartEvent;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.scalar.ScalarSerializer;
import java.beans.IntrospectionException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlWriter {
    private final YamlConfig config;
    private final Emitter emitter;
    private boolean started;
    private Map<Class, Object> defaultValuePrototypes = new HashMap<Class, Object>();
    private final List queuedObjects = new ArrayList();
    private final Map<Object, Integer> referenceCount = new IdentityHashMap<Object, Integer>();
    private final Map<Object, String> anchoredObjects = new HashMap<Object, String>();
    private int nextAnchor = 1;
    private boolean isRoot;

    public YamlWriter(Writer writer) {
        this(writer, new YamlConfig());
    }

    public YamlWriter(Writer writer, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.emitter = new Emitter(writer, yamlConfig.writeConfig.emitterConfig);
    }

    public void write(Object object) throws YamlException {
        if (this.config.writeConfig.autoAnchor) {
            this.countObjectReferences(object);
            this.queuedObjects.add(object);
            return;
        }
        this.writeInternal(object);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    private void writeInternal(Object object) throws YamlException {
        try {
            if (!this.started) {
                this.emitter.emit(Event.STREAM_START);
                this.started = true;
            }
            this.emitter.emit(new DocumentStartEvent(this.config.writeConfig.explicitFirstDocument, null, null));
            this.isRoot = true;
            this.writeValue(object, this.config.writeConfig.writeRootTags ? null : object.getClass(), null);
            this.emitter.emit(Event.DOCUMENT_END_FALSE);
        }
        catch (EmitterException emitterException) {
            throw new YamlException("Error writing YAML.", emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException("Error writing YAML.", iOException);
        }
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void clearAnchors() throws YamlException {
        for (Object e : this.queuedObjects) {
            this.writeInternal(e);
        }
        this.queuedObjects.clear();
        this.referenceCount.clear();
        this.nextAnchor = 1;
    }

    public void close() throws YamlException {
        this.clearAnchors();
        this.defaultValuePrototypes.clear();
        try {
            this.emitter.emit(Event.STREAM_END);
            this.emitter.close();
        }
        catch (EmitterException emitterException) {
            throw new YamlException(emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeValue(Object object, Class clazz, Class clazz2) throws EmitterException, IOException, YamlException {
        Set<Beans.Property> set;
        void var8_14;
        boolean bl;
        boolean bl2 = this.isRoot;
        this.isRoot = false;
        if (object == null) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, null, '\u0000'));
            return;
        }
        Class<?> clazz3 = object.getClass();
        boolean bl3 = bl = clazz == null;
        if (bl) {
            clazz = clazz3;
        }
        if (Beans.isScalar(clazz)) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, String.valueOf(object), '\u0000'));
            return;
        }
        if (object instanceof Enum) {
            this.writeValue(((Enum)object).name(), null, null);
            return;
        }
        for (Map.Entry<Class, ScalarSerializer> object22 : this.config.scalarSerializers.entrySet()) {
            if (!object22.getKey().isAssignableFrom(clazz3)) continue;
            ScalarSerializer scalarSerializer = object22.getValue();
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, scalarSerializer.write(object), '\u0000'));
            return;
        }
        Object object3 = null;
        if (this.config.writeConfig.autoAnchor) {
            Integer n = this.referenceCount.get(object);
            if (n == null) {
                this.emitter.emit(new AliasEvent(this.anchoredObjects.get(object)));
                return;
            }
            if (n > 1) {
                this.referenceCount.remove(object);
                object3 = String.valueOf(this.nextAnchor++);
                this.anchoredObjects.put(object, (String)object3);
            }
        }
        Object var8_11 = null;
        boolean bl4 = false;
        if (bl || clazz3 != clazz) {
            String string;
            bl4 = true;
            if ((bl || clazz == List.class) && clazz3 == ArrayList.class) {
                bl4 = false;
            }
            if ((bl || clazz == Map.class) && clazz3 == HashMap.class) {
                bl4 = false;
            }
            if (clazz == Set.class && clazz3 == HashSet.class) {
                bl4 = false;
            }
            if (bl4 && (string = this.config.classNameToTag.get(clazz3.getName())) == null) {
                String string2 = clazz3.getName();
            }
        }
        if (object instanceof Collection) {
            this.emitter.emit(new SequenceStartEvent((String)object3, (String)var8_14, !bl4, false));
            for (Object e : (Collection)object) {
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = e.getClass();
                }
                this.writeValue(e, clazz2, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        if (object instanceof Map) {
            this.emitter.emit(new MappingStartEvent((String)object3, (String)var8_14, !bl4, false));
            Iterator iterator = ((Map)object).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, String.valueOf(entry2.getKey()), '\u0000'));
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = entry2.getValue().getClass();
                }
                this.writeValue(entry2.getValue(), clazz2, null);
            }
            this.emitter.emit(Event.MAPPING_END);
            return;
        }
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            this.emitter.emit(new SequenceStartEvent((String)object3, null, true, false));
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.writeValue(Array.get(object, i), clazz2, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        Object object2 = null;
        if (!this.config.writeConfig.writeDefaultValues && (object2 = this.defaultValuePrototypes.get(clazz3)) == null) {
            try {
                object2 = Beans.createObject(clazz3, this.config);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new YamlException("Error creating object prototype to determine default values.", invocationTargetException);
            }
            this.defaultValuePrototypes.put(clazz3, object2);
        }
        try {
            set = Beans.getProperties(clazz3);
            if (set.isEmpty()) {
                throw new YamlException("No public fields or getter methods are available to serialize class: " + clazz3.getName());
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException("Error inspecting class: " + clazz3.getName(), introspectionException);
        }
        this.emitter.emit(new MappingStartEvent((String)object3, (String)var8_14, !bl4, false));
        for (Beans.Property property : set) {
            try {
                Object object4;
                Object object5 = property.get(object);
                if (object2 != null) {
                    object4 = property.get(object2);
                    if (object5 == null && object4 == null || object5 != null && object4 != null && object4.equals(object5)) continue;
                }
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, property.getName(), '\u0000'));
                object4 = this.config.propertyToElementType.get(property);
                this.writeValue(object5, property.getType(), (Class)object4);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + clazz3.getName(), exception);
            }
        }
        this.emitter.emit(Event.MAPPING_END);
    }

    private void countObjectReferences(Object object) throws YamlException {
        Set<Beans.Property> set;
        if (object == null || Beans.isScalar(object.getClass())) {
            return;
        }
        Integer n = this.referenceCount.get(object);
        if (n == null) {
            n = 0;
        }
        this.referenceCount.put(object, n + 1);
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.countObjectReferences(e);
            }
            return;
        }
        if (object instanceof Map) {
            for (Object v : ((Map)object).values()) {
                this.countObjectReferences(v);
            }
            return;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            for (int i = 0; i < n2; ++i) {
                this.countObjectReferences(Array.get(object, i));
            }
            return;
        }
        try {
            set = Beans.getProperties(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException("Error inspecting class: " + object.getClass().getName(), introspectionException);
        }
        for (Beans.Property property : set) {
            Object object2;
            if (Beans.isScalar(property.getType())) continue;
            try {
                object2 = property.get(object);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + object.getClass().getName(), exception);
            }
            this.countObjectReferences(object2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.writeConfig.setAutoAnchor(true);
        YamlReader yamlReader = new YamlReader(new FileReader("test/test.yml"));
        YamlWriter yamlWriter = new YamlWriter(new OutputStreamWriter(System.out));
        yamlWriter.write(yamlReader.read());
    }
}

