/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class UpdateCheckResults {
    private static final VersionComparator COMPARATOR = new VersionComparator();
    private final Version localVersion;
    private final Version remoteVersion;

    UpdateCheckResults(Version localVersion, Version remoteVersion) {
        this.localVersion = localVersion;
        this.remoteVersion = remoteVersion;
    }

    public Version getLocalVersion() {
        return this.localVersion;
    }

    public Version getRemoteVersion() {
        return this.remoteVersion;
    }

    public boolean isNewerReleaseAvailable() {
        String localRelease = this.localVersion.getRelease();
        String remoteRelease = this.remoteVersion.getRelease();
        if (localRelease != null && remoteRelease != null) {
            return COMPARATOR.compare(remoteRelease, localRelease) > 0;
        }
        return false;
    }

    public boolean isNewerApiVersionAvailable() {
        Set<String> localApiVersions = this.localVersion.getApiVersions();
        Set<String> remoteApiVersions = this.remoteVersion.getApiVersions();
        if (localApiVersions != null && remoteApiVersions != null) {
            if (localApiVersions.isEmpty()) {
                return false;
            }
            ArrayList<String> sortedApiVersions = new ArrayList<String>(remoteApiVersions);
            Collections.sort(sortedApiVersions, COMPARATOR);
            String largestVersion = (String)sortedApiVersions.get(sortedApiVersions.size() - 1);
            return !localApiVersions.contains(largestVersion);
        }
        return false;
    }

    public boolean isLocalApiVersionNoLongerSupported() {
        Set<String> localApiVersions = this.localVersion.getApiVersions();
        Set<String> remoteApiVersions = this.remoteVersion.getApiVersions();
        if (localApiVersions != null && remoteApiVersions != null) {
            if (localApiVersions.isEmpty()) {
                return false;
            }
            return Collections.disjoint(localApiVersions, remoteApiVersions);
        }
        return false;
    }

    public boolean isApiVersionSupportedRemotely(String apiVersion) {
        Set<String> remoteApiVersions = this.remoteVersion.getApiVersions();
        if (remoteApiVersions != null) {
            return remoteApiVersions.contains(apiVersion);
        }
        return true;
    }

    public boolean isApiVersionSupportedLocally(String apiVersion) {
        Set<String> localApiVersions = this.localVersion.getApiVersions();
        if (localApiVersions != null) {
            return localApiVersions.contains(apiVersion);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VersionComparator
    implements Comparator<String> {
        @Override
        public int compare(String string1, String string2) throws NumberFormatException {
            String[] array1 = string1.split("\\.");
            String[] array2 = string2.split("\\.");
            for (int i = 0; i < Math.max(array1.length, array2.length); ++i) {
                int i2;
                int i1 = i < array1.length ? Integer.parseInt(array1[i]) : 0;
                int n = i2 = i < array2.length ? Integer.parseInt(array2[i]) : 0;
                if (i1 == i2) continue;
                return i1 - i2;
            }
            return 0;
        }
    }
}

