/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronXmlReader
extends AbstractConfigXmlReader<CronXml> {
    private static final String FILENAME = "WEB-INF/cron.xml";
    private static final String CRONENTRIES_TAG = "cronentries";
    private static final String CRON_TAG = "cron";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String TARGET_TAG = "target";
    private static final String TIMEZONE_TAG = "timezone";
    private static final String URL_TAG = "url";

    public CronXmlReader(String appDir) {
        super(appDir, false);
    }

    public CronXml readCronXml() {
        return (CronXml)this.readConfigXml();
    }

    @Override
    protected CronXml processXml(InputStream is) {
        final CronXml cronXml = new CronXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean first = true;
            CronXml.Entry entry;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!CronXmlReader.CRONENTRIES_TAG.equalsIgnoreCase(node.getTag())) {
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " does not contain <" + CronXmlReader.CRONENTRIES_TAG + ">");
                        }
                        if (!this.first) {
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " contains multiple <" + CronXmlReader.CRONENTRIES_TAG + ">");
                        }
                        this.first = false;
                        break;
                    }
                    case 1: {
                        if (CronXmlReader.CRON_TAG.equalsIgnoreCase(node.getTag())) {
                            this.entry = cronXml.addNewEntry();
                            break;
                        }
                        throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " contains <" + node.getTag() + "> instead of <" + CronXmlReader.CRON_TAG + "/>");
                    }
                    case 2: {
                        assert (this.entry != null);
                        if (CronXmlReader.DESCRIPTION_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setDescription((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has bad contents in <" + CronXmlReader.DESCRIPTION_TAG + ">");
                        }
                        if (CronXmlReader.URL_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setUrl((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has bad contents in <" + CronXmlReader.URL_TAG + ">");
                        }
                        if (CronXmlReader.SCHEDULE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setSchedule((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has bad contents in <" + CronXmlReader.SCHEDULE_TAG + ">");
                        }
                        if (CronXmlReader.TIMEZONE_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setTimezone((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has bad contents in <" + CronXmlReader.TIMEZONE_TAG + ">");
                        }
                        if (CronXmlReader.TARGET_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.entry.setTarget((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has bad contents in <" + CronXmlReader.TARGET_TAG + ">");
                        }
                        throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " contains unknown <" + node.getTag() + "> inside <" + CronXmlReader.CRON_TAG + "/>");
                    }
                    default: {
                        throw new AppEngineConfigException(CronXmlReader.this.getFilename() + " has a syntax error; node <" + node.getTag() + "> is too deeply nested to be valid.");
                    }
                }
            }
        }, is);
        cronXml.validateLastEntry();
        return cronXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

