/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Asset;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;

class AssetProtoConverter
extends Converter<Asset, ConversionServicePb.AssetInfo> {
    AssetProtoConverter() {
    }

    @Override
    public ConversionServicePb.AssetInfo doForward(Asset asset) {
        Preconditions.checkArgument(!StringUtil.isEmptyOrWhitespace(asset.getMimeType()), "Asset mime type should not be null, empty or comprises only whitespaces");
        return ConversionServicePb.AssetInfo.newBuilder().setMimeType(asset.getMimeType()).setData(ByteString.copyFrom(asset.getData())).setName(asset.getName()).build();
    }

    @Override
    public Asset doBackward(ConversionServicePb.AssetInfo assetPb) {
        return new Asset(assetPb.getMimeType(), assetPb.getData().toByteArray(), assetPb.getName());
    }
}

