/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;

public class SortSpecChecker {
    public static final int MAXIMUM_LIMIT = 1000;
    public static final int DEFAULT_LIMIT = 1000;

    public static int checkLimit(int limit) {
        Preconditions.checkArgument(limit >= 0 && limit <= 1000, "The limit %d must be between 0 and %d", limit, 1000);
        return limit;
    }

    public static SearchServicePb.ScorerSpec checkValid(SearchServicePb.ScorerSpec spec) {
        SortSpecChecker.checkLimit(spec.getLimit());
        return spec;
    }

    public static SearchServicePb.SortSpec checkValid(SearchServicePb.SortSpec spec) {
        Preconditions.checkArgument(!spec.hasDefaultValueText() || !spec.hasDefaultValueNumeric(), "at most one of default string or numeric value can be specified");
        if (spec.hasDefaultValueText()) {
            FieldChecker.checkText(spec.getDefaultValueText());
        }
        return spec;
    }
}

