/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminImpl;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.util.ClientCookieManager;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppAdminFactory {
    static final int MAX_FILE_UPLOAD = 10000000;
    private static final String JAVA_CMD_PROP = "appengine.java";
    private static final String JAVAC_CMD_PROP = "appengine.javac";
    private ApplicationProcessingOptions appOptions = new ApplicationProcessingOptions();
    private Class<? extends AppVersionUpload> appVersionUploadClass = AppVersionUpload.class;

    public AppAdmin createAppAdmin(ConnectOptions options, Application app, PrintWriter errorWriter) {
        return new AppAdminImpl(options, app, errorWriter, this.appOptions, this.appVersionUploadClass);
    }

    public void setAppVersionUploadClass(Class<? extends AppVersionUpload> klass) {
        this.appVersionUploadClass = klass;
    }

    public void setJavaExecutable(File java) {
        this.appOptions.setJavaExecutable(java);
    }

    public void setJavaCompiler(File javac) {
        this.appOptions.setJavaCompiler(javac);
    }

    public void setCompileJsps(boolean flag) {
        this.appOptions.setCompileJsps(flag);
    }

    public void setJarSplittingEnabled(boolean doSplit) {
        this.appOptions.setMaxJarSize(doSplit ? 10000000 : -1);
    }

    public void setJarSplittingExcludes(Set<String> jarSplittingExcludeSuffixes) {
        this.appOptions.setJarSplittingExcludes(jarSplittingExcludeSuffixes);
    }

    public void setCompileEncoding(String compileEncoding) {
        Charset.forName(compileEncoding);
        this.appOptions.setCompileEncoding(compileEncoding);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationProcessingOptions {
        private File java;
        private File javac;
        private boolean compileJsps = true;
        private String compileEncoding = "UTF-8";
        private int maxJarSize = -1;
        private Set<String> splitExcludes = Collections.emptySet();

        ApplicationProcessingOptions() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public File getJavaExecutable() {
            if (this.java != null) {
                return this.java;
            }
            String javaProp = System.getProperty(AppAdminFactory.JAVA_CMD_PROP);
            if (javaProp != null) {
                this.java = new File(javaProp);
                if (this.java.exists()) return this.java;
                if (!Utility.isOsWindows() || javaProp.endsWith(".exe") || !new File(javaProp + ".exe").exists()) throw new IllegalStateException("cannot find java executable \"" + javaProp + "\"");
                this.java = new File(javaProp + ".exe");
                return this.java;
            } else {
                String javaHome = System.getProperty("java.home");
                String javaCmd = javaHome + File.separator + "bin" + File.separator + "java" + (Utility.isOsWindows() ? ".exe" : "");
                this.java = new File(javaCmd);
                if (this.java.exists()) return this.java;
                this.java = null;
                throw new IllegalStateException("cannot find java executable based on java.home, tried \"" + javaCmd + "\"");
            }
        }

        void setJavaExecutable(File java) {
            this.java = java;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public File getJavaCompiler() {
            if (this.javac != null) {
                return this.javac;
            }
            String javacProp = System.getProperty(AppAdminFactory.JAVAC_CMD_PROP);
            if (javacProp != null) {
                this.javac = new File(javacProp);
                if (this.javac.exists()) return this.javac;
                if (!Utility.isOsWindows() || javacProp.endsWith(".exe") || !new File(javacProp + ".exe").exists()) throw new IllegalStateException("cannot find javac executable \"" + javacProp + "\"");
                this.javac = new File(javacProp + ".exe");
                return this.javac;
            } else {
                String javaHome;
                String javacDir = javaHome = System.getProperty("java.home");
                String javacCmd = javacDir + File.separator + "bin" + File.separator + "javac" + (Utility.isOsWindows() ? ".exe" : "");
                this.javac = new File(javacCmd);
                if (this.javac.exists()) return this.javac;
                this.javac = null;
                javacDir = new File(javaHome).getParentFile().getPath();
                String javacCmd2 = javacDir + File.separator + "bin" + File.separator + "javac" + (Utility.isOsWindows() ? ".exe" : "");
                this.javac = new File(javacCmd2);
                if (this.javac.exists()) return this.javac;
                this.javac = null;
                throw new IllegalStateException("cannot find javac executable based on java.home, tried \"" + javacCmd + "\" and \"" + javacCmd2 + "\"");
            }
        }

        void setJavaCompiler(File javac) {
            this.javac = javac;
        }

        public boolean isCompileJspsSet() {
            return this.compileJsps;
        }

        void setCompileJsps(boolean doJsps) {
            this.compileJsps = doJsps;
        }

        public String getCompileEncoding() {
            return this.compileEncoding;
        }

        public void setCompileEncoding(String compileEncoding) {
            this.compileEncoding = compileEncoding;
        }

        public boolean isSplitJarsSet() {
            return this.maxJarSize > 0;
        }

        public int getMaxJarSize() {
            return this.maxJarSize;
        }

        void setMaxJarSize(int max) {
            this.maxJarSize = max;
        }

        void setJarSplittingExcludes(Set<String> jarSplittingExcludeSuffixes) {
            this.splitExcludes = jarSplittingExcludeSuffixes;
        }

        public Set<String> getJarSplittingExcludes() {
            return this.splitExcludes;
        }
    }

    public static class ConnectOptions {
        private String userId;
        private String server = SdkInfo.getDefaultServer();
        private String host;
        private String sdkRoot;
        boolean keepUpload;
        private ClientCookieManager cookies;
        private PasswordPrompt passwordPrompt;
        private boolean secure = true;
        private String oauthToken;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public PasswordPrompt getPasswordPrompt() {
            return this.passwordPrompt;
        }

        public void setPasswordPrompt(PasswordPrompt prompt) {
            this.passwordPrompt = prompt;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setRetainUploadDir(boolean flag) {
            this.keepUpload = flag;
        }

        public boolean getRetainUploadDir() {
            return this.keepUpload;
        }

        public String getSdkRoot() {
            return this.sdkRoot;
        }

        public void setSdkRoot(String sdkRoot) {
            this.sdkRoot = sdkRoot;
        }

        public ClientCookieManager getCookies() {
            return this.cookies;
        }

        public void setCookies(ClientCookieManager cookies) {
            this.cookies = cookies;
        }

        public boolean getSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public String getOauthToken() {
            return this.oauthToken;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectOptions that = (ConnectOptions)o;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
                return false;
            }
            if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
                return false;
            }
            return !(this.sdkRoot != null ? !this.sdkRoot.equals(that.sdkRoot) : that.sdkRoot != null);
        }

        public int hashCode() {
            int result = this.userId != null ? this.userId.hashCode() : 0;
            result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.sdkRoot != null ? this.sdkRoot.hashCode() : 0);
            return result;
        }
    }

    public static interface PasswordPrompt {
        public String getPassword();
    }
}

