/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ApiVersionFinder {
    private static final String DESIRED_VENDOR_ID = "com.google";
    private static final String API_PACKAGE_NAME = "com/google/appengine/api/";

    public static void main(String[] args) throws IOException {
        ApiVersionFinder finder = new ApiVersionFinder();
        String apiVersion = finder.findApiVersion(args[0]);
        if (apiVersion == null) {
            System.exit(1);
        }
        System.out.println(apiVersion);
        System.exit(0);
    }

    public String findApiVersion(String fileName) throws IOException {
        return this.findApiVersion(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findApiVersion(File inputJar) throws IOException {
        JarFile jarFile = new JarFile(inputJar);
        try {
            Attributes attr;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attr = manifest.getAttributes(API_PACKAGE_NAME)) != null) {
                String vendorId = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                if (!DESIRED_VENDOR_ID.equals(vendorId)) {
                    String string = null;
                    return string;
                }
                String string = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException ex) {}
        }
    }
}

