# -*- coding: utf-8 -*-
# 有効期間があるモデルを抽象化するモジュール。
module ActiveRecord
  module TimeFrame
    def self.included(base)
      base.extend(ClassMethods)
    end

    # FIXME 最大値を定義する。
    INCEPTION_MIN = {
      :string    => "00000000",
      :datetime  => nil, # :datetime, :timestamp
      :time      => nil,
      :date      => nil,
    }
    EXPIRY_MAX = {
      :string    => "99999999",
      :datetime  => nil, # :datetime, :timestamp
      :time      => nil,
      :date      => nil,
    }

    module ClassMethods
      NOW_HASH = {
        :string    => lambda{ Time.now.utc.strftime("%Y%m%d") },
        :datetime  => lambda{ DateTime.now }, # :datetime, :timestamp
        :time      => lambda{ Time.now },
        :date      => lambda{ Date.today },
      }
      # <tt>time_frame</tt> を呼び出すことで、
      # <tt>unexpired</tt> という named scope を定義する。
      #
      # options
      #  <tt>:inception_column</tt> : 有効期限の開始を表すカラム名を指定する。デフォルトは "inception"
      #  <tt>:expiry_column</tt> : 有効期限の終了を表すカラム名を指定する。デフォルトは "expiry"
      #  <tt>:now</tt> : 基準となる値を計算する Proc オブジェクト指定する。
      def time_frame(options = {})
        inception_column = options[:inception_column] || 'inception'
        expiry_column = options[:expiry_column] || 'expiry'
        class_eval do
          named_scope :unexpired, lambda{
            now = (options[:now] || NOW_HASH[self.columns_hash[inception_column].type]).call
            t = self.table_name
            cond = ["#{t}.#{inception_column} <= :now AND :now <= #{t}.#{expiry_column}",
                    { :now => now }]
            { :conditions => cond }
          }
        end
      end
    end
  end
end

